/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific.data;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Reflection;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;

public record AttributeData(class_1320 attribute, double value, Optional<AttributeModifierData> modifierData) {
    public AttributeData(class_1320 attribute, double value) {
        this(attribute, value, Optional.empty());
    }

    public AttributeData(class_1320 attribute, double value, AttributeModifierData.Operation operation, AttributeModifierData.Slot slot, AttributeModifierData.AttributeModifierId id) {
        this(attribute, value, Optional.of(new AttributeModifierData(operation, slot, id)));
    }

    public static AttributeData fromComponentEntry(class_9285.class_9287 entry) {
        return new AttributeData((class_1320)entry.comp_2395().comp_349(), entry.comp_2396().comp_2449(), Optional.of(AttributeModifierData.fromMinecraft(entry.comp_2396(), entry.comp_2397())));
    }

    public class_9285.class_9287 toComponentEntry() {
        return new class_9285.class_9287(class_7923.field_41190.method_47983((Object)this.attribute), this.modifierData.get().toMinecraft(class_7923.field_41190.method_10221((Object)this.attribute).toString(), this.value), (class_9274)this.modifierData.get().slot().toMinecraft());
    }

    public record AttributeModifierData(Operation operation, Slot slot, AttributeModifierId id) {
        public static AttributeModifierData fromMinecraft(class_1322 modifier, class_9274 slot) {
            return new AttributeModifierData(Operation.fromMinecraft(modifier.comp_2450()), Slot.fromMinecraft(slot), AttributeModifierId.fromMinecraft(modifier));
        }

        public class_1322 toMinecraft(String name, double value) {
            return this.id.toMinecraft(name, value, this.operation.toMinecraft());
        }

        public static enum Operation {
            ADD("nbteditor.attributes.operation.add"),
            ADD_MULTIPLIED_BASE("nbteditor.attributes.operation.add_multiplied_base"),
            ADD_MULTIPLIED_TOTAL("nbteditor.attributes.operation.add_multiplied_total");

            private final class_2561 name;

            public static Operation fromMinecraft(class_1322.class_1323 operation) {
                return switch (operation) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_1322.class_1323.field_6328 -> ADD;
                    case class_1322.class_1323.field_6330 -> ADD_MULTIPLIED_BASE;
                    case class_1322.class_1323.field_6331 -> ADD_MULTIPLIED_TOTAL;
                };
            }

            private Operation(String key) {
                this.name = TextInst.translatable(key, new Object[0]);
            }

            public class_1322.class_1323 toMinecraft() {
                return switch (this.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> class_1322.class_1323.field_6328;
                    case 1 -> class_1322.class_1323.field_6330;
                    case 2 -> class_1322.class_1323.field_6331;
                };
            }

            public String toString() {
                return this.name.getString();
            }
        }

        public static enum Slot {
            ANY("nbteditor.attributes.slot.any", false),
            HAND("nbteditor.attributes.slot.hand", true),
            MAINHAND("nbteditor.attributes.slot.mainhand", false),
            OFFHAND("nbteditor.attributes.slot.offhand", false),
            ARMOR("nbteditor.attributes.slot.armor", true),
            HEAD("nbteditor.attributes.slot.head", false),
            CHEST("nbteditor.attributes.slot.chest", false),
            LEGS("nbteditor.attributes.slot.legs", false),
            FEET("nbteditor.attributes.slot.feet", false),
            BODY("nbteditor.attributes.slot.body", true);

            private final class_2561 name;
            private final boolean onlyForComponents;

            public static Slot fromMinecraft(Object slot) {
                return switch ((class_9274)slot) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_9274.field_49216 -> ANY;
                    case class_9274.field_49219 -> HAND;
                    case class_9274.field_49217 -> MAINHAND;
                    case class_9274.field_49218 -> OFFHAND;
                    case class_9274.field_49224 -> ARMOR;
                    case class_9274.field_49223 -> HEAD;
                    case class_9274.field_49222 -> CHEST;
                    case class_9274.field_49221 -> LEGS;
                    case class_9274.field_49220 -> FEET;
                    case class_9274.field_50127 -> BODY;
                };
            }

            public static List<Slot> getNotOnlyForComponents() {
                return Arrays.stream(Slot.values()).filter(slot -> !slot.isOnlyForComponents()).toList();
            }

            private Slot(String key, boolean onlyForComponents) {
                this.name = TextInst.translatable(key, new Object[0]);
                this.onlyForComponents = onlyForComponents;
            }

            public Object toMinecraft() {
                return switch (this.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> class_9274.field_49216;
                    case 1 -> class_9274.field_49219;
                    case 2 -> class_9274.field_49217;
                    case 3 -> class_9274.field_49218;
                    case 4 -> class_9274.field_49224;
                    case 5 -> class_9274.field_49223;
                    case 6 -> class_9274.field_49222;
                    case 7 -> class_9274.field_49221;
                    case 8 -> class_9274.field_49220;
                    case 9 -> class_9274.field_50127;
                };
            }

            public boolean isOnlyForComponents() {
                return this.onlyForComponents;
            }

            public boolean isInThisVersion() {
                return !this.onlyForComponents || NBTManagers.COMPONENTS_EXIST;
            }

            public String toString() {
                return this.name.getString();
            }
        }

        public static class AttributeModifierId {
            public static final boolean ID_IS_IDENTIFIER = Version.newSwitch().range("1.21.0", null, true).range(null, "1.20.6", false).get();
            private static final Supplier<Reflection.MethodInvoker> EntityAttributeModifier_uuid = Reflection.getOptionalMethod(class_1322.class, "comp_2447", MethodType.methodType(UUID.class));
            private final Object id;

            public static AttributeModifierId randomUUID() {
                return new AttributeModifierId(UUID.randomUUID());
            }

            public static AttributeModifierId fromMinecraft(class_1322 modifier) {
                if (ID_IS_IDENTIFIER) {
                    return new AttributeModifierId(modifier.comp_2447());
                }
                return new AttributeModifierId((UUID)EntityAttributeModifier_uuid.get().invoke(modifier, new Object[0]));
            }

            public AttributeModifierId(UUID id) {
                this.id = id;
            }

            public AttributeModifierId(class_2960 id) {
                if (!ID_IS_IDENTIFIER) {
                    throw new IllegalArgumentException("Attribute IDs are UUIDs in this version!");
                }
                this.id = id;
            }

            public UUID getUUID() {
                return (UUID)this.id;
            }

            public class_2960 getIdentifier() {
                Object object = this.id;
                if (object instanceof UUID) {
                    UUID uuid = (UUID)object;
                    return IdentifierInst.of("minecraft", uuid.toString());
                }
                return (class_2960)this.id;
            }

            public class_1322 toMinecraft(String name, double value, class_1322.class_1323 operation) {
                if (ID_IS_IDENTIFIER) {
                    return new class_1322(this.getIdentifier(), value, operation);
                }
                return Reflection.newInstance(class_1322.class, new Class[]{UUID.class, String.class, Double.TYPE, class_1322.class_1323.class}, this.getUUID(), name, value, operation);
            }
        }
    }
}

