/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general.TagReference;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific.data.AttributeData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AttributesNBTTagReference
implements TagReference<List<AttributeData>, class_2487> {
    private final NBTLayout layout;

    public AttributesNBTTagReference(NBTLayout layout) {
        this.layout = layout;
    }

    @Override
    public List<AttributeData> get(class_2487 object) {
        class_2499 attributesNbt = object.method_10554(this.layout.getAttributeListTag(), 10);
        ArrayList<AttributeData> output = new ArrayList<AttributeData>();
        for (class_2520 attributeNbtElement : attributesNbt) {
            class_2487 attributeNbt = (class_2487)attributeNbtElement;
            class_1320 attribute = MVRegistry.ATTRIBUTE.get(IdentifierInst.of(attributeNbt.method_10558(this.layout.getAttributeNameTag())));
            if (attribute == null || !attributeNbt.method_10573(this.layout.getAmountTag(), 99)) continue;
            double value = attributeNbt.method_10574(this.layout.getAmountTag());
            if (this.layout.isModifiers()) {
                int operation;
                if (!attributeNbt.method_10573("Operation", 99) || (operation = attributeNbt.method_10550("Operation")) < 0 || operation >= AttributeData.AttributeModifierData.Operation.values().length) continue;
                AttributeData.AttributeModifierData.Slot slot = AttributeData.AttributeModifierData.Slot.ANY;
                if (attributeNbt.method_10573("Slot", 8)) {
                    try {
                        slot = AttributeData.AttributeModifierData.Slot.valueOf(attributeNbt.method_10558("Slot").toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    if (slot.isOnlyForComponents()) continue;
                }
                if (!attributeNbt.method_25928("UUID")) continue;
                UUID uuid = attributeNbt.method_25926("UUID");
                output.add(new AttributeData(attribute, value, AttributeData.AttributeModifierData.Operation.values()[operation], slot, new AttributeData.AttributeModifierData.AttributeModifierId(uuid)));
                continue;
            }
            output.add(new AttributeData(attribute, value));
        }
        return output;
    }

    @Override
    public void set(class_2487 object, List<AttributeData> value) {
        if (value.isEmpty()) {
            object.method_10551(this.layout.getAttributeListTag());
            return;
        }
        class_2499 output = new class_2499();
        for (AttributeData attribute : value) {
            class_2487 attributeNbt = new class_2487();
            attributeNbt.method_10582(this.layout.getAttributeNameTag(), MVRegistry.ATTRIBUTE.getId(attribute.attribute()).toString());
            attributeNbt.method_10549(this.layout.getAmountTag(), attribute.value());
            if (this.layout.isModifiers()) {
                attributeNbt.method_10582("Name", attributeNbt.method_10558("AttributeName"));
                attributeNbt.method_10569("Operation", attribute.modifierData().get().operation().ordinal());
                if (attribute.modifierData().get().slot() != AttributeData.AttributeModifierData.Slot.ANY) {
                    if (attribute.modifierData().get().slot().isOnlyForComponents()) {
                        throw new IllegalArgumentException("The slot " + String.valueOf((Object)attribute.modifierData().get().slot()) + " isn't available in this version of Minecraft!");
                    }
                    attributeNbt.method_10582("Slot", attribute.modifierData().get().slot().name().toLowerCase());
                }
                attributeNbt.method_25927("UUID", attribute.modifierData().get().id().getUUID());
            }
            output.add((Object)attributeNbt);
        }
        object.method_10566(this.layout.getAttributeListTag(), (class_2520)output);
    }

    public static enum NBTLayout {
        ITEM_OLD(true, "AttributeModifiers", "AttributeName", "Amount"),
        ENTITY_OLD(false, "Attributes", "Name", "Base"),
        ENTITY_NEW(false, "attributes", "id", "base");

        private final boolean modifiers;
        private final String attributeListTag;
        private final String attributeNameTag;
        private final String amountTag;

        private NBTLayout(boolean modifiers, String attributeListTag, String attributeNameTag, String amountTag) {
            this.modifiers = modifiers;
            this.attributeListTag = attributeListTag;
            this.attributeNameTag = attributeNameTag;
            this.amountTag = amountTag;
        }

        public boolean isModifiers() {
            return this.modifiers;
        }

        public String getAttributeListTag() {
            return this.attributeListTag;
        }

        public String getAttributeNameTag() {
            return this.attributeNameTag;
        }

        public String getAmountTag() {
            return this.amountTag;
        }
    }
}

