/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public interface TagReference<T, O> {
    public static <T1, T2, O> TagReference<T2, O> mapValue(final Function<T1, T2> getter, final Function<T2, T1> setter, final TagReference<T1, O> tagRef) {
        return new TagReference<T2, O>(){

            @Override
            public T2 get(O object) {
                return getter.apply(tagRef.get(object));
            }

            @Override
            public void set(O object, T2 value) {
                tagRef.set(object, setter.apply(value));
            }
        };
    }

    public static <T, O1, O2> TagReference<T, O2> mapObject(final Function<O2, O1> getter, final BiConsumer<O2, O1> setter, final TagReference<T, O1> tagRef) {
        return new TagReference<T, O2>(){

            @Override
            public T get(O2 object) {
                return tagRef.get(getter.apply(object));
            }

            @Override
            public void set(O2 object, T value) {
                Object internalObject = getter.apply(object);
                tagRef.set(internalObject, value);
                setter.accept(object, internalObject);
            }
        };
    }

    public static <T> TagReference<T, class_1799> forItems(final Supplier<T> defaultValue, final TagReference<T, class_2487> tagRef) {
        return new TagReference<T, class_1799>(){

            @Override
            public T get(class_1799 object) {
                if (!object.manager$hasNbt()) {
                    return defaultValue.get();
                }
                return tagRef.get(object.manager$getNbt());
            }

            @Override
            public void set(class_1799 object, T value) {
                object.manager$modifyNbt(nbt -> tagRef.set(nbt, value));
            }
        };
    }

    public static <T, O extends LocalNBT> TagReference<T, O> forLocalNBT(final Supplier<T> defaultValue, final TagReference<T, class_2487> tagRef) {
        return new TagReference<T, O>(){

            @Override
            public T get(O object) {
                class_2487 nbt = object.getNBT();
                if (nbt == null) {
                    return defaultValue.get();
                }
                return tagRef.get(nbt);
            }

            @Override
            public void set(O object, T value) {
                object.modifyNBT(nbt -> tagRef.set(nbt, value));
            }
        };
    }

    public static <C, O> TagReference<List<C>, O> forLists(Class<C> clazz, TagReference<C[], O> tagRef) {
        return TagReference.mapValue(array -> new ArrayList<Object>(Arrays.asList(array)), list -> list == null ? null : list.toArray(len -> (Object[])Array.newInstance(clazz, len)), tagRef);
    }

    public static <C, O> TagReference<List<C>, O> forLists(Function<class_2520, C> getter, Function<C, class_2520> setter, TagReference<class_2499, O> tagRef) {
        return TagReference.mapValue(nbtList -> {
            ArrayList list = new ArrayList();
            for (class_2520 elementNbt : nbtList) {
                Object elementValue = getter.apply(elementNbt);
                if (elementValue == null) continue;
                list.add(elementValue);
            }
            return list;
        }, list -> {
            if (list == null) {
                return null;
            }
            class_2499 nbtList = new class_2499();
            for (Object elementValue : list) {
                class_2520 elementNbt = (class_2520)setter.apply(elementValue);
                if (elementNbt == null) continue;
                nbtList.add((Object)elementNbt);
            }
            return nbtList;
        }, tagRef);
    }

    public static <V, O> TagReference<Map<String, V>, O> forMaps(Function<class_2520, V> getter, Function<V, class_2520> setter, TagReference<class_2487, O> tagRef) {
        return TagReference.mapValue(compound -> {
            HashMap output = new HashMap();
            for (String key : compound.method_10541()) {
                Object entryValue = getter.apply(compound.method_10580(key));
                if (entryValue == null) continue;
                output.put(key, entryValue);
            }
            return output;
        }, map -> {
            if (map == null) {
                return null;
            }
            class_2487 compound = new class_2487();
            map.forEach((key, entryValue) -> {
                class_2520 entryValueNbt = (class_2520)setter.apply(entryValue);
                if (entryValueNbt != null) {
                    compound.method_10566(key, entryValueNbt);
                }
            });
            return compound;
        }, tagRef);
    }

    public static <T> TagReference<T, class_2487> alsoRemove(final String path, final TagReference<T, class_2487> tagRef) {
        return new TagReference<T, class_2487>(){

            @Override
            public T get(class_2487 object) {
                return tagRef.get(object);
            }

            @Override
            public void set(class_2487 object, T value) {
                tagRef.set(object, value);
                String[] pathParts = path.split("/");
                class_2487 nbt = object;
                for (int i = 0; i < pathParts.length - 1; ++i) {
                    nbt = nbt.method_10562(pathParts[i]);
                }
                nbt.method_10551(pathParts[pathParts.length - 1]);
            }
        };
    }

    public T get(O var1);

    public void set(O var1, T var2);

    default public void modify(O object, UnaryOperator<T> modifier) {
        this.set(object, modifier.apply(this.get(object)));
    }

    default public void modify(O object, Consumer<T> modifier) {
        this.modify(object, value -> {
            modifier.accept(value);
            return value;
        });
    }
}

