/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general;

import com.google.gson.JsonParseException;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general.TagReference;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class NBTTagReference<T>
implements TagReference<T, class_2487> {
    private final Class<T> clazz;
    private final String[] path;

    private static Object deserialize(class_2520 element, Class<?> target) {
        Class<class_2520> primitiveTarget;
        if (target.isArray()) {
            if (!(element instanceof class_2483)) {
                return Array.newInstance(target.componentType(), 0);
            }
            class_2483 list = (class_2483)element;
            Object output = Array.newInstance(target.componentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(output, i, NBTTagReference.deserialize((class_2520)list.get(i), target.componentType()));
            }
            return output;
        }
        if (target.isAssignableFrom(class_2520.class)) {
            return element.method_10707();
        }
        if (target.isAssignableFrom(class_2487.class)) {
            class_2487 class_24872;
            if (element instanceof class_2487) {
                class_2487 compound = (class_2487)element;
                class_24872 = compound.method_10553();
            } else {
                class_24872 = new class_2487();
            }
            return class_24872;
        }
        if (target.isAssignableFrom(class_2499.class)) {
            class_2499 class_24992;
            if (element instanceof class_2499) {
                class_2499 list = (class_2499)element;
                class_24992 = list.method_10612();
            } else {
                class_24992 = new class_2499();
            }
            return class_24992;
        }
        TypeDescriptor.OfField<Class<?>> ofField = primitiveTarget = target.isPrimitive() ? target : MethodType.methodType(target).unwrap().returnType();
        if (primitiveTarget.isPrimitive()) {
            if (primitiveTarget == Boolean.TYPE) {
                class_2514 num;
                return element instanceof class_2514 ? Boolean.valueOf((num = (class_2514)element).method_10698() != 0) : Boolean.valueOf(false);
            }
            if (primitiveTarget == Byte.TYPE) {
                Byte by;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    by = num.method_10698();
                } else {
                    by = 0;
                }
                return by;
            }
            if (primitiveTarget == Short.TYPE) {
                Short s;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    s = num.method_10696();
                } else {
                    s = 0;
                }
                return s;
            }
            if (primitiveTarget == Character.TYPE) {
                char c;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    c = (char)num.method_10696();
                } else {
                    c = '\u0000';
                }
                return Character.valueOf(c);
            }
            if (primitiveTarget == Integer.TYPE) {
                Integer n;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    n = num.method_10701();
                } else {
                    n = 0;
                }
                return n;
            }
            if (primitiveTarget == Long.TYPE) {
                Long l;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    l = num.method_10699();
                } else {
                    l = 0L;
                }
                return l;
            }
            if (primitiveTarget == Float.TYPE) {
                Float f;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    f = Float.valueOf(num.method_10700());
                } else {
                    f = Float.valueOf(0.0f);
                }
                return f;
            }
            if (primitiveTarget == Double.TYPE) {
                Double d;
                if (element instanceof class_2514) {
                    class_2514 num = (class_2514)element;
                    d = num.method_10697();
                } else {
                    d = 0.0;
                }
                return d;
            }
            throw new IllegalArgumentException("Unknown primitive type " + primitiveTarget.getName());
        }
        if (target.isAssignableFrom(String.class)) {
            String string;
            if (element instanceof class_2519) {
                class_2519 str = (class_2519)element;
                string = str.method_10714();
            } else {
                string = "";
            }
            return string;
        }
        if (target.isAssignableFrom(class_2561.class)) {
            try {
                class_2561 class_25612;
                if (element instanceof class_2519) {
                    class_2519 str = (class_2519)element;
                    class_25612 = TextUtil.fromJsonSafely(str.method_10714());
                } else {
                    class_25612 = TextInst.of("");
                }
                return class_25612;
            }
            catch (JsonParseException e) {
                return TextInst.of("");
            }
        }
        throw new IllegalArgumentException("Cannot get " + target.getName() + " from nbt!");
    }

    private static class_2520 serialize(Object value) {
        Class<?> primitiveValueType;
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert null to nbt!");
        }
        Class<?> valueType = value.getClass();
        if (valueType.isArray()) {
            TypeDescriptor.OfField compType = valueType.componentType();
            if (((Class)compType).isPrimitive()) {
                if (compType == Byte.TYPE) {
                    return new class_2479((byte[])value);
                }
                if (compType == Integer.TYPE) {
                    return new class_2495((int[])value);
                }
                if (compType == Long.TYPE) {
                    return new class_2501((long[])value);
                }
            }
            class_2499 output = new class_2499();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                output.add((Object)NBTTagReference.serialize(Array.get(value, i)));
            }
            return output;
        }
        if (class_2520.class.isAssignableFrom(valueType)) {
            return ((class_2520)value).method_10707();
        }
        TypeDescriptor.OfField<Class<?>> ofField = primitiveValueType = valueType.isPrimitive() ? valueType : MethodType.methodType(valueType).unwrap().returnType();
        if (primitiveValueType.isPrimitive()) {
            if (primitiveValueType == Boolean.TYPE) {
                return class_2481.method_23234((boolean)((Boolean)value));
            }
            if (primitiveValueType == Byte.TYPE) {
                return class_2481.method_23233((byte)((Byte)value));
            }
            if (primitiveValueType == Short.TYPE) {
                return class_2516.method_23254((short)((Short)value));
            }
            if (primitiveValueType == Character.TYPE) {
                return class_2516.method_23254((short)((short)((Character)value).charValue()));
            }
            if (primitiveValueType == Integer.TYPE) {
                return class_2497.method_23247((int)((Integer)value));
            }
            if (primitiveValueType == Long.TYPE) {
                return class_2503.method_23251((long)((Long)value));
            }
            if (primitiveValueType == Float.TYPE) {
                return class_2494.method_23244((float)((Float)value).floatValue());
            }
            if (primitiveValueType == Double.TYPE) {
                return class_2489.method_23241((double)((Double)value));
            }
            throw new IllegalArgumentException("Unknown primitive type " + primitiveValueType.getName());
        }
        if (CharSequence.class.isAssignableFrom(valueType)) {
            return class_2519.method_23256((String)((CharSequence)value).toString());
        }
        if (class_2561.class.isAssignableFrom(valueType)) {
            return class_2519.method_23256((String)TextInst.toJsonString((class_2561)value));
        }
        throw new IllegalArgumentException("Cannot convert " + valueType.getName() + " to nbt!");
    }

    private static class_2520 manageNbt(class_2487 nbt, String[] path, boolean write, class_2520 toWrite) {
        for (int i = 0; i < path.length - 1; ++i) {
            class_2520 element = nbt.method_10580(path[i]);
            if (element instanceof class_2487) {
                class_2487 compound;
                nbt = compound = (class_2487)element;
                continue;
            }
            if (write) {
                class_2487 compound = new class_2487();
                nbt.method_10566(path[i], (class_2520)compound);
                nbt = compound;
                continue;
            }
            return null;
        }
        String finalKey = path[path.length - 1];
        if (write) {
            if (toWrite == null) {
                nbt.method_10551(finalKey);
            } else {
                nbt.method_10566(finalKey, toWrite);
            }
            return null;
        }
        return nbt.method_10580(finalKey);
    }

    private static class_2520 getFromNbt(class_2487 nbt, String[] path) {
        return NBTTagReference.manageNbt(nbt, path, false, null);
    }

    private static void setToNbt(class_2487 nbt, String[] path, class_2520 value) {
        NBTTagReference.manageNbt(nbt, path, true, value);
    }

    private static void removeFromNbt(class_2487 nbt, String[] path) {
        NBTTagReference.manageNbt(nbt, path, true, null);
    }

    public NBTTagReference(Class<T> clazz, String path) {
        this.clazz = clazz;
        this.path = path.split("/");
    }

    @Override
    public T get(class_2487 object) {
        return (T)NBTTagReference.deserialize(object == null ? null : NBTTagReference.getFromNbt(object, this.path), this.clazz);
    }

    @Override
    public void set(class_2487 object, T value) {
        if (value == null) {
            NBTTagReference.removeFromNbt(object, this.path);
            return;
        }
        NBTTagReference.setToNbt(object, this.path, NBTTagReference.serialize(value));
    }
}

