/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVComponentType;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general.TagReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_3902;

public class ComponentTagReference<T, C>
implements TagReference<T, class_1799> {
    private final MVComponentType<C> component;
    private final Supplier<C> defaultComponent;
    private final Function<C, T> getter;
    private final BiFunction<C, T, C> setter;
    private boolean passNullValue;

    public static <C> ComponentTagReference<Boolean, C> forExistance(MVComponentType<C> component, Supplier<C> supplier) {
        return new ComponentTagReference<Boolean, Object>(component, null, componentValue -> componentValue != null, (componentValue, value) -> {
            if (value == null) {
                value = false;
            }
            if (componentValue != null == value) {
                return componentValue;
            }
            return value != false ? supplier.get() : null;
        });
    }

    public static ComponentTagReference<Boolean, class_3902> forExistance(MVComponentType<class_3902> component) {
        return ComponentTagReference.forExistance(component, () -> class_3902.field_17274);
    }

    public ComponentTagReference(MVComponentType<C> component, Supplier<C> defaultComponent, Function<C, T> getter, BiFunction<C, T, C> setter) {
        this.component = component;
        this.defaultComponent = defaultComponent;
        this.getter = getter;
        this.setter = setter;
        this.passNullValue = false;
    }

    public ComponentTagReference(MVComponentType<C> component, Supplier<C> defaultComponent, Function<C, T> getter, Function<T, C> setter) {
        this(component, defaultComponent, getter, (C componentValue, T value) -> setter.apply(value));
    }

    public ComponentTagReference<T, C> passNullValue() {
        this.passNullValue = true;
        return this;
    }

    @Override
    public T get(class_1799 object) {
        Object componentValue = object.get(this.component);
        if (componentValue == null && this.defaultComponent != null) {
            componentValue = this.defaultComponent.get();
        }
        return this.getter.apply(componentValue);
    }

    @Override
    public void set(class_1799 object, T value) {
        if (value == null && !this.passNullValue) {
            object.set(this.component, null);
            return;
        }
        Object componentValue = object.get(this.component);
        if (componentValue == null && this.defaultComponent != null) {
            componentValue = this.defaultComponent.get();
        }
        object.set(this.component, this.setter.apply(componentValue, value));
    }
}

