/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general;

import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general.NBTTagReference;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.general.TagReference;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2487;

public class ArraySplitTagReference<C, O>
implements TagReference<List<C>, O> {
    private final Supplier<C> entryPadder;
    private final TagReference<C, O>[] entryTagRefs;

    public static <C> TagReference<List<C>, class_2487> forNBT(Supplier<C> entryPadder, Class<C> clazz, String ... paths) {
        return new ArraySplitTagReference(entryPadder, (TagReference[])Arrays.stream(paths).map(path -> new NBTTagReference(clazz, (String)path)).toArray(TagReference[]::new));
    }

    @SafeVarargs
    public ArraySplitTagReference(Supplier<C> entryPadder, TagReference<C, O> ... entryTagRefs) {
        this.entryPadder = entryPadder;
        this.entryTagRefs = entryTagRefs;
    }

    @Override
    public List<C> get(O object) {
        return Arrays.stream(this.entryTagRefs).map(tagRef -> tagRef.get(object)).collect(Collectors.toList());
    }

    @Override
    public void set(O object, List<C> value) {
        if (value == null) {
            for (TagReference<C, O> entryTagRef : this.entryTagRefs) {
                entryTagRef.set(object, null);
            }
            return;
        }
        for (int i = 0; i < this.entryTagRefs.length; ++i) {
            this.entryTagRefs[i].set(object, i < value.size() ? value.get(i) : this.entryPadder.get());
        }
    }
}

