/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.server;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Reflection;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVServerNetworking;
import com.luneruniverse.minecraft.mod.nbteditor.packets.GetBlockC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.GetEntityC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.GetLecternBlockC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.OpenEnderChestC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ProtocolVersionS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SetBlockC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SetCursorC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SetEntityC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SetSlotC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SummonEntityC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewBlockS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewEntityS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.server.ServerMVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.util.BlockStateProperties;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3722;
import net.minecraft.class_3908;
import net.minecraft.class_3916;
import net.minecraft.class_5321;
import net.minecraft.class_747;

public class NBTEditorServer
implements MVServerNetworking.PlayNetworkStateEvents.Start {
    public static final int PROTOCOL_VERSION = 1;
    public static boolean IS_DEDICATED = true;
    private static final WeakHashMap<Thread, Boolean> serverThreads = new WeakHashMap();

    public static void registerServerThread(Thread thread) {
        serverThreads.put(thread, true);
    }

    public static void unregisterServerThread(Thread thread) {
        serverThreads.remove(thread);
    }

    public static boolean isOnServerThread() {
        if (IS_DEDICATED) {
            return true;
        }
        if (MainUtil.client.method_1576() == null) {
            return false;
        }
        if (MainUtil.client.method_1576().method_18854()) {
            return true;
        }
        return serverThreads.containsKey(Thread.currentThread());
    }

    public NBTEditorServer() {
        MVServerNetworking.registerListener(SetCursorC2SPacket.ID, this::onSetCursorPacket);
        MVServerNetworking.registerListener(SetSlotC2SPacket.ID, this::onSetSlotPacket);
        MVServerNetworking.registerListener(OpenEnderChestC2SPacket.ID, this::onOpenEnderChestPacket);
        MVServerNetworking.registerListener(GetBlockC2SPacket.ID, this::onGetBlockPacket);
        MVServerNetworking.registerListener(GetLecternBlockC2SPacket.ID, this::onGetLecternBlockPacket);
        MVServerNetworking.registerListener(GetEntityC2SPacket.ID, this::onGetEntityPacket);
        MVServerNetworking.registerListener(SetBlockC2SPacket.ID, this::onSetBlockPacket);
        MVServerNetworking.registerListener(SetEntityC2SPacket.ID, this::onSetEntityPacket);
        MVServerNetworking.registerListener(SummonEntityC2SPacket.ID, this::onSummonEntityPacket);
        MVServerNetworking.PlayNetworkStateEvents.Start.EVENT.register((Object)this);
    }

    @Override
    public void onPlayStart(class_3222 player) {
        MVServerNetworking.send(player, new ProtocolVersionS2CPacket(1));
    }

    private void onSetCursorPacket(SetCursorC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        player.field_7512.method_34254(packet.getItem());
        player.field_7512.method_34250(packet.getItem());
    }

    private void onSetSlotPacket(SetSlotC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        if (player.field_7512 == player.field_7498) {
            return;
        }
        class_1735 slot = player.field_7512.method_7611(packet.getSlot());
        if (slot.field_7871 == player.method_31548()) {
            return;
        }
        slot.method_7673(packet.getItem());
    }

    private void onOpenEnderChestPacket(OpenEnderChestC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        player.method_17355((class_3908)new class_747((syncId, inventory, player2) -> class_1707.method_19245((int)syncId, (class_1661)inventory, (class_1263)player.method_7274()), (class_2561)TextInst.translatable("container.enderchest", new Object[0])));
    }

    private void onGetBlockPacket(GetBlockC2SPacket packet, class_3222 player) {
        class_2586 blockEntity;
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        class_3218 world = player.method_5682().method_3847(packet.getWorld());
        if (world != null && (blockEntity = world.method_8321(packet.getPos())) != null) {
            this.sendViewBlockPacket(packet.getRequestId(), blockEntity, player);
            return;
        }
        MVServerNetworking.send(player, new ViewBlockS2CPacket(packet.getRequestId(), packet.getWorld(), packet.getPos(), null, null, null));
    }

    private void onGetLecternBlockPacket(GetLecternBlockC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof class_3916) {
            class_3916 handler = (class_3916)class_17032;
            class_1263 inv = handler.field_17313;
            class_3722 lectern = (class_3722)Reflection.getField(inv.getClass(), "field_17391", "Lnet/minecraft/class_3722;").get(inv);
            if (lectern != null) {
                this.sendViewBlockPacket(packet.getRequestId(), (class_2586)lectern, player);
                return;
            }
        }
        MVServerNetworking.send(player, new ViewBlockS2CPacket(packet.getRequestId(), null, null, null, null, null));
    }

    private void sendViewBlockPacket(int requestId, class_2586 blockEntity, class_3222 player) {
        MVServerNetworking.send(player, new ViewBlockS2CPacket(requestId, (class_5321<class_1937>)blockEntity.method_10997().method_27983(), blockEntity.method_11016(), MVRegistry.BLOCK.getId(blockEntity.method_11010().method_26204()), new BlockStateProperties(blockEntity.method_11010()), NBTManagers.BLOCK_ENTITY.getNbt(blockEntity)));
    }

    private void onGetEntityPacket(GetEntityC2SPacket packet, class_3222 player) {
        class_1297 entity;
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        class_3218 world = player.method_5682().method_3847(packet.getWorld());
        if (world != null && (entity = world.method_14190(packet.getUUID())) != null && !(entity instanceof class_1657)) {
            MVServerNetworking.send(player, new ViewEntityS2CPacket(packet.getRequestId(), (class_5321<class_1937>)entity.method_5770().method_27983(), entity.method_5667(), class_1299.method_5890((class_1299)entity.method_5864()), NBTManagers.ENTITY.getNbt(entity)));
            return;
        }
        MVServerNetworking.send(player, new ViewEntityS2CPacket(packet.getRequestId(), packet.getWorld(), packet.getUUID(), null, null));
    }

    private void onSetBlockPacket(SetBlockC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        class_3218 world = player.method_5682().method_3847(packet.getWorld());
        if (world == null) {
            return;
        }
        class_2248 block = MVRegistry.BLOCK.get(packet.getId());
        class_2680 state = world.method_8320(packet.getPos());
        if (state.method_26204() != block) {
            world.method_8544(packet.getPos());
            world.method_8501(packet.getPos(), packet.getState().applyToSafely(block.method_9564()));
        } else {
            if (!new BlockStateProperties(state).equals(packet.getState())) {
                world.method_8501(packet.getPos(), packet.getState().applyTo(state));
            }
            if (packet.isRecreate()) {
                world.method_8544(packet.getPos());
            }
        }
        class_2586 blockEntity = world.method_8321(packet.getPos());
        if (blockEntity == null) {
            return;
        }
        NBTManagers.BLOCK_ENTITY.setNbt(blockEntity, packet.getNbt());
        if (packet.isTriggerUpdate()) {
            blockEntity.method_5431();
            world.method_8413(packet.getPos(), blockEntity.method_11010(), blockEntity.method_11010(), 0);
        }
    }

    private void onSetEntityPacket(SetEntityC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        class_3218 world = player.method_5682().method_3847(packet.getWorld());
        if (world == null) {
            return;
        }
        class_1297 entity = world.method_14190(packet.getUUID());
        if (entity == null) {
            return;
        }
        UUID newUUID = packet.getUUID();
        if (packet.getNbt().method_25928("UUID")) {
            newUUID = packet.getNbt().method_25926("UUID");
            if (!packet.getUUID().equals(newUUID) && world.method_14190(newUUID) != null) {
                newUUID = packet.getUUID();
                packet.getNbt().method_25927("UUID", newUUID);
            }
        } else {
            packet.getNbt().method_25927("UUID", packet.getUUID());
        }
        class_1299<?> entityType = MVRegistry.ENTITY_TYPE.get(packet.getId());
        if (packet.isRecreate() || !entity.method_5667().equals(newUUID) || entity.method_5864() != entityType) {
            float f;
            class_1297 vehicle = entity.method_5854();
            class_243 pos = entity.method_19538();
            float yaw = entity.method_36454();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                f = livingEntity.field_6283;
            } else {
                f = 0.0f;
            }
            float bodyYaw = f;
            float headYaw = entity.method_5791();
            float pitch = entity.method_36455();
            entity.method_31748().forEach(passengerOrSelf -> {
                passengerOrSelf.method_5848();
                passengerOrSelf.method_5650(class_1297.class_5529.field_26999);
            });
            entity = ServerMVMisc.createEntity(entityType, (class_1937)world);
            entity.method_5826(newUUID);
            entity.method_33574(pos);
            entity.method_36456(yaw);
            entity.method_5636(bodyYaw);
            entity.method_5847(headYaw);
            entity.method_36457(pitch);
            world.method_8649(entity);
            this.readEntityNbtWithPassengers(world, entity, packet.getNbt());
            if (vehicle != null) {
                entity.method_5873(vehicle, true);
            }
        } else {
            entity.method_5841().reset();
            this.readEntityNbtWithPassengers(world, entity, packet.getNbt());
        }
    }

    private void onSummonEntityPacket(SummonEntityC2SPacket packet, class_3222 player) {
        if (!ServerMVMisc.hasPermissionLevel((class_1657)player, 2)) {
            return;
        }
        class_3218 world = player.method_5682().method_3847(packet.getWorld());
        if (world == null) {
            MVServerNetworking.send(player, new ViewEntityS2CPacket(packet.getRequestId(), null, null, null, null));
            return;
        }
        UUID uuid = UUID.randomUUID();
        if (packet.getNbt().method_25928("UUID")) {
            UUID nbtUUID = packet.getNbt().method_25926("UUID");
            if (world.method_14190(nbtUUID) == null) {
                uuid = nbtUUID;
            } else {
                packet.getNbt().method_25927("UUID", uuid);
            }
        }
        class_1297 entity = ServerMVMisc.createEntity(MVRegistry.ENTITY_TYPE.get(packet.getId()), (class_1937)world);
        entity.method_5826(uuid);
        entity.method_33574(packet.getPos());
        packet.getNbt().method_10566("Pos", (class_2520)Stream.of(packet.getPos().field_1352, packet.getPos().field_1351, packet.getPos().field_1350).map(class_2489::method_23241).collect(class_2499::new, AbstractList::add, AbstractCollection::addAll));
        world.method_8649(entity);
        this.readEntityNbtWithPassengers(world, entity, packet.getNbt());
        MVServerNetworking.send(player, new ViewEntityS2CPacket(packet.getRequestId(), (class_5321<class_1937>)entity.method_5770().method_27983(), entity.method_5667(), class_1299.method_5890((class_1299)entity.method_5864()), NBTManagers.ENTITY.getNbt(entity)));
    }

    private void readEntityNbtWithPassengers(class_3218 world, class_1297 entity, class_2487 nbt) {
        NBTManagers.ENTITY.setNbt(entity, nbt);
        Map passengers = entity.method_5685().stream().collect(Collectors.toMap(class_1297::method_5667, Function.identity()));
        class_2499 passengersNbt = nbt.method_10554("Passengers", 10);
        HashSet<UUID> passengerUUIDs = new HashSet<UUID>();
        for (class_2520 passengerNbtElement : passengersNbt) {
            UUID passengerUUID;
            class_2487 passengerNbt = (class_2487)passengerNbtElement;
            if (!passengerNbt.method_25928("UUID")) {
                passengerNbt.method_25927("UUID", UUID.randomUUID());
            }
            if (!passengerUUIDs.add(passengerUUID = passengerNbt.method_25926("UUID"))) {
                passengerUUID = UUID.randomUUID();
                passengerNbt.method_25927("UUID", passengerUUID);
            }
            class_1297 passenger = (class_1297)passengers.get(passengerUUID);
            class_2960 passengerId = null;
            if (passengerNbt.method_10573("id", 8)) {
                try {
                    passengerId = IdentifierInst.of(passengerNbt.method_10558("id"));
                    if (!MVRegistry.ENTITY_TYPE.containsId(passengerId)) {
                        passengerId = null;
                    }
                }
                catch (class_151 class_1512) {
                    // empty catch block
                }
            }
            if (passengerId != null && passenger != null && !class_1299.method_5890((class_1299)passenger.method_5864()).equals((Object)passengerId)) {
                passenger.method_31748().forEach(passengerOrSelf -> {
                    passengerOrSelf.method_5848();
                    passengerOrSelf.method_5650(class_1297.class_5529.field_26999);
                });
                passenger = null;
            }
            if (passenger == null) {
                if (passengerId == null) continue;
                class_1299<?> passengerType = MVRegistry.ENTITY_TYPE.get(passengerId);
                if (world.method_14190(passengerUUID) != null) {
                    passengerUUID = UUID.randomUUID();
                    passengerNbt.method_25927("UUID", passengerUUID);
                }
                passenger = ServerMVMisc.createEntity(passengerType, (class_1937)world);
                passenger.method_5826(passengerUUID);
                passenger.method_5873(entity, true);
                world.method_8649(passenger);
            }
            this.readEntityNbtWithPassengers(world, passenger, passengerNbt);
        }
        passengers.keySet().removeAll(passengerUUIDs);
        for (class_1297 passenger : passengers.values()) {
            passenger.method_31748().forEach(passengerOrSelf -> {
                passengerOrSelf.method_5848();
                passengerOrSelf.method_5650(class_1297.class_5529.field_26999);
            });
        }
    }
}

