/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_4587;

public class ScrollBarWidget
implements MVDrawable,
MVElement {
    private final int x;
    private final int y;
    private final int height;
    private final Supplier<Integer> getScroll;
    private final Consumer<Integer> setScroll;
    private final Supplier<Integer> getMaxScroll;
    private boolean dragging;
    private double dragStartMouseY;
    private int dragStartScroll;

    public ScrollBarWidget(int x, int y, int height, Supplier<Integer> getScroll, Consumer<Integer> setScroll, Supplier<Integer> getMaxScroll) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.getScroll = getScroll;
        this.setScroll = setScroll;
        this.getMaxScroll = getMaxScroll;
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int scroll = this.getScroll.get();
        double maxScroll = -Math.min(scroll - this.height, this.getMaxScroll.get() - this.height);
        double scrollArea = (double)this.height / maxScroll;
        if (scrollArea < 1.0) {
            double barY = (double)this.y - (double)scroll / (maxScroll + scrollArea) * (double)this.height;
            MVDrawableHelper.fill(matrices, this.x, this.y, this.x + 8, this.y + this.height, -5592406);
            MVDrawableHelper.fill(matrices, this.x, (int)barY, this.x + 8, (int)(barY + scrollArea * (double)this.height + 1.0), -16777216);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + 8)) {
            this.dragging = true;
            this.dragStartMouseY = mouseY;
            this.dragStartScroll = this.getScroll.get();
            return true;
        }
        this.dragging = false;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.dragging) {
            return false;
        }
        int scroll = this.getScroll.get();
        double maxScroll = -Math.min(scroll - this.height, this.getMaxScroll.get() - this.height);
        double scrollArea = (double)this.height / maxScroll;
        double barY = (double)this.y - (double)this.dragStartScroll / (maxScroll + scrollArea) * (double)this.height;
        this.scroll(((double)this.y - barY - (mouseY - this.dragStartMouseY)) * (maxScroll + scrollArea) / (double)this.height - (double)this.dragStartScroll, this.dragStartScroll);
        return true;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double xAmount, double yAmount) {
        return this.scroll(yAmount * 5.0 * ConfigScreen.getScrollSpeed(), this.getScroll.get());
    }

    private boolean scroll(double amount, int scroll) {
        int maxScroll = this.getMaxScroll.get();
        if (amount < 0.0 && scroll > maxScroll) {
            if ((scroll = (int)((double)scroll + amount)) < maxScroll) {
                scroll = maxScroll;
            }
            this.setScroll.accept(scroll);
            return true;
        }
        if (amount > 0.0 && scroll < 0) {
            if ((scroll = (int)((double)scroll + amount)) > 0) {
                scroll = 0;
            }
            this.setScroll.accept(scroll);
            return true;
        }
        this.setScroll.accept(scroll);
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return true;
    }
}

