/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlayScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InitializableOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class InputOverlay<T>
extends GroupWidget
implements InitializableOverlay<class_437> {
    private final class_2561 title;
    private final Input<T> input;
    private final Consumer<T> valueConsumer;
    private final Runnable close;
    private int x;
    private int y;
    private class_4185 ok;

    public static <T> void show(class_2561 title, Input<T> input, Consumer<T> valueConsumer) {
        OverlayScreen.setOverlayOrScreen(new InputOverlay<T>(title, input, valueConsumer, () -> OverlaySupportingScreen.setOverlayStatic(null)), true);
    }

    public InputOverlay(class_2561 title, Input<T> input, Consumer<T> valueConsumer, Runnable close) {
        this.title = title;
        this.input = input;
        this.valueConsumer = valueConsumer;
        this.close = close;
    }

    @Override
    public void init(class_437 parent, int width, int height) {
        this.clearWidgets();
        this.x = (width - this.input.getWidth()) / 2;
        this.y = (height - this.input.getHeight() - 24) / 2;
        this.input.init(this.x, this.y);
        this.addWidget(this.input);
        this.method_25395(this.input);
        this.ok = this.addWidget(MVMisc.newButton(this.x, this.y + this.input.getHeight() + 4, (this.input.getWidth() - 4) / 2, 20, TextInst.translatable("nbteditor.ok", new Object[0]), btn -> {
            this.close.run();
            this.valueConsumer.accept(this.input.getValue());
        }));
        this.addWidget(MVMisc.newButton(width / 2 + 2, this.y + this.input.getHeight() + 4, (this.input.getWidth() - 4) / 2, 20, TextInst.translatable("nbteditor.cancel", new Object[0]), btn -> this.close.run()));
        this.ok.field_22763 = this.input.isValid();
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.ok.field_22763 = this.input.isValid();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 500.0);
        MainUtil.client.field_1755.renderBackground(matrices);
        if (this.title != null) {
            class_327 class_3272 = MainUtil.client.field_1772;
            int n = this.x + this.input.getWidth() / 2;
            Objects.requireNonNull(MainUtil.client.field_1772);
            MVDrawableHelper.drawCenteredTextWithShadow(matrices, class_3272, this.title, n, this.y - 4 - 9, -1);
        }
        super.render(matrices, mouseX, mouseY, delta);
        MainUtil.renderLogo(matrices);
        matrices.method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.close.run();
            return true;
        }
        if (keyCode == 257 && this.ok.field_22763) {
            this.close.run();
            this.valueConsumer.accept(this.input.getValue());
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static interface Input<T>
    extends MVDrawable,
    MVElement {
        public void init(int var1, int var2);

        public int getWidth();

        public int getHeight();

        public T getValue();

        public boolean isValid();
    }
}

