/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlayScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InitializableOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ImageToLoreWidget
extends GroupWidget
implements InitializableOverlay<class_437> {
    private final Consumer<Optional<ImageToLoreOptions>> optionsConsumer;
    private final class_327 textRenderer;
    private int width;
    private int height;
    private NamedTextFieldWidget imgWidth;
    private NamedTextFieldWidget imgHeight;

    public static List<class_2561> imageToLore(BufferedImage img, int width, int height) {
        img = MainUtil.scaleImage(img, width, height);
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        for (int line = 0; line < height; ++line) {
            EditableText lineText = TextInst.literal("").styled(style -> style.method_10978(Boolean.valueOf(false)));
            for (int i = 0; i < width; ++i) {
                int color = img.getRGB(i, line) & 0xFFFFFF;
                lineText.append(TextInst.literal("\u2588").styled(style -> style.method_36139(color)));
            }
            output.add(lineText);
        }
        return output;
    }

    public static boolean openImportFiles(List<Path> paths, BiConsumer<File, List<class_2561>> loreConsumers, Runnable onDone) {
        LinkedHashMap<File, BufferedImage> imgs = new LinkedHashMap<File, BufferedImage>();
        for (Path path : paths) {
            File file = path.toFile();
            try {
                BufferedImage img = ImageIO.read(file);
                if (img == null) continue;
                imgs.put(file, img);
            }
            catch (IOException iOException) {}
        }
        if (imgs.isEmpty()) {
            return false;
        }
        OverlayScreen.setOverlayOrScreen(new ImageToLoreWidget(optional -> {
            OverlaySupportingScreen.setOverlayStatic(null);
            if (optional.isEmpty()) {
                return;
            }
            ImageToLoreOptions options = (ImageToLoreOptions)optional.get();
            imgs.forEach((file, img) -> {
                int width = img.getWidth();
                int height = img.getHeight();
                if (options.width() != null && options.height() != null) {
                    width = options.width();
                    height = options.height();
                } else if (options.width() != null) {
                    height = (int)((double)options.width().intValue() / (double)width * (double)height);
                    width = options.width();
                } else if (options.height() != null) {
                    width = (int)((double)options.height().intValue() / (double)height * (double)width);
                    height = options.height();
                }
                loreConsumers.accept((File)file, ImageToLoreWidget.imageToLore(img, width, height));
            });
            onDone.run();
        }), 500.0, true);
        return true;
    }

    public ImageToLoreWidget(Consumer<Optional<ImageToLoreOptions>> optionsConsumer) {
        this.optionsConsumer = optionsConsumer;
        this.textRenderer = MainUtil.client.field_1772;
    }

    @Override
    public void init(class_437 parent, int width, int height) {
        this.clearWidgets();
        this.width = width;
        this.height = height;
        String prevImgWidth = this.imgWidth == null ? null : this.imgWidth.method_1882();
        String prevImgHeight = this.imgHeight == null ? null : this.imgHeight.method_1882();
        this.imgWidth = this.addWidget(new NamedTextFieldWidget(width / 2 - 102, height / 2 - 18, 100, 16).name(TextInst.translatable("nbteditor.img_to_lore.width", new Object[0])));
        this.imgHeight = this.addWidget(new NamedTextFieldWidget(width / 2 + 2, height / 2 - 18, 100, 16).name(TextInst.translatable("nbteditor.img_to_lore.height", new Object[0])));
        this.imgWidth.method_1890(MainUtil.intPredicate(1, Integer.MAX_VALUE, true));
        this.imgHeight.method_1890(MainUtil.intPredicate(1, Integer.MAX_VALUE, true));
        if (prevImgWidth != null) {
            this.imgWidth.method_1852(prevImgWidth);
        }
        if (prevImgHeight != null) {
            this.imgHeight.method_1852(prevImgHeight);
        }
        this.addWidget(MVMisc.newButton(width / 2 - 102, height / 2 + 2, 100, 20, ScreenTexts.DONE, btn -> this.optionsConsumer.accept(Optional.of(new ImageToLoreOptions(MainUtil.parseOptionalInt(this.imgWidth.method_1882()), MainUtil.parseOptionalInt(this.imgHeight.method_1882()))))));
        this.addWidget(MVMisc.newButton(width / 2 + 2, height / 2 + 2, 100, 20, ScreenTexts.CANCEL, btn -> this.optionsConsumer.accept(Optional.empty())));
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        MainUtil.client.field_1755.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        EditableText editableText = TextInst.translatable("nbteditor.img_to_lore", new Object[0]);
        int n = this.width / 2;
        int n2 = this.height / 2;
        Objects.requireNonNull(this.textRenderer);
        MVDrawableHelper.drawCenteredTextWithShadow(matrices, this.textRenderer, editableText, n, n2 - 9 - 22, -1);
        MainUtil.renderLogo(matrices);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            OverlaySupportingScreen.setOverlayStatic(null);
            return true;
        }
        if (keyCode == 257) {
            this.optionsConsumer.accept(Optional.of(new ImageToLoreOptions(MainUtil.parseOptionalInt(this.imgWidth.method_1882()), MainUtil.parseOptionalInt(this.imgHeight.method_1882()))));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public record ImageToLoreOptions(Integer width, Integer height) {
    }
}

