/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class CreativeTabWidget
implements MVDrawable,
MVElement {
    public static final List<CreativeTabData> TABS = new ArrayList<CreativeTabData>();
    public static final int WIDTH = Version.newSwitch().range("1.19.3", null, 26).range(null, "1.19.2", 28).get();
    public static final int HEIGHT = 32;
    private static final class_2960 TEXTURE_TOP;
    private static final class_2960 TEXTURE_BOTTOM;
    private static final int V_TOP;
    private static final int V_BOTTOM;
    private final boolean bottom;
    private final int x;
    private final int y;
    private final class_1799 item;
    private final Runnable onClick;
    private final MVTooltip tooltip;

    public static void addCreativeTabs(class_437 screen) {
        List<CreativeTabData> tabs = TABS.stream().filter(tab -> tab.whenToShow().test(screen)).toList();
        if (!tabs.isEmpty()) {
            GroupWidget group = new GroupWidget(){

                @Override
                public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
                    MVTooltip.setOneTooltip(true, false);
                    super.render(matrices, mouseX, mouseY, delta);
                    MVTooltip.renderOneTooltip(matrices, mouseX, mouseY);
                }
            };
            for (int i = 0; i < tabs.size(); ++i) {
                CreativeTabData tab2 = tabs.get(i);
                Point pos = ConfigScreen.getCreativeTabsPos().position(i, tabs.size(), screen.field_22789, screen.field_22790);
                group.addWidget(new CreativeTabWidget(ConfigScreen.getCreativeTabsPos().isTop(), pos.x, pos.y, tab2.item(), tab2.onClick()));
            }
            screen.method_37063((class_364)group);
        }
    }

    public CreativeTabWidget(boolean bottom, int x, int y, class_1799 item, Runnable onClick) {
        this.bottom = bottom;
        this.x = x;
        this.y = y;
        this.item = item;
        this.onClick = onClick;
        this.tooltip = new MVTooltip(item.method_7964());
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        MVDrawableHelper.drawTexture(matrices, this.bottom ? TEXTURE_BOTTOM : TEXTURE_TOP, this.x, this.y + (this.bottom ? 0 : 2), 0.0f, this.bottom ? (float)V_BOTTOM : (float)V_TOP, WIDTH, 32);
        int xOffset = Version.newSwitch().range("1.19.3", null, 5).range(null, "1.19.2", 6).get();
        MVDrawableHelper.renderItem(matrices, 100.0f, false, this.item, this.x + xOffset, this.y + (this.bottom ? 5 : 11));
        if (this.method_25405(mouseX, mouseY)) {
            this.tooltip.render(matrices, mouseX, mouseY);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return (double)this.x <= mouseX && mouseX < (double)(this.x + WIDTH) && (double)this.y <= mouseY && mouseY < (double)(this.y + 32);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            this.onClick.run();
            return true;
        }
        return false;
    }

    static {
        if (Version.newSwitch().range("1.20.2", null, true).range(null, "1.20.1", false).get().booleanValue()) {
            TEXTURE_TOP = IdentifierInst.of("nbteditor", "textures/gui/sprites/container/creative_inventory/tab_top_unselected.png");
            TEXTURE_BOTTOM = IdentifierInst.of("nbteditor", "textures/gui/sprites/container/creative_inventory/tab_bottom_unselected.png");
            V_TOP = 0;
            V_BOTTOM = 0;
        } else {
            TEXTURE_TOP = IdentifierInst.of("textures/gui/container/creative_inventory/tabs.png");
            TEXTURE_BOTTOM = IdentifierInst.of("textures/gui/container/creative_inventory/tabs.png");
            V_TOP = 0;
            V_BOTTOM = 64;
        }
    }

    public record CreativeTabData(class_1799 item, Runnable onClick, Predicate<class_437> whenToShow) {
    }
}

