/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.widgets;

import com.luneruniverse.minecraft.mod.nbteditor.misc.Shaders;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVSliderWidget;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InputOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ColorSelectorWidget
extends GroupWidget {
    private static final class_2960 HUES = IdentifierInst.of("nbteditor", "textures/hues.png");
    private final int x;
    private final int y;
    private final int areaSize;
    private final class_342 field;
    private int color;
    private int hueValue;

    public ColorSelectorWidget(int x, int y, int areaSize, int color, Consumer<Integer> onColor) {
        this.x = x;
        this.y = y;
        this.areaSize = areaSize;
        this.color = color;
        this.addWidget(new ColorArea());
        Color colorObj = new Color(color);
        this.hueValue = (int)(Color.RGBtoHSB(colorObj.getRed(), colorObj.getGreen(), colorObj.getBlue(), new float[3])[0] * 360.0f);
        this.addWidget(new MVSliderWidget(x, y + areaSize + 4, areaSize, 20, (double)this.hueValue / 359.0, () -> TextInst.translatable("nbteditor.color_selector.hue", this.hueValue), value -> {
            this.hueValue = (int)(value * 359.0);
        }){

            @Override
            protected boolean renderSlider(class_4587 matrices, int mouseX, int mouseY, float delta) {
                MVDrawableHelper.drawTexture(matrices, HUES, this.field_22760 + 4, this.field_22761, 0.0f, 0.0f, this.field_22758 - 8, 20, this.field_22758 - 8, 20);
                return true;
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 262) {
                    this.setValue(this.getValue() + 0.002785515320334262);
                    return true;
                }
                if (keyCode == 263) {
                    this.setValue(this.getValue() - 0.002785515320334262);
                    return true;
                }
                return false;
            }
        });
        this.field = new class_342(MainUtil.client.field_1772, x + areaSize + 4, y + areaSize + 4, areaSize / 2, 20, TextInst.of(""));
        this.field.method_1880(7);
        this.field.method_1852("#" + String.format("%08X", color).substring(2, 8));
        this.field.method_1863(str -> {
            if (!str.matches("#[0-9a-fA-F]{6}")) {
                return;
            }
            this.color = Integer.parseInt(str.substring(1), 16);
            onColor.accept(this.color);
        });
        this.addWidget(this.field);
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        MVDrawableHelper.fill(matrices, this.x + this.areaSize + 4, this.y, this.x + this.areaSize + 4 + this.areaSize / 2, this.y + this.areaSize, this.color | 0xFF000000);
    }

    private class ColorArea
    implements MVDrawable,
    MVElement {
        private ColorArea() {
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
            MainUtil.fillShader(matrices, Shaders.POSITION_HSV, vertex -> MVMisc.setVertexLight(vertex, ColorSelectorWidget.this.hueValue), ColorSelectorWidget.this.x, ColorSelectorWidget.this.y, ColorSelectorWidget.this.areaSize, ColorSelectorWidget.this.areaSize);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button != 0 || !this.method_25405(mouseX, mouseY)) {
                return false;
            }
            this.method_25403(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (button != 0) {
                return false;
            }
            mouseX = class_3532.method_15350((double)mouseX, (double)ColorSelectorWidget.this.x, (double)(ColorSelectorWidget.this.x + ColorSelectorWidget.this.areaSize));
            mouseY = class_3532.method_15350((double)mouseY, (double)ColorSelectorWidget.this.y, (double)(ColorSelectorWidget.this.y + ColorSelectorWidget.this.areaSize));
            ColorSelectorWidget.this.color = Color.HSBtoRGB((float)ColorSelectorWidget.this.hueValue / 360.0f, (float)(mouseX - (double)ColorSelectorWidget.this.x) / (float)ColorSelectorWidget.this.areaSize, 1.0f - (float)(mouseY - (double)ColorSelectorWidget.this.y) / (float)ColorSelectorWidget.this.areaSize);
            ColorSelectorWidget.this.field.method_1852("#" + String.format("%08X", ColorSelectorWidget.this.color).substring(2, 8));
            return true;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= (double)ColorSelectorWidget.this.x && mouseX <= (double)(ColorSelectorWidget.this.x + ColorSelectorWidget.this.areaSize) && mouseY >= (double)ColorSelectorWidget.this.y && mouseY <= (double)(ColorSelectorWidget.this.y + ColorSelectorWidget.this.areaSize);
        }
    }

    public static class ColorSelectorInput
    extends GroupWidget
    implements InputOverlay.Input<Integer> {
        private int color;

        public ColorSelectorInput(int color) {
            this.color = color;
        }

        @Override
        public void init(int x, int y) {
            this.clearWidgets();
            this.addWidget(new ColorSelectorWidget(x, y, 128, this.color, newColor -> {
                this.color = newColor;
            }));
        }

        @Override
        public Integer getValue() {
            return this.color;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public int getWidth() {
            return 196;
        }

        @Override
        public int getHeight() {
            return 152;
        }
    }
}

