/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder;

import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.NBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.util.StringJsonWriterQuoted;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class StringNBTFolder
implements NBTFolder<class_2519> {
    private final Supplier<class_2519> get;
    private final Consumer<class_2519> set;

    public StringNBTFolder(Supplier<class_2519> get, Consumer<class_2519> set) {
        this.get = get;
        this.set = set;
    }

    @Override
    public class_2519 getNBT() {
        return this.get.get();
    }

    @Override
    public void setNBT(class_2519 value) {
        this.set.accept(value);
    }

    @Override
    public List<NBTValue> getEntries(NBTEditorScreen<?> screen) {
        return this.exec(folder -> folder.getEntries(screen), null, false);
    }

    @Override
    public boolean hasEmptyKey() {
        return this.exec(NBTFolder::hasEmptyKey, false, false);
    }

    @Override
    public class_2520 getValue(String key) {
        return this.exec(folder -> folder.getValue(key), null, false);
    }

    @Override
    public void setValue(String key, class_2520 value) {
        this.execVoid(folder -> folder.setValue(key, value), true);
    }

    @Override
    public void addKey(String key) {
        this.execVoid(folder -> folder.addKey(key), true);
    }

    @Override
    public void removeKey(String key) {
        this.execVoid(folder -> folder.removeKey(key), true);
    }

    @Override
    public Optional<String> getNextKey(Optional<String> pastingKey) {
        return this.exec(folder -> folder.getNextKey(pastingKey), Optional.empty(), false);
    }

    @Override
    public Predicate<String> getKeyValidator(boolean renaming) {
        return this.exec(folder -> folder.getKeyValidator(renaming), key -> false, false);
    }

    @Override
    public boolean handlesDuplicateKeys() {
        return this.exec(NBTFolder::handlesDuplicateKeys, false, false);
    }

    private <R> R exec(Function<NBTFolder<?>, R> executor, R defaultReturnValue, boolean save) {
        class_2520 parsedNbt;
        try {
            parsedNbt = MixinLink.parseSpecialElement(new StringReader(this.getNBT().method_10714()));
        }
        catch (CommandSyntaxException e) {
            return defaultReturnValue;
        }
        if (this.getNBT().equals((Object)parsedNbt)) {
            return defaultReturnValue;
        }
        NBTFolder<class_2520> folder = NBTFolder.get(parsedNbt);
        if (folder == null) {
            return defaultReturnValue;
        }
        R output = executor.apply(folder);
        if (save) {
            this.setNBT(class_2519.method_23256((String)new StringJsonWriterQuoted().method_32288(folder.getNBT())));
        }
        return output;
    }

    private boolean execVoid(Consumer<NBTFolder<?>> executor, boolean save) {
        return this.exec(folder -> {
            executor.accept((NBTFolder<?>)folder);
            return true;
        }, false, save);
    }
}

