/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder;

import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.CompoundNBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.ListNBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.StringNBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.util.ClassMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public interface NBTFolder<T extends class_2520> {
    public static final ClassMap<class_2520, Constructor<?>> TYPES = NBTFolder.getTypesMap();

    private static ClassMap<class_2520, Constructor<?>> getTypesMap() {
        ClassMap output = new ClassMap();
        output.put(class_2483.class, ListNBTFolder::new);
        output.put(class_2487.class, CompoundNBTFolder::new);
        output.put(class_2519.class, StringNBTFolder::new);
        return output;
    }

    public static <T extends class_2520> NBTFolder<T> get(Class<T> nbt, Supplier<T> get, Consumer<T> set) {
        Constructor<?> constructor = TYPES.get(nbt);
        if (constructor == null) {
            return null;
        }
        return constructor.create(get, set);
    }

    public static <T extends class_2520> NBTFolder<? extends T> get(T nbt) {
        AtomicReference<T> ref = new AtomicReference<T>(nbt);
        return NBTFolder.get(nbt.getClass(), ref::getPlain, ref::setPlain);
    }

    public T getNBT();

    public void setNBT(T var1);

    public List<NBTValue> getEntries(NBTEditorScreen<?> var1);

    public boolean hasEmptyKey();

    public class_2520 getValue(String var1);

    public void setValue(String var1, class_2520 var2);

    public void addKey(String var1);

    public void removeKey(String var1);

    public Optional<String> getNextKey(Optional<String> var1);

    public Predicate<String> getKeyValidator(boolean var1);

    public boolean handlesDuplicateKeys();

    default public NBTFolder<?> getSubFolder(String key) {
        class_2520 value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return this.getSubFolder(key, value.getClass());
    }

    private <T2 extends class_2520> NBTFolder<T2> getSubFolder(String key, Class<T2> clazz) {
        return NBTFolder.get(clazz, () -> (class_2520)clazz.cast(this.getValue(key)), newValue -> this.setValue(key, (class_2520)newValue));
    }

    public static interface Constructor<T extends class_2520> {
        public NBTFolder<T> create(Supplier<T> var1, Consumer<T> var2);
    }
}

