/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder;

import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.NBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class ListNBTFolder
implements NBTFolder<class_2483<?>> {
    private final Supplier<class_2483<?>> get;
    private final Consumer<class_2483<?>> set;

    public ListNBTFolder(Supplier<class_2483<?>> get, Consumer<class_2483<?>> set) {
        this.get = get;
        this.set = set;
    }

    @Override
    public class_2483<?> getNBT() {
        return this.get.get();
    }

    @Override
    public void setNBT(class_2483<?> value) {
        this.set.accept(value);
    }

    @Override
    public List<NBTValue> getEntries(NBTEditorScreen<?> screen) {
        class_2483<?> nbt = this.getNBT();
        return IntStream.range(0, nbt.size()).mapToObj(i -> new NBTValue(screen, "" + i, (class_2520)nbt.get(i), nbt)).collect(Collectors.toList());
    }

    @Override
    public boolean hasEmptyKey() {
        return false;
    }

    @Override
    public class_2520 getValue(String key) {
        class_2483<?> nbt = this.getNBT();
        try {
            int i = Integer.parseInt(key);
            if (i < 0 || i >= nbt.size()) {
                return null;
            }
            return (class_2520)nbt.get(i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setValue(String key, class_2520 value) {
        class_2483<?> nbt = this.getNBT();
        int i = Integer.parseInt(key);
        if (nbt.size() == 1 && i == 0 && nbt instanceof class_2499) {
            class_2499 list = (class_2499)nbt;
            list.method_10536(0);
            list.add((Object)value);
            this.setNBT(nbt);
        } else {
            this.setValue(nbt, i, value);
        }
    }

    private <C extends class_2520> void setValue(class_2483<C> nbt, int i, class_2520 value) {
        C convertedValue = this.convertToType(nbt, value);
        if (convertedValue != null) {
            nbt.method_10606(i, convertedValue);
            this.setNBT(nbt);
        }
    }

    @Override
    public void addKey(String key) {
        class_2483<?> nbt = this.getNBT();
        this.addKey(nbt, Integer.parseInt(key));
        this.setNBT(nbt);
    }

    private <C extends class_2520> void addKey(class_2483<C> nbt, int i) {
        nbt.method_10531(i, this.getDefaultValue(nbt));
    }

    @Override
    public void removeKey(String key) {
        class_2483<?> nbt = this.getNBT();
        try {
            int i = Integer.parseInt(key);
            if (i >= 0 && i < nbt.size()) {
                nbt.method_10536(i);
                this.setNBT(nbt);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public Optional<String> getNextKey(Optional<String> pastingKey) {
        return Optional.of("" + this.getNBT().size());
    }

    private <C extends class_2520> C convertToType(class_2483<C> nbt, class_2520 value) {
        byte heldType = nbt.method_10601();
        if (heldType == 0 || heldType == value.method_10711()) {
            return (C)value;
        }
        if (heldType == 10) {
            class_2487 output = new class_2487();
            output.method_10566("value", value);
            return (C)output;
        }
        if (heldType == 9) {
            class_2499 output = new class_2499();
            output.add((Object)value);
            return (C)output;
        }
        if (heldType == 8) {
            return (C)class_2519.method_23256((String)value.toString());
        }
        if (value instanceof class_2514) {
            class_2514 num = (class_2514)value;
            return (C)(switch (heldType) {
                case 1 -> (class_2520)class_2481.method_23233((byte)num.method_10698());
                case 2 -> (class_2520)class_2516.method_23254((short)num.method_10696());
                case 3 -> (class_2520)class_2497.method_23247((int)num.method_10701());
                case 4 -> (class_2520)class_2503.method_23251((long)num.method_10699());
                case 5 -> (class_2520)class_2494.method_23244((float)num.method_10700());
                case 6 -> (class_2520)class_2489.method_23241((double)num.method_10697());
                case 7 -> (class_2520)new class_2479(new byte[]{num.method_10698()});
                case 11 -> (class_2520)new class_2495(new int[]{num.method_10701()});
                case 12 -> (class_2520)new class_2501(new long[]{num.method_10699()});
                default -> null;
            });
        }
        return null;
    }

    private <C extends class_2520> C getDefaultValue(class_2483<C> nbt) {
        return (C)(switch (nbt.method_10601()) {
            case 1 -> (class_2520)class_2481.field_21026;
            case 2 -> (class_2520)class_2516.method_23254((short)0);
            case 0, 3 -> (class_2520)class_2497.method_23247((int)0);
            case 4 -> (class_2520)class_2503.method_23251((long)0L);
            case 5 -> (class_2520)class_2494.field_21034;
            case 6 -> (class_2520)class_2489.field_21030;
            case 7 -> (class_2520)new class_2479(new byte[0]);
            case 11 -> (class_2520)new class_2495(new int[0]);
            case 12 -> (class_2520)new class_2501(new long[0]);
            case 9 -> (class_2520)new class_2499();
            case 10 -> (class_2520)new class_2487();
            case 8 -> (class_2520)class_2519.method_23256((String)"");
            default -> throw new IllegalArgumentException("Unknown NBT type: " + nbt.method_10601());
        });
    }

    @Override
    public Predicate<String> getKeyValidator(boolean renaming) {
        return MainUtil.intPredicate(() -> 0, () -> this.getNBT().size() + (renaming ? -1 : 0), false);
    }

    @Override
    public boolean handlesDuplicateKeys() {
        return true;
    }
}

