/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.BlockReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ButtonDropdownWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.FormattedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.SignSideTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;

public class SignboardScreen<L extends LocalNBT>
extends LocalEditorScreen<L> {
    private static boolean NEW_FEATURES = Version.newSwitch().range("1.20.0", null, true).range(null, "1.19.4", false).get();
    private final class_2960 texture;
    private boolean back;
    private FormattedTextFieldWidget lines;

    private static int getRenderedColor(class_1767 dye) {
        if (dye == class_1767.field_7963) {
            return -988212;
        }
        return MVMisc.scaleRgb(dye.method_16357(), 0.4);
    }

    public SignboardScreen(NBTReference<L> ref) {
        super(TextInst.of("Signboard"), ref);
        LocalNBT blockRef2;
        Object textureName;
        boolean hanging;
        String woodType;
        if (NEW_FEATURES) {
            class_2248 block = null;
            if (ref instanceof ItemReference) {
                Object itemRef = (ItemReference)ref;
                block = ((class_1822)itemRef.getItem().method_7909()).method_7711();
            } else if (ref instanceof BlockReference) {
                BlockReference blockRef2 = (BlockReference)ref;
                block = blockRef2.getBlock();
            }
            woodType = class_2478.method_45459(block).comp_1299();
            hanging = block instanceof class_7713 || block instanceof class_7715;
        } else {
            String id = ref.getId().method_12832();
            woodType = id.replaceAll("(_wall)?(_hanging)?_sign$", "");
            hanging = id.matches("^[a-z_]+_hanging_sign$");
        }
        if (hanging) {
            textureName = switch (woodType) {
                case "crimson" -> "stripped_crimson_stem";
                case "warped" -> "stripped_warped_stem";
                case "bamboo" -> "bamboo_planks";
                default -> "stripped_" + woodType + "_log";
            };
        } else {
            textureName = woodType + "_planks";
        }
        this.texture = IdentifierInst.of("minecraft", "textures/block/" + (String)textureName + ".png");
        if (NBTManagers.COMPONENTS_EXIST && (blockRef2 = this.localNBT) instanceof LocalItem) {
            LocalItem localItem = (LocalItem)blockRef2;
            class_2487 nbt = ItemTagReferences.BLOCK_ENTITY_DATA.get(localItem.getEditableItem());
            nbt.method_10582("id", localItem.getItemType() instanceof class_7707 ? "minecraft:hanging_sign" : "minecraft:sign");
            ItemTagReferences.BLOCK_ENTITY_DATA.set(localItem.getEditableItem(), nbt);
        }
    }

    private class_2487 getSideNbt() {
        class_2487 nbt;
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem localItem = (LocalItem)localNBT;
            nbt = ItemTagReferences.BLOCK_ENTITY_DATA.get(localItem.getEditableItem());
        } else {
            nbt = this.localNBT.getNBT();
            if (nbt == null) {
                return new class_2487();
            }
        }
        if (NEW_FEATURES) {
            return nbt.method_10562(this.back ? "back_text" : "front_text");
        }
        return nbt;
    }

    private void setSideNbt(class_2487 sideNbt) {
        if (!NEW_FEATURES) {
            LocalNBT localNBT = this.localNBT;
            if (localNBT instanceof LocalItem) {
                LocalItem localItem = (LocalItem)localNBT;
                ItemTagReferences.BLOCK_ENTITY_DATA.set(localItem.getEditableItem(), sideNbt);
            } else {
                this.localNBT.setNBT(sideNbt);
            }
            return;
        }
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem localItem = (LocalItem)localNBT;
            nbt = ItemTagReferences.BLOCK_ENTITY_DATA.get(localItem.getEditableItem());
            nbt.method_10566(this.back ? "back_text" : "front_text", (class_2520)sideNbt);
            ItemTagReferences.BLOCK_ENTITY_DATA.set(localItem.getEditableItem(), nbt);
        } else {
            nbt = this.localNBT.getNBT();
            nbt.method_10566(this.back ? "back_text" : "front_text", (class_2520)sideNbt);
            this.localNBT.setNBT(nbt);
        }
    }

    private void modifySideNbt(Consumer<class_2487> modifier) {
        class_2487 sideNbt = this.getSideNbt();
        modifier.accept(sideNbt);
        this.setSideNbt(sideNbt);
    }

    private void setWaxed(boolean waxed) {
        if (!NEW_FEATURES) {
            throw new IllegalStateException("Incorrect version!");
        }
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem localItem = (LocalItem)localNBT;
            nbt = ItemTagReferences.BLOCK_ENTITY_DATA.get(localItem.getEditableItem());
            nbt.method_10556("is_waxed", waxed);
            ItemTagReferences.BLOCK_ENTITY_DATA.set(localItem.getEditableItem(), nbt);
        } else {
            nbt = this.localNBT.getNBT();
            nbt.method_10556("is_waxed", waxed);
            this.localNBT.setNBT(nbt);
        }
        this.checkSave();
    }

    private boolean isWaxed() {
        class_2487 nbt;
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem localItem = (LocalItem)localNBT;
            nbt = ItemTagReferences.BLOCK_ENTITY_DATA.get(localItem.getEditableItem());
        } else {
            nbt = this.localNBT.getNBT();
        }
        return nbt != null && nbt.method_10577("is_waxed");
    }

    private void setGlowing(boolean glowing) {
        this.modifySideNbt(nbt -> SignSideTagReferences.GLOWING.set((class_2487)nbt, glowing));
        this.checkSave();
    }

    private boolean isGlowing() {
        return SignSideTagReferences.GLOWING.get(this.getSideNbt());
    }

    private void setColor(class_1767 color) {
        this.modifySideNbt(nbt -> SignSideTagReferences.COLOR.set((class_2487)nbt, color.method_7792()));
        this.checkSave();
    }

    private class_1767 getColor() {
        return class_1767.method_7793((String)SignSideTagReferences.COLOR.get(this.getSideNbt()), (class_1767)class_1767.field_7963);
    }

    private void setLines(List<class_2561> lines) {
        this.modifySideNbt(nbt -> SignSideTagReferences.TEXT.set((class_2487)nbt, lines.stream().map(this::fixClickEvent).map(line -> NEW_FEATURES ? this.fixEditable((class_2561)line) : line).toList()));
        this.checkSave();
    }

    private List<class_2561> getLines() {
        List<class_2561> output = SignSideTagReferences.TEXT.get(this.getSideNbt());
        while (output.size() < 4) {
            output.add(TextInst.of(""));
        }
        return output;
    }

    private class_2561 fixClickEvent(class_2561 line) {
        class_2558 event = this.getClickEvent(line);
        if (event == null) {
            return line;
        }
        return TextInst.copy(line).styled(style -> style.method_10958(event));
    }

    private class_2558 getClickEvent(class_2561 text) {
        class_2558 event = text.method_10866().method_10970();
        if (event != null) {
            return event;
        }
        for (class_2561 child : text.method_10855()) {
            event = this.getClickEvent(child);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    private class_2561 fixEditable(class_2561 line) {
        if (StyleUtil.identical(line.method_10866(), class_2583.field_24360) && line.method_10855().size() == 1 && ((class_2561)line.method_10855().get(0)).method_10855().isEmpty()) {
            return (class_2561)line.method_10855().get(0);
        }
        return line;
    }

    @Override
    protected void initEditor() {
        if (NEW_FEATURES) {
            this.method_37063((class_364)MVMisc.newButton(16, 64, 100, 20, TextInst.translatable("nbteditor.signboard.side." + (this.back ? "back" : "front"), new Object[0]), btn -> {
                this.back = !this.back;
                this.method_37067();
                this.method_25426();
            }));
            this.method_37063((class_364)MVMisc.newButton(120, 64, 100, 20, TextInst.translatable("nbteditor.signboard.wax." + (this.isWaxed() ? "enabled" : "disabled"), new Object[0]), btn -> {
                boolean prevWaxed = this.isWaxed();
                this.setWaxed(!prevWaxed);
                btn.method_25355((class_2561)TextInst.translatable("nbteditor.signboard.wax." + (prevWaxed ? "disabled" : "enabled"), new Object[0]));
            }));
        }
        int glowingBtnX = 16 + (NEW_FEATURES ? 208 : 0);
        int glowingBtnY = 64;
        AtomicReference<class_4185> glowingBtn = new AtomicReference<class_4185>();
        ButtonDropdownWidget colors = (ButtonDropdownWidget)this.method_25429(new ButtonDropdownWidget(glowingBtnX, glowingBtnY + 20, 20, 20, null, 20, 20){

            @Override
            public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 2.0);
                super.render(matrices, mouseX, mouseY, delta);
                matrices.method_22909();
            }
        });
        for (class_1767 color : class_1767.values()) {
            colors.addButton(TextInst.literal("\u2b1b").styled(style -> style.method_36139(SignboardScreen.getRenderedColor(color))), btn -> {
                this.setColor(color);
                colors.setOpen(false);
                ((class_4185)glowingBtn.get()).method_25355((class_2561)TextInst.translatable("nbteditor.signboard.glowing.enabled", new Object[0]).styled(style -> style.method_36139(SignboardScreen.getRenderedColor(this.getColor()))));
            }, new MVTooltip(TextInst.of(color.method_7792())));
        }
        colors.build();
        glowingBtn.set((class_4185)this.method_37063((class_364)MVMisc.newButton(glowingBtnX, glowingBtnY, 100, 20, TextInst.translatable("nbteditor.signboard.glowing." + (this.isGlowing() ? "enabled" : "disabled"), new Object[0]).styled(style -> style.method_36139(SignboardScreen.getRenderedColor(this.getColor()))), btn -> {
            boolean prevGlowing = this.isGlowing();
            if (prevGlowing && SignboardScreen.method_25442()) {
                colors.setOpen(true);
                return;
            }
            this.setGlowing(!prevGlowing);
            btn.method_25355((class_2561)TextInst.translatable("nbteditor.signboard.glowing." + (prevGlowing ? "disabled" : "enabled"), new Object[0]).styled(style -> style.method_36139(SignboardScreen.getRenderedColor(this.getColor()))));
            if (!prevGlowing) {
                colors.setOpen(true);
            }
        }, new MVTooltip("nbteditor.signboard.glowing.desc"))));
        this.lines = (FormattedTextFieldWidget)this.method_37063(FormattedTextFieldWidget.create(this.lines, 16, 88, this.field_22789 - 32, this.field_22790 - 80 - 24, this.getLines(), class_2583.field_24360.method_10977(class_124.field_1074), this::setLines));
        this.lines.setMaxLines(4);
        this.lines.setBackgroundColor(0);
        this.lines.setShadow(false);
        this.method_37060(colors);
    }

    @Override
    protected void preRenderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        MVDrawableHelper.drawTexture(matrices, this.texture, 16, 112, 0.0f, 0.0f, this.field_22789 - 32, this.field_22790 - 80 - 48);
    }
}

