/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.commands.OpenCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.AttributesCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.BlockStatesCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.SignboardCommand;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.AttributesScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.BlockStatesScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.BookScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.DisplayScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.EnchantmentsScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.SignboardScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class LocalFactoryScreen<L extends LocalNBT>
extends LocalEditorScreen<L> {
    public static final class_2960 FACTORY_ICON = IdentifierInst.of("nbteditor", "textures/factory.png");
    public static final List<LocalFactoryReference> BASIC_FACTORIES = new ArrayList<LocalFactoryReference>();
    private final ConfigCategory config = new ConfigCategory();
    private ConfigPanel panel;

    private static void addFactory(String key, Predicate<NBTReference<?>> supported, Function<NBTReference<?>, class_437> screen) {
        BASIC_FACTORIES.add(new LocalFactoryReference(TextInst.translatable(key, new Object[0]), supported, ref -> MainUtil.client.method_1507((class_437)screen.apply((NBTReference<?>)ref))));
    }

    private static <T extends NBTReference<?>> void addFactory(String key, Predicate<T> supported, Function<T, class_437> screen, Class<T> clazz) {
        LocalFactoryScreen.addFactory(key, (NBTReference<?> ref) -> clazz.isInstance(ref) && supported.test((NBTReference)clazz.cast(ref)), (NBTReference<?> ref) -> (class_437)screen.apply((NBTReference)clazz.cast(ref)));
    }

    private static void addFactory(String key, Function<NBTReference<?>, class_437> screen) {
        LocalFactoryScreen.addFactory(key, (NBTReference<?> ref) -> true, screen);
    }

    private static <T extends NBTReference<?>> void addFactory(String key, Function<T, class_437> screen, Class<T> clazz) {
        LocalFactoryScreen.addFactory(key, ref -> true, screen, clazz);
    }

    public LocalFactoryScreen(NBTReference<L> ref) {
        super(TextInst.of("Factories"), ref);
        for (LocalFactoryReference factory : BASIC_FACTORIES) {
            if (!factory.supported().test(ref)) continue;
            this.config.setConfigurable(factory.buttonText().getString(), new ConfigButton(150, factory.buttonText(), btn -> factory.factory().accept(ref)));
        }
    }

    @Override
    protected boolean isSaveRequried() {
        return false;
    }

    @Override
    protected LocalEditorScreen.FactoryLink<L> getFactoryLink() {
        return null;
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.config));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    static {
        LocalFactoryScreen.addFactory("nbteditor", ref -> new NBTEditorScreen(ref));
        BASIC_FACTORIES.add(new LocalFactoryReference(TextInst.translatable("nbteditor.container", new Object[0]), OpenCommand.CONTAINER_FILTER, ref -> ContainerScreen.show(ref)));
        LocalFactoryScreen.addFactory("nbteditor.book", ref -> ref.getItem().method_7909() == class_1802.field_8360, BookScreen::new, ItemReference.class);
        LocalFactoryScreen.addFactory("nbteditor.display", ref -> new DisplayScreen(ref));
        LocalFactoryScreen.addFactory("nbteditor.signboard", SignboardCommand.SIGNBOARD_FILTER, (NBTReference<?> ref) -> new SignboardScreen(ref));
        LocalFactoryScreen.addFactory("nbteditor.enchantments", EnchantmentsScreen::new, ItemReference.class);
        LocalFactoryScreen.addFactory("nbteditor.attributes", AttributesCommand.ATTRIBUTES_FILTER, (NBTReference<?> ref) -> new AttributesScreen(ref));
        LocalFactoryScreen.addFactory("nbteditor.block_states", BlockStatesCommand.BLOCK_FILTER, (NBTReference<?> ref) -> new BlockStatesScreen(ref));
    }

    public record LocalFactoryReference(class_2561 buttonText, Predicate<NBTReference<?>> supported, Consumer<NBTReference<?>> factory) {
    }
}

