/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigBar;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueBoolean;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.DisplayScreen;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific.data.HideFlag;

public class HideFlagsScreen
extends LocalEditorScreen<LocalItem> {
    private final ConfigCategory config = new ConfigCategory(TextInst.translatable("nbteditor.hide_flags", new Object[0]));
    private ConfigPanel panel;

    public HideFlagsScreen(ItemReference ref) {
        super(TextInst.of("Hide Flags"), ref);
        if (HideFlag.TOOLTIP.isInThisVersion()) {
            this.config.setConfigurable(HideFlag.TOOLTIP.name(), new ConfigItem<ConfigValueBoolean>(HideFlag.TOOLTIP.getText(), new ConfigValueBoolean(HideFlag.TOOLTIP.get(((LocalItem)this.localNBT).getEditableItem()), false, 100, ScreenTexts.ON, ScreenTexts.OFF)));
        }
        ConfigBar globalConfig = new ConfigBar();
        globalConfig.setConfigurable("show_all", new ConfigButton(100, TextInst.translatable("nbteditor.hide_flags.show_all", new Object[0]), btn -> this.setAll(false)));
        globalConfig.setConfigurable("hide_all", new ConfigButton(100, TextInst.translatable("nbteditor.hide_flags.hide_all", new Object[0]), btn -> this.setAll(true)));
        this.config.setConfigurable("global", globalConfig);
        for (HideFlag flag : HideFlag.values()) {
            if (flag == HideFlag.TOOLTIP || !flag.isInThisVersion()) continue;
            this.config.setConfigurable(flag.name(), new ConfigItem<ConfigValueBoolean>(flag.getText(), new ConfigValueBoolean(flag.get(((LocalItem)this.localNBT).getEditableItem()), false, 100, ScreenTexts.ON, ScreenTexts.OFF)));
        }
        this.config.addValueListener(source -> this.config.getConfigurables().forEach((flagName, path) -> {
            ConfigItem configItem;
            if (path instanceof ConfigItem && (configItem = (ConfigItem)path).getValue() == source) {
                HideFlag flag = HideFlag.valueOf(flagName);
                flag.set(((LocalItem)this.localNBT).getEditableItem(), (Boolean)source.getValidValue());
                this.checkSave();
            }
        }));
    }

    private void setAll(boolean hidden) {
        for (HideFlag flag : HideFlag.values()) {
            if (flag == HideFlag.TOOLTIP || !flag.isInThisVersion()) continue;
            ((ConfigValueBoolean)((ConfigItem)this.config.getConfigurable(flag.name())).getValue()).setValue(hidden);
        }
    }

    @Override
    protected LocalEditorScreen.FactoryLink<LocalItem> getFactoryLink() {
        return new LocalEditorScreen.FactoryLink<LocalItem>("nbteditor.display", DisplayScreen::new);
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.config));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }
}

