/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVComponentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt.NBTManagers;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.HideFlagsScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.FormattedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ImageToLoreWidget;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.EntityTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.StyleUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class DisplayScreen<L extends LocalNBT>
extends LocalEditorScreen<L> {
    private FormattedTextFieldWidget nameFormatted;
    private FormattedTextFieldWidget lore;
    private boolean itemNameType;

    public DisplayScreen(NBTReference<L> ref) {
        super(TextInst.of("Display"), ref);
    }

    @Override
    protected void initEditor() {
        MVMisc.setKeyboardRepeatEvents(true);
        Objects.requireNonNull(this.field_22793);
        this.nameFormatted = FormattedTextFieldWidget.create(this.nameFormatted, 16, 64, this.field_22789 - 32, 24 + 9 * 3, this.itemNameType ? MainUtil.getBaseItemNameSafely(((LocalItem)this.localNBT).getEditableItem()) : this.localNBT.getName(), false, StyleUtil.getBaseNameStyle(this.localNBT, this.itemNameType), text -> {
            if (this.itemNameType) {
                ((LocalItem)this.localNBT).getEditableItem().set(MVComponentType.ITEM_NAME, text);
            } else {
                this.localNBT.setName((class_2561)text);
            }
            this.name.method_1852(this.localNBT.getName().getString());
            this.checkSave();
        }).setOverscroll(false).setShadow(this.localNBT instanceof LocalItem);
        Objects.requireNonNull(this.field_22793);
        int nextY = 88 + 9 * 3 + 4;
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem item = (LocalItem)localNBT;
            this.lore = FormattedTextFieldWidget.create(this.lore, 16, nextY, this.field_22789 - 32, this.field_22790 - 16 - 20 - 4 - nextY, ItemTagReferences.LORE.get(item.getEditableItem()), StyleUtil.BASE_LORE_STYLE, lines -> {
                if (lines.size() == 1 && ((class_2561)lines.get(0)).getString().isEmpty()) {
                    ItemTagReferences.LORE.set(item.getEditableItem(), new ArrayList());
                } else {
                    ItemTagReferences.LORE.set(item.getEditableItem(), (List<class_2561>)lines);
                }
                this.checkSave();
            });
            this.method_25429(this.nameFormatted);
            this.method_25429(this.lore);
            this.method_37063((class_364)MVMisc.newButton(16, this.field_22790 - 16 - 20, 100, 20, TextInst.translatable("nbteditor.hide_flags", new Object[0]), btn -> this.closeSafely(() -> this.field_22787.method_1507((class_437)new HideFlagsScreen((ItemReference)this.ref)))));
            if (NBTManagers.COMPONENTS_EXIST) {
                this.method_37063((class_364)MVMisc.newButton(124, this.field_22790 - 16 - 20, 150, 20, TextInst.translatable("nbteditor.display.name_type." + (this.itemNameType ? "item" : "custom"), new Object[0]), btn -> {
                    this.itemNameType = !this.itemNameType;
                    btn.method_25355((class_2561)TextInst.translatable("nbteditor.display.name_type." + (this.itemNameType ? "item" : "custom"), new Object[0]));
                    this.nameFormatted = null;
                    this.method_37067();
                    this.method_25426();
                }));
            }
            this.method_37060(this.lore);
        } else {
            this.method_25429(this.nameFormatted);
        }
        localNBT = this.localNBT;
        if (localNBT instanceof LocalEntity) {
            LocalEntity entity = (LocalEntity)localNBT;
            this.method_37063((class_364)MVMisc.newButton(16, nextY, 150, 20, TextInst.translatable("nbteditor.display.custom_name_visible." + (EntityTagReferences.CUSTOM_NAME_VISIBLE.get(entity) != false ? "enabled" : "disabled"), new Object[0]), btn -> {
                boolean customNameVisible = EntityTagReferences.CUSTOM_NAME_VISIBLE.get(entity) == false;
                EntityTagReferences.CUSTOM_NAME_VISIBLE.set(entity, customNameVisible);
                btn.method_25355((class_2561)TextInst.translatable("nbteditor.display.custom_name_visible." + (customNameVisible ? "enabled" : "disabled"), new Object[0]));
                this.checkSave();
            }));
        }
    }

    @Override
    protected void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 1.0);
        this.nameFormatted.render(matrices, mouseX, mouseY, delta);
        matrices.method_22909();
    }

    public void method_29638(List<Path> paths) {
        if (!(this.localNBT instanceof LocalItem)) {
            return;
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add(this.lore.getText());
        ImageToLoreWidget.openImportFiles(paths, (file, imgLines) -> lines.addAll((Collection<class_2561>)imgLines), () -> {
            if (lines.size() > 1) {
                this.lore.setText(lines);
            }
        });
    }

    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }
}

