/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.AlertWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.FormattedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ImageToLoreWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.TranslatedGroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.WrittenBookTagReferences;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3872;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class BookScreen
extends LocalEditorScreen<LocalItem> {
    private int page;
    private GroupWidget group;
    private NamedTextFieldWidget title;
    private NamedTextFieldWidget author;
    private GroupWidget gen;
    private FormattedTextFieldWidget contents;

    public BookScreen(ItemReference ref, int page) {
        super(TextInst.of("Book"), ref);
        this.page = page;
    }

    public BookScreen(ItemReference ref) {
        this(ref, 0);
    }

    private String getBookTitle() {
        return WrittenBookTagReferences.TITLE.get(((LocalItem)this.localNBT).getEditableItem());
    }

    private void setBookTitle(String title) {
        WrittenBookTagReferences.TITLE.set(((LocalItem)this.localNBT).getEditableItem(), title);
        this.checkSave();
    }

    private String getAuthor() {
        return WrittenBookTagReferences.AUTHOR.get(((LocalItem)this.localNBT).getEditableItem());
    }

    private void setAuthor(String author) {
        WrittenBookTagReferences.AUTHOR.set(((LocalItem)this.localNBT).getEditableItem(), author);
        this.checkSave();
    }

    private Generation getGeneration() {
        int gen = WrittenBookTagReferences.GENERATION.get(((LocalItem)this.localNBT).getEditableItem());
        if (gen < 0 || gen >= 4) {
            return Generation.TATTERED;
        }
        return Generation.values()[gen];
    }

    private void setGeneration(Generation gen) {
        WrittenBookTagReferences.GENERATION.set(((LocalItem)this.localNBT).getEditableItem(), gen.ordinal());
        this.checkSave();
    }

    private int getPageCount() {
        return WrittenBookTagReferences.PAGES.get(((LocalItem)this.localNBT).getEditableItem()).size();
    }

    private class_2561 getPage() {
        List<class_2561> pages = WrittenBookTagReferences.PAGES.get(((LocalItem)this.localNBT).getEditableItem());
        return this.page < pages.size() ? pages.get(this.page) : TextInst.of("");
    }

    private void setPage(class_2561 contents) {
        List<class_2561> pages = WrittenBookTagReferences.PAGES.get(((LocalItem)this.localNBT).getEditableItem());
        if (this.page < pages.size()) {
            pages.set(this.page, contents);
        } else {
            while (this.page > pages.size()) {
                pages.add(TextInst.of(""));
            }
            pages.add(contents);
        }
        WrittenBookTagReferences.PAGES.set(((LocalItem)this.localNBT).getEditableItem(), pages);
        this.checkSave();
    }

    private void addPage() {
        List<class_2561> pages = WrittenBookTagReferences.PAGES.get(((LocalItem)this.localNBT).getEditableItem());
        if (this.page < pages.size()) {
            pages.add(this.page, TextInst.of(""));
            WrittenBookTagReferences.PAGES.set(((LocalItem)this.localNBT).getEditableItem(), pages);
            this.checkSave();
            this.refresh();
        }
    }

    private void removePage() {
        List<class_2561> pages = WrittenBookTagReferences.PAGES.get(((LocalItem)this.localNBT).getEditableItem());
        if (this.page < pages.size()) {
            pages.remove(this.page);
            WrittenBookTagReferences.PAGES.set(((LocalItem)this.localNBT).getEditableItem(), pages);
            this.checkSave();
            this.refresh();
        }
    }

    private void back() {
        if (this.page > 0) {
            --this.page;
            this.refresh();
        }
    }

    private void forward() {
        ++this.page;
        this.refresh();
    }

    private void refresh() {
        this.contents = null;
        this.method_37067();
        this.method_25426();
    }

    private class_3872.class_3931 getPreviewItem() {
        List<class_2561> pages = WrittenBookTagReferences.PAGES.get(((LocalItem)this.localNBT).getEditableItem());
        pages.replaceAll(this::makePreviewText);
        return MVMisc.getBookContents(pages);
    }

    private class_2561 makePreviewText(class_2561 text) {
        EditableText output = TextInst.copy(text);
        output.setStyle(this.makePreviewStyle(output.method_10866()));
        output.method_10855().replaceAll(this::makePreviewText);
        return output;
    }

    private class_2583 makePreviewStyle(class_2583 style) {
        if (style.method_10970() == null) {
            return style;
        }
        return MixinLink.withRunClickEvent(style, () -> {
            class_3872 preview = (class_3872)this.getOverlay();
            this.setOverlay(new AlertWidget(() -> this.setOverlayScreen(preview, 500.0), TextInst.translatable("nbteditor.book.preview.click.title", new Object[0]), TextInst.of(""), TextInst.translatable("nbteditor.book.preview.click.action", MVMisc.getClickEventActionName(style.method_10970().method_10845())), TextInst.of(""), TextInst.translatable("nbteditor.book.preview.click.value", style.method_10970().method_10844())), 500.0);
        });
    }

    @Override
    protected void initEditor() {
        MVMisc.setKeyboardRepeatEvents(true);
        this.group = new GroupWidget();
        this.method_37063(this.group);
        this.title = this.group.addWidget(new NamedTextFieldWidget(16, 66, 100, 16).name(TextInst.translatable("nbteditor.book.title", new Object[0])));
        this.title.method_1880(32);
        this.title.method_1852(this.getBookTitle());
        this.title.method_1863(this::setBookTitle);
        this.author = this.group.addWidget(new NamedTextFieldWidget(124, 66, 100, 16).name(TextInst.translatable("nbteditor.book.author", new Object[0])));
        this.author.method_1880(Integer.MAX_VALUE);
        this.author.method_1852(this.getAuthor());
        this.author.method_1863(this::setAuthor);
        this.gen = this.group.addElement(TranslatedGroupWidget.forWidget(ConfigValueDropdown.forEnum(this.getGeneration(), Generation.ORIGINAL, Generation.class).addValueListener(value -> this.setGeneration((Generation)((Object)((Object)value.getValidValue())))), 232.0, 64.0, 0.0));
        this.group.addWidget(MVMisc.newButton(336, 64, 20, 20, TextInst.translatable("nbteditor.book.add", new Object[0]), btn -> this.addPage()));
        this.group.addWidget(MVMisc.newButton(360, 64, 20, 20, TextInst.translatable("nbteditor.book.remove", new Object[0]), btn -> this.removePage()));
        this.group.addWidget(MVMisc.newButton(384, 64, 20, 20, TextInst.translatable("nbteditor.book.preview.icon", new Object[0]), btn -> {
            class_3872 preview = new class_3872(this.getPreviewItem()){

                public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                    if (keyCode == 256) {
                        BookScreen.this.setOverlay(null);
                        return true;
                    }
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
            };
            this.setOverlayScreen(preview, 200.0);
            preview.method_17556(this.page);
        }, new MVTooltip("nbteditor.book.preview")));
        this.contents = this.group.addWidget(FormattedTextFieldWidget.create(this.contents, 40, 88, this.field_22789 - 32 - 48, this.field_22790 - 80 - 24, this.getPage(), true, class_2583.field_24360.method_10977(class_124.field_1074), this::setPage));
        this.contents.setBackgroundColor(-132885);
        this.contents.setCursorColor(-16777216);
        this.contents.setSelectionColor(0x55000000);
        this.contents.setShadow(false);
        this.group.addDrawable(this.gen);
        EditableText prevKeybind = TextInst.translatable("nbteditor.keybind.page.down", new Object[0]);
        EditableText nextKeybind = TextInst.translatable("nbteditor.keybind.page.up", new Object[0]);
        if (ConfigScreen.isInvertedPageKeybinds()) {
            EditableText temp = prevKeybind;
            prevKeybind = nextKeybind;
            nextKeybind = temp;
        }
        this.group.addWidget(MVMisc.newButton((int)16, (int)88, (int)20, (int)(this.field_22790 - 80 - 24), (class_2561)TextInst.translatable((String)"nbteditor.book.back", (Object[])new Object[0]), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$initEditor$6(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((BookScreen)this), (MVTooltip)(ConfigScreen.isKeybindsHidden() ? null : new MVTooltip((class_2561[])new class_2561[]{TextInst.literal((String)"").append((class_2561)prevKeybind).append((class_2561)TextInst.translatable((String)"nbteditor.keybind.page.prev", (Object[])new Object[0]))})))).field_22763 = this.page > 0;
        this.group.addWidget(MVMisc.newButton(this.field_22789 - 16 - 20, 88, 20, this.field_22790 - 80 - 24, TextInst.translatable("nbteditor.book.forward", new Object[0]), btn -> this.forward(), ConfigScreen.isKeybindsHidden() ? null : new MVTooltip(TextInst.literal("").append(nextKeybind).append(TextInst.translatable("nbteditor.keybind.page.next", new Object[0])))));
    }

    @Override
    protected void renderEditor(class_4587 matrices, int fdf8eb, int mouseY, float delta) {
        EditableText editableText = TextInst.translatable("nbteditor.book.page", this.page + 1, this.getPageCount());
        Objects.requireNonNull(this.field_22793);
        MVDrawableHelper.drawTextWithShadow(matrices, this.field_22793, editableText, 408, 74 - 9 / 2, -1);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.getOverlay() != null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 266 || keyCode == 267) {
            boolean prev;
            boolean bl = prev = keyCode == 267;
            if (ConfigScreen.isInvertedPageKeybinds()) {
                boolean bl2 = prev = !prev;
            }
            if (prev) {
                this.back();
            } else {
                this.forward();
            }
            return true;
        }
        return false;
    }

    public void method_29638(List<Path> paths) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add(this.getPage());
        ImageToLoreWidget.openImportFiles(paths, (file, imgLines) -> lines.addAll((Collection<class_2561>)imgLines), () -> {
            if (lines.size() > 1) {
                this.contents.setText(lines);
            }
        });
    }

    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }

    private /* synthetic */ void lambda$initEditor$6(class_4185 btn) {
        this.back();
    }

    private static enum Generation {
        ORIGINAL,
        COPY_OF_ORIGINAL,
        COPY_OF_COPY,
        TATTERED;


        public String toString() {
            return TextInst.translatable("book.generation." + this.ordinal(), new Object[0]).getString();
        }
    }
}

