/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.BlockStateProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1747;
import net.minecraft.class_4587;

public class BlockStatesScreen<L extends LocalNBT>
extends LocalEditorScreen<L> {
    private final ConfigCategory blockStates;
    private final boolean hasBlockStates;
    private ConfigPanel panel;

    public BlockStatesScreen(NBTReference<L> ref) {
        super(TextInst.of("Block States"), ref);
        Set<String> unset;
        BlockStateProperties state;
        BlockStateProperties defaultState;
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem item = (LocalItem)localNBT;
            defaultState = new BlockStateProperties(((class_1747)item.getItemType()).method_7711().method_9564());
            state = defaultState.copy();
            unset = state.setValuesMap(ItemTagReferences.BLOCK_STATE.get(item.getEditableItem()));
        } else {
            localNBT = this.localNBT;
            if (localNBT instanceof LocalBlock) {
                LocalBlock block = (LocalBlock)localNBT;
                defaultState = new BlockStateProperties(block.getBlock().method_9564());
                state = block.getState();
                unset = new HashSet<String>();
            } else {
                throw new IllegalStateException("BlockStatesScreen doesn't support " + this.localNBT.getClass().getName());
            }
        }
        this.hasBlockStates = !defaultState.getProperties().isEmpty();
        this.blockStates = new ConfigCategory(this.hasBlockStates ? TextInst.translatable("nbteditor.block_states", new Object[0]) : null);
        for (String property : defaultState.getProperties()) {
            String value = unset.contains(property) ? "unset" : state.getValue(property);
            ArrayList<String> options = new ArrayList<String>(defaultState.getOptions(property));
            if (this.localNBT instanceof LocalItem) {
                options.add(0, "unset");
            }
            this.blockStates.setConfigurable(property, new ConfigItem<ConfigValue>(TextInst.literal(property), ConfigValueDropdown.forList(value, defaultState.getValue(property), options).addValueListener(dropdown -> {
                String newValue = (String)dropdown.getValidValue();
                if (newValue.equals("unset")) {
                    unset.add(property);
                } else {
                    unset.remove(property);
                    state.setValue(property, newValue);
                }
                LocalNBT patt0$temp = this.localNBT;
                if (patt0$temp instanceof LocalItem) {
                    LocalItem item = (LocalItem)patt0$temp;
                    Map<String, String> blockStatesMap = state.getValuesMap();
                    blockStatesMap.keySet().removeAll(unset);
                    ItemTagReferences.BLOCK_STATE.set(item.getEditableItem(), blockStatesMap);
                }
                this.checkSave();
            })));
        }
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.blockStates));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    @Override
    public void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.hasBlockStates) {
            MVDrawableHelper.drawTextWithShadow(matrices, this.field_22793, TextInst.translatable("nbteditor.block_states.none", new Object[0]), 16, 64, -1);
        }
    }
}

