/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigBar;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigHiddenData;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigHiddenDataNamed;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigList;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueNumber;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.EntityTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.specific.data.AttributeData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_2960;

public class AttributesScreen<L extends LocalNBT>
extends LocalEditorScreen<L> {
    private static final Map<String, class_1320> ATTRIBUTES = MVRegistry.ATTRIBUTE.getEntrySet().stream().map(attribute -> Map.entry(((class_2960)attribute.getKey()).toString(), (class_1320)attribute.getValue())).sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
    private static final ConfigHiddenDataNamed<ConfigCategory, AttributeData.AttributeModifierData.AttributeModifierId> BASE_ATTRIBUTE_ENTRY;
    private static final ConfigHiddenDataNamed<ConfigCategory, AttributeData.AttributeModifierData.AttributeModifierId> ATTRIBUTE_ENTRY;
    private final ConfigList attributes;
    private ConfigPanel panel;

    private static ConfigButton createExtremeAmountBtn(String key, boolean mostPositive, boolean infinity) {
        return new ConfigButton(30, TextInst.translatable(key, new Object[0]), btn -> {
            ConfigCategory attribute = (ConfigCategory)btn.getParent().getParent();
            class_1320 type = ATTRIBUTES.get(AttributesScreen.getConfigAttribute(attribute).getValidValue());
            double min = Double.MIN_VALUE;
            double max = Double.MAX_VALUE;
            if (type instanceof class_1329) {
                class_1329 clamped = (class_1329)type;
                min = clamped.method_35061();
                max = clamped.method_35062();
            }
            double value = !infinity ? (!mostPositive ? min : max) : (!mostPositive ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            AttributesScreen.getConfigAmount(attribute).setValue(value);
        }, new MVTooltip(key + ".desc"));
    }

    private static ConfigValueDropdown<String> getConfigAttribute(ConfigCategory attribute) {
        return (ConfigValueDropdown)((ConfigItem)attribute.getConfigurable("attribute")).getValue();
    }

    private static ConfigValueDropdown<AttributeData.AttributeModifierData.Operation> getConfigOperation(ConfigCategory attribute) {
        return (ConfigValueDropdown)((ConfigItem)attribute.getConfigurable("operation")).getValue();
    }

    private static ConfigValueNumber<Double> getConfigAmount(ConfigCategory attribute) {
        return (ConfigValueNumber)((ConfigItem)((ConfigBar)attribute.getConfigurable("amount")).getConfigurable("number")).getValue();
    }

    private static ConfigValueDropdown<AttributeData.AttributeModifierData.Slot> getConfigSlot(ConfigCategory attribute) {
        return (ConfigValueDropdown)((ConfigItem)attribute.getConfigurable("slot")).getValue();
    }

    public AttributesScreen(NBTReference<L> ref) {
        super(TextInst.of("Attributes"), ref);
        List<AttributeData> list;
        boolean modifiers = ref instanceof ItemReference;
        ConfigHiddenDataNamed<ConfigCategory, AttributeData.AttributeModifierData.AttributeModifierId> entry = modifiers ? ATTRIBUTE_ENTRY : BASE_ATTRIBUTE_ENTRY;
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem localItem = (LocalItem)localNBT;
            list = ItemTagReferences.ATTRIBUTES.get(localItem.getEditableItem());
        } else {
            list = EntityTagReferences.ATTRIBUTES.get((LocalEntity)this.localNBT);
        }
        List<AttributeData> attributes = list;
        this.attributes = new ConfigList(TextInst.translatable("nbteditor.attributes", new Object[0]), false, entry);
        for (AttributeData attribute : attributes) {
            ConfigHiddenData hiddenAttributeConfig = entry.clone(true);
            ConfigCategory attributeConfig = (ConfigCategory)hiddenAttributeConfig.getVisible();
            AttributesScreen.getConfigAttribute(attributeConfig).setValue(MVRegistry.ATTRIBUTE.getId(attribute.attribute()).toString());
            AttributesScreen.getConfigAmount(attributeConfig).setValue(attribute.value());
            if (modifiers) {
                AttributeData.AttributeModifierData modifier = attribute.modifierData().get();
                AttributesScreen.getConfigOperation(attributeConfig).setValue(modifier.operation());
                AttributesScreen.getConfigSlot(attributeConfig).setValue(modifier.slot());
                hiddenAttributeConfig.setData(modifier.id());
            }
            this.attributes.addConfigurable(hiddenAttributeConfig);
        }
        this.attributes.addValueListener(source -> {
            ArrayList<AttributeData> newAttributes = new ArrayList<AttributeData>();
            for (ConfigPath path : this.attributes.getConfigurables().values()) {
                ConfigHiddenDataNamed hiddenAttributeConfig = (ConfigHiddenDataNamed)path;
                ConfigCategory attributeConfig = (ConfigCategory)hiddenAttributeConfig.getVisible();
                class_1320 attribute = ATTRIBUTES.get(AttributesScreen.getConfigAttribute(attributeConfig).getValidValue());
                double amount = (Double)AttributesScreen.getConfigAmount(attributeConfig).getValidValue();
                if (modifiers) {
                    AttributeData.AttributeModifierData.Operation operation = (AttributeData.AttributeModifierData.Operation)((Object)((Object)AttributesScreen.getConfigOperation(attributeConfig).getValidValue()));
                    AttributeData.AttributeModifierData.Slot slot = (AttributeData.AttributeModifierData.Slot)((Object)((Object)AttributesScreen.getConfigSlot(attributeConfig).getValidValue()));
                    AttributeData.AttributeModifierData.AttributeModifierId id = (AttributeData.AttributeModifierData.AttributeModifierId)hiddenAttributeConfig.getData();
                    newAttributes.add(new AttributeData(attribute, amount, operation, slot, id));
                    continue;
                }
                newAttributes.add(new AttributeData(attribute, amount));
            }
            LocalNBT patt0$temp = this.localNBT;
            if (patt0$temp instanceof LocalItem) {
                LocalItem localItem = (LocalItem)patt0$temp;
                ItemTagReferences.ATTRIBUTES.set(localItem.getEditableItem(), newAttributes);
            } else {
                EntityTagReferences.ATTRIBUTES.set((LocalEntity)this.localNBT, newAttributes);
            }
            this.checkSave();
        });
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.attributes));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    static {
        String firstAttribute = (String)ATTRIBUTES.keySet().stream().findFirst().get();
        ConfigCategory visibleBase = new ConfigCategory();
        visibleBase.setConfigurable("attribute", new ConfigItem<ConfigValueDropdown<String>>(TextInst.translatable("nbteditor.attributes.attribute", new Object[0]), ConfigValueDropdown.forList(firstAttribute, firstAttribute, new ArrayList<String>(ATTRIBUTES.keySet()))));
        visibleBase.setConfigurable("amount", (ConfigPath)((ConfigBar)((ConfigBar)((ConfigBar)((ConfigBar)new ConfigBar().setConfigurable("number", new ConfigItem<ConfigValueNumber<Double>>(TextInst.translatable("nbteditor.attributes.base", new Object[0]), ConfigValueNumber.forDouble(0.0, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)))).setConfigurable("max", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.max", true, false))).setConfigurable("min", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.min", false, false))).setConfigurable("infinity", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.infinity", true, true))).setConfigurable("negative_infinity", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.negative_infinity", false, true)));
        BASE_ATTRIBUTE_ENTRY = new ConfigHiddenDataNamed<ConfigCategory, AttributeData.AttributeModifierData.AttributeModifierId>(visibleBase, AttributeData.AttributeModifierData.AttributeModifierId.randomUUID(), (id, defaults) -> AttributeData.AttributeModifierData.AttributeModifierId.randomUUID());
        ConfigCategory visible = new ConfigCategory();
        visible.setConfigurable("attribute", new ConfigItem<ConfigValueDropdown<String>>(TextInst.translatable("nbteditor.attributes.attribute", new Object[0]), ConfigValueDropdown.forList(firstAttribute, firstAttribute, new ArrayList<String>(ATTRIBUTES.keySet()))));
        visible.setConfigurable("operation", new ConfigItem<ConfigValueDropdown<AttributeData.AttributeModifierData.Operation>>(TextInst.translatable("nbteditor.attributes.operation", new Object[0]), ConfigValueDropdown.forEnum(AttributeData.AttributeModifierData.Operation.ADD, AttributeData.AttributeModifierData.Operation.ADD, AttributeData.AttributeModifierData.Operation.class)));
        visible.setConfigurable("amount", (ConfigPath)((ConfigBar)((ConfigBar)((ConfigBar)((ConfigBar)new ConfigBar().setConfigurable("number", new ConfigItem<ConfigValueNumber<Double>>(TextInst.translatable("nbteditor.attributes.amount", new Object[0]), ConfigValueNumber.forDouble(0.0, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)))).setConfigurable("max", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.max", true, false))).setConfigurable("min", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.min", false, false))).setConfigurable("infinity", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.infinity", true, true))).setConfigurable("negative_infinity", AttributesScreen.createExtremeAmountBtn("nbteditor.attributes.amount.negative_infinity", false, true)));
        visible.setConfigurable("slot", new ConfigItem<ConfigValueDropdown<AttributeData.AttributeModifierData.Slot>>(TextInst.translatable("nbteditor.attributes.slot", new Object[0]), ConfigValueDropdown.forFilteredEnum(AttributeData.AttributeModifierData.Slot.ANY, AttributeData.AttributeModifierData.Slot.ANY, AttributeData.AttributeModifierData.Slot.class, AttributeData.AttributeModifierData.Slot::isInThisVersion)));
        ATTRIBUTE_ENTRY = new ConfigHiddenDataNamed<ConfigCategory, AttributeData.AttributeModifierData.AttributeModifierId>(visible, AttributeData.AttributeModifierData.AttributeModifierId.randomUUID(), (id, defaults) -> AttributeData.AttributeModifierData.AttributeModifierId.randomUUID());
    }
}

