/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.containers;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.SlotUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_4587;

public class LockedSlotsInfo {
    public static final LockedSlotsInfo NONE = new LockedSlotsInfo(false, false, true);
    public static final LockedSlotsInfo ITEMS_LOCKED = new LockedSlotsInfo(true, false, true);
    public static final LockedSlotsInfo ALL_LOCKED = new LockedSlotsInfo(true, true, true);
    private final boolean itemsLocked;
    private final boolean airLocked;
    private final boolean copyLockedItem;
    private final List<Integer> playerLockedSlots;
    private final List<Integer> playerLockedHotbarSlots;
    private final List<Integer> containerLockedSlots;

    public LockedSlotsInfo(boolean itemsLocked, boolean airLocked, boolean copyLockedItem) {
        this.itemsLocked = itemsLocked;
        this.airLocked = airLocked;
        this.copyLockedItem = copyLockedItem;
        this.playerLockedSlots = new ArrayList<Integer>();
        this.playerLockedHotbarSlots = new ArrayList<Integer>();
        this.containerLockedSlots = new ArrayList<Integer>();
    }

    private LockedSlotsInfo(LockedSlotsInfo info) {
        this.itemsLocked = info.itemsLocked;
        this.airLocked = info.airLocked;
        this.copyLockedItem = info.copyLockedItem;
        this.playerLockedSlots = new ArrayList<Integer>(info.playerLockedSlots);
        this.playerLockedHotbarSlots = new ArrayList<Integer>(info.playerLockedHotbarSlots);
        this.containerLockedSlots = new ArrayList<Integer>(info.containerLockedSlots);
    }

    public boolean isCopyLockedItem() {
        return this.copyLockedItem;
    }

    public LockedSlotsInfo addPlayerSlot(int slot) {
        this.playerLockedSlots.add(slot);
        if (SlotUtil.isHotbarFromInv(slot) || SlotUtil.isOffHandFromInv(slot)) {
            this.playerLockedHotbarSlots.add(slot);
        }
        return this;
    }

    public LockedSlotsInfo addPlayerSlot(ItemReference itemRef) {
        int slot = itemRef.getBlockedSlot();
        if (slot != -1) {
            this.addPlayerSlot(slot);
        }
        return this;
    }

    public LockedSlotsInfo addContainerSlot(int slot) {
        this.containerLockedSlots.add(slot);
        return this;
    }

    public boolean isBlocked(class_1735 slot, int button, class_1713 actionType, boolean explicitly) {
        if (actionType == class_1713.field_7791 && this.playerLockedHotbarSlots.contains(button)) {
            return true;
        }
        if (slot.field_7871 == MainUtil.client.field_1724.method_31548()) {
            if (this.playerLockedSlots.contains(slot.method_34266())) {
                return true;
            }
        } else {
            class_1799 item;
            if (this.containerLockedSlots.contains(slot.method_34266())) {
                return true;
            }
            if (!explicitly && ((item = slot.method_7677()) == null || item.method_7960() ? this.airLocked : this.itemsLocked)) {
                return true;
            }
        }
        return false;
    }

    public boolean isBlocked(class_1735 slot, boolean explicitly) {
        return this.isBlocked(slot, 0, class_1713.field_7790, explicitly);
    }

    public void renderLockedHighlights(class_4587 matrices, class_1703 handler, boolean explicitly, boolean player, boolean container) {
        for (class_1735 slot : handler.field_7761) {
            if (!(slot.field_7871 == MainUtil.client.field_1724.method_31548() ? player : container) || !this.isBlocked(slot, explicitly)) continue;
            MVDrawableHelper.drawSlotHighlight(matrices, slot.field_7873, slot.field_7872, 0x60FF0000);
        }
    }

    public LockedSlotsInfo copy() {
        return new LockedSlotsInfo(this);
    }
}

