/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.containers;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ContainerItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientScreenHandler;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.LockedSlotsInfo;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.LocalFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.lang.invoke.LambdaMetafactory;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;

public class ContainerScreen<L extends LocalNBT>
extends ClientHandledScreen {
    private final class_2561 unsavedTitle;
    private final NBTReference<L> ref;
    private final L localNBT;
    private final int numSlots;
    private boolean saved;
    private boolean navigationClicked;

    public static <L extends LocalNBT> void show(NBTReference<L> ref) {
        if (!ref.exists() || !ContainerIO.isContainer(ref.getLocalNBT())) {
            ref.showParent();
            return;
        }
        NBTEditorClient.CURSOR_MANAGER.showBranch((class_465<?>)new ContainerScreen<L>(ref));
    }

    private ContainerScreen(NBTReference<L> ref) {
        super(new ClientScreenHandler(3), TextInst.translatable("nbteditor.container.title", new Object[0]).append(ref.getLocalNBT().getName()));
        this.unsavedTitle = TextInst.copy(this.field_22785).append("*");
        this.ref = ref;
        this.localNBT = LocalNBT.copy(ref.getLocalNBT());
        this.numSlots = ContainerIO.getMaxSize(this.localNBT);
        this.saved = true;
        class_1799[] contents = ContainerIO.read(this.localNBT);
        for (int i = 0; i < contents.length; ++i) {
            ((class_1707)this.field_2797).method_7611(i).method_7673(contents[i] == null ? class_1799.field_8037 : contents[i].method_7972());
        }
    }

    @Override
    protected void method_25426() {
        ItemReference item;
        super.method_25426();
        NBTReference<L> nBTReference = this.ref;
        if (nBTReference instanceof ItemReference && (item = (ItemReference)nBTReference).isLockable()) {
            ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)16, (int)64, (int)83, (int)20, (class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable((String)"nbteditor.client_chest.slots.unlock", (Object[])new Object[0]) : TextInst.translatable((String)"nbteditor.client_chest.slots.lock", (Object[])new Object[0])), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$0(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ContainerScreen)this)))).field_22763 = !ConfigScreen.isLockSlotsRequired();
        }
        this.method_37063((class_364)MVMisc.newTexturedButton(this.field_22789 - 36, 22, 20, 20, 20, LocalFactoryScreen.FACTORY_ICON, btn -> this.field_22787.method_1507(new LocalFactoryScreen<L>(this.ref)), new MVTooltip("nbteditor.factory")));
    }

    @Override
    protected class_2561 getRenderedTitle() {
        return this.saved ? this.field_22785 : this.unsavedTitle;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.navigationClicked = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (this.navigationClicked) {
            return;
        }
        super.method_2383(slot, slotId, button, actionType);
    }

    @Override
    public boolean allowEnchantmentCombine() {
        return true;
    }

    @Override
    public LockedSlotsInfo getLockedSlotsInfo() {
        ItemReference itemRef;
        NBTReference<L> nBTReference = this.ref;
        LockedSlotsInfo info = (nBTReference instanceof ItemReference && (itemRef = (ItemReference)nBTReference).isLocked() ? LockedSlotsInfo.ITEMS_LOCKED : LockedSlotsInfo.NONE).copy();
        nBTReference = this.ref;
        if (nBTReference instanceof ItemReference) {
            itemRef = (ItemReference)nBTReference;
            info.addPlayerSlot(itemRef);
        }
        for (int slot = this.numSlots; slot < 27; ++slot) {
            info.addContainerSlot(slot);
        }
        return info;
    }

    @Override
    public void onChange() {
        this.save();
    }

    private void save() {
        class_1799[] contents = new class_1799[((class_1707)this.field_2797).method_7629().method_5439()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = ((class_1707)this.field_2797).method_7629().method_5438(i);
        }
        ContainerIO.write(this.localNBT, contents);
        this.saved = false;
        this.ref.saveLocalNBT(this.localNBT, () -> {
            this.saved = true;
        });
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (MainUtil.client.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.ref.showParent();
            return true;
        }
        if (!(this.field_2787 == null || this.field_2787.field_7874 >= this.numSlots && this.field_2787.field_7871 == ((class_1707)this.field_2797).method_7629() || keyCode == 261 && this.getLockedSlotsInfo().isBlocked(this.field_2787, true) || !ContainerScreen.handleKeybind(keyCode, this.field_2787, () -> ContainerScreen.show(this.ref), slot -> this.getContainerRef(slot.method_34266())))) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private ContainerItemReference<L> getContainerRef(int slot) {
        class_1799[] contents = new class_1799[((class_1707)this.field_2797).method_7629().method_5439()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = ((class_1707)this.field_2797).method_7629().method_5438(i);
        }
        return new ContainerItemReference<L>(this.ref, ContainerIO.getWrittenSlotIndex(this.localNBT, contents, slot));
    }

    @Override
    protected void method_37432() {
        if (!this.ref.exists()) {
            this.ref.showParent();
        }
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public NBTReference<L> getReference() {
        return this.ref;
    }

    @Override
    public void method_25419() {
        this.ref.escapeParent();
    }

    @Override
    public void method_25432() {
        for (int i = this.numSlots; i < 27; ++i) {
            class_1799 item = ((class_1707)this.field_2797).method_7629().method_5438(i);
            if (item == null || item.method_7960()) continue;
            MainUtil.get(item, true);
        }
    }

    private /* synthetic */ void lambda$init$0(class_4185 btn) {
        this.navigationClicked = true;
        if (ConfigScreen.isLockSlotsRequired()) {
            btn.field_22763 = false;
            ConfigScreen.setLockSlots(true);
        } else {
            ConfigScreen.setLockSlots(!ConfigScreen.isLockSlots());
        }
        btn.method_25355((class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable("nbteditor.client_chest.slots.unlock", new Object[0]) : TextInst.translatable("nbteditor.client_chest.slots.lock", new Object[0])));
    }
}

