/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.containers;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestHelper;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestPage;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.DynamicItems;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.PageLoadLevel;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ClientChestItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ClientChestDataVersionScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LoadingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientScreenHandler;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.LockedSlotsInfo;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.lang.invoke.LambdaMetafactory;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class ClientChestScreen
extends ClientHandledScreen {
    public static int PAGE = 0;
    public static int prevPageJumpTarget;
    public static int nextPageJumpTarget;
    private DynamicItems dynamicItems;
    private boolean navigationClicked;
    private NamedTextFieldWidget nameField;
    private class_4185 prevPage;
    private class_342 pageField;
    private class_4185 nextPage;
    private class_4185 prevPageJump;
    private class_4185 nextPageJump;

    public static void show() {
        LoadingScreen.show(ClientChestHelper.getPage(PAGE, PageLoadLevel.DYNAMIC_ITEMS), NBTEditorClient.CURSOR_MANAGER::closeRoot, (loaded, optional) -> {
            if (optional.isEmpty()) {
                NBTEditorClient.CURSOR_MANAGER.closeRoot();
                return;
            }
            ClientChestPage pageData = (ClientChestPage)optional.get();
            if (!pageData.isInThisVersion()) {
                NBTEditorClient.CURSOR_MANAGER.closeRoot();
                MainUtil.client.method_1507((class_437)new ClientChestDataVersionScreen(pageData.dataVersion()));
                return;
            }
            class_437 patt0$temp = MainUtil.client.field_1755;
            if (patt0$temp instanceof ClientChestScreen) {
                ClientChestScreen screen = (ClientChestScreen)patt0$temp;
                screen.setPageData(pageData);
                MainUtil.setTextFieldValueSilently(screen.pageField, "" + (PAGE + 1), true);
                screen.updatePageNavigation();
            } else {
                ClientChestScreen screen = new ClientChestScreen();
                screen.setPageData(pageData);
                NBTEditorClient.CURSOR_MANAGER.showBranch((class_465<?>)screen);
                NBTEditorClient.CLIENT_CHEST.warnIfCorrupt();
            }
        });
    }

    private ClientChestScreen() {
        super(new ClientScreenHandler(6), TextInst.translatable("nbteditor.client_chest", new Object[0]));
    }

    private void setPageData(ClientChestPage pageData) {
        class_1799[] items = pageData.getItemsOrThrow();
        for (int i = 0; i < items.length; ++i) {
            ((class_1707)this.field_2797).method_7611(i).method_7673(items[i] == null ? class_1799.field_8037 : items[i].method_7972());
        }
        this.dynamicItems = pageData.dynamicItems();
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.field_2776 += 43;
        this.nameField = new NamedTextFieldWidget(this.field_2776 - 87, this.field_2800, 83, 16){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                boolean output = super.method_25402(mouseX, mouseY, button);
                if (output) {
                    ClientChestScreen.this.navigationClicked = true;
                }
                return output;
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257 && !ClientChestScreen.this.nameField.isValid()) {
                    ClientChestScreen.this.nameField.setValid(true);
                    ClientChestHelper.setNameOfPage(PAGE, ClientChestScreen.this.nameField.method_1882());
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        }.name(TextInst.translatable("nbteditor.client_chest.page_name", new Object[0]));
        this.nameField.method_1880(Integer.MAX_VALUE);
        this.nameField.method_1863(name -> {
            if (NBTEditorClient.CLIENT_CHEST.isNameUsedByOther((String)name, PAGE)) {
                this.nameField.setValid(false);
                return;
            }
            this.nameField.setValid(true);
            ClientChestHelper.setNameOfPage(PAGE, name);
        });
        this.method_37063(this.nameField);
        this.pageField = new class_342(this.field_22793, this.field_2776 - 63, this.field_2800 + 22, 35, 16, TextInst.of("")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                boolean output = super.method_25402(mouseX, mouseY, button);
                if (output) {
                    ClientChestScreen.this.navigationClicked = true;
                }
                return output;
            }
        };
        this.pageField.method_1880(("" + NBTEditorClient.CLIENT_CHEST.getPageCount()).length());
        this.pageField.method_1852("" + (PAGE + 1));
        this.pageField.method_1863(str -> {
            if (str.isEmpty() || str.equals("+") || str.equals("-")) {
                return;
            }
            int intVal = Integer.parseInt(str);
            if (intVal > 0) {
                PAGE = intVal - 1;
                ClientChestScreen.show();
            }
        });
        this.pageField.method_1890(MainUtil.intPredicate(() -> 0, NBTEditorClient.CLIENT_CHEST::getPageCount, true));
        this.method_37063((class_364)this.pageField);
        EditableText prevKeybind = TextInst.translatable("nbteditor.keybind.page.down", new Object[0]);
        EditableText nextKeybind = TextInst.translatable("nbteditor.keybind.page.up", new Object[0]);
        if (ConfigScreen.isInvertedPageKeybinds()) {
            EditableText temp = prevKeybind;
            prevKeybind = nextKeybind;
            nextKeybind = temp;
        }
        this.prevPage = MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 20, 20, 20, TextInst.of("<"), btn -> {
            this.navigationClicked = true;
            this.prevPage();
        }, ConfigScreen.isKeybindsHidden() ? null : new MVTooltip(TextInst.literal("").append(prevKeybind).append(TextInst.translatable("nbteditor.keybind.page.prev", new Object[0]))));
        this.method_37063((class_364)this.prevPage);
        this.nextPage = MVMisc.newButton(this.field_2776 - 24, this.field_2800 + 20, 20, 20, TextInst.of(">"), btn -> {
            this.navigationClicked = true;
            this.nextPage();
        }, ConfigScreen.isKeybindsHidden() ? null : new MVTooltip(TextInst.literal("").append(nextKeybind).append(TextInst.translatable("nbteditor.keybind.page.next", new Object[0]))));
        this.method_37063((class_364)this.nextPage);
        this.prevPageJump = MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 44, 39, 20, TextInst.of("<<"), btn -> {
            this.navigationClicked = true;
            this.prevPageJump();
        }, ConfigScreen.isKeybindsHidden() ? null : new MVTooltip(TextInst.translatable("nbteditor.keybind.page.shift", new Object[0]).append(prevKeybind).append(TextInst.translatable("nbteditor.keybind.page.prev_jump", new Object[0]))));
        this.method_37063((class_364)this.prevPageJump);
        this.nextPageJump = MVMisc.newButton(this.field_2776 - 43, this.field_2800 + 44, 39, 20, TextInst.of(">>"), btn -> {
            this.navigationClicked = true;
            this.nextPageJump();
        }, ConfigScreen.isKeybindsHidden() ? null : new MVTooltip(TextInst.translatable("nbteditor.keybind.page.shift", new Object[0]).append(nextKeybind).append(TextInst.translatable("nbteditor.keybind.page.next_jump", new Object[0]))));
        this.method_37063((class_364)this.nextPageJump);
        ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)(this.field_2776 - 87), (int)(this.field_2800 + 68), (int)83, (int)20, (class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable((String)"nbteditor.client_chest.slots.unlock", (Object[])new Object[0]) : TextInst.translatable((String)"nbteditor.client_chest.slots.lock", (Object[])new Object[0])), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$8(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ClientChestScreen)this)))).field_22763 = !ConfigScreen.isLockSlotsRequired();
        this.method_37063((class_364)MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 92, 83, 20, TextInst.translatable("nbteditor.client_chest.reload_page", new Object[0]), btn -> {
            this.navigationClicked = true;
            LoadingScreen.show(ClientChestHelper.reloadPage(PAGE), this::method_25419, (loaded, pageData) -> ClientChestScreen.show());
        }));
        this.method_37063((class_364)MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 116, 83, 20, TextInst.translatable("nbteditor.client_chest.clear_page", new Object[0]), btn -> {
            this.navigationClicked = true;
            this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                if (value) {
                    ((class_1707)this.field_2797).method_7629().method_5448();
                    this.dynamicItems = new DynamicItems();
                    this.save();
                }
                this.field_22787.method_1507((class_437)this);
            }, TextInst.translatable("nbteditor.client_chest.clear_page.title", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.desc", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.yes", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.no", new Object[0])));
        }));
        this.updatePageNavigation();
    }

    public void updatePageNavigation() {
        this.nameField.method_1852(NBTEditorClient.CLIENT_CHEST.getNameFromPage(PAGE));
        int[] jumps = NBTEditorClient.CLIENT_CHEST.getNearestPOIs(PAGE);
        int maxPage = NBTEditorClient.CLIENT_CHEST.getPageCount() - 1;
        int n = jumps[0] == -1 ? (PAGE == 0 ? -1 : 0) : (prevPageJumpTarget = jumps[0]);
        nextPageJumpTarget = jumps[1] == -1 ? (PAGE == maxPage ? -1 : maxPage) : jumps[1];
        this.prevPage.field_22763 = PAGE != 0;
        this.nextPage.field_22763 = PAGE != maxPage;
        this.prevPageJump.field_22763 = prevPageJumpTarget != -1;
        this.nextPageJump.field_22763 = nextPageJumpTarget != -1;
    }

    @Override
    protected void method_37432() {
        this.nameField.tick();
        this.pageField.tick();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.navigationClicked = false;
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 266 || keyCode == 267) {
            boolean prev;
            boolean bl = prev = keyCode == 267;
            if (ConfigScreen.isInvertedPageKeybinds()) {
                prev = !prev;
            }
            boolean jump = ClientChestScreen.method_25442();
            if (prev) {
                if (jump) {
                    this.prevPageJump();
                } else {
                    this.prevPage();
                }
            } else if (jump) {
                this.nextPageJump();
            } else {
                this.nextPage();
            }
            return true;
        }
        if (this.field_2787 != null) {
            boolean lockedSlot;
            boolean bl = lockedSlot = this.field_2787.field_7871 == ((class_1707)this.field_2797).method_7629() && this.dynamicItems.isSlotLocked(this.field_2787.method_34266());
            if ((!lockedSlot || keyCode == 261) && ClientChestScreen.handleKeybind(keyCode, this.field_2787, ClientChestScreen::show, slot -> new ClientChestItemReference(PAGE, slot.method_34266()))) {
                if (keyCode == 261 && lockedSlot) {
                    this.dynamicItems.remove(this.field_2787.method_34266());
                }
                return true;
            }
        }
        return !this.nameField.method_25404(keyCode, scanCode, modifiers) && !this.nameField.method_20315() && !this.pageField.method_25404(keyCode, scanCode, modifiers) && !this.pageField.method_20315() ? super.method_25404(keyCode, scanCode, modifiers) : true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.navigationClicked = false;
        MVMisc.setKeyboardRepeatEvents(this.nameField.method_25402(mouseX, mouseY, button) || this.pageField.method_25402(mouseX, mouseY, button));
        super.method_25402(mouseX, mouseY, button);
        return true;
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (this.navigationClicked) {
            return;
        }
        super.method_2383(slot, slotId, button, actionType);
    }

    @Override
    public boolean allowEnchantmentCombine() {
        return true;
    }

    @Override
    public LockedSlotsInfo getLockedSlotsInfo() {
        LockedSlotsInfo info = (ConfigScreen.isLockSlots() ? LockedSlotsInfo.ITEMS_LOCKED : LockedSlotsInfo.NONE).copy();
        for (int slot : this.dynamicItems.getLockedSlots()) {
            info.addContainerSlot(slot);
        }
        return info;
    }

    @Override
    public void onChange() {
        this.save();
    }

    private void save() {
        class_1799[] items = new class_1799[54];
        for (int i = 0; i < ((class_1707)this.field_2797).method_7629().method_5439(); ++i) {
            items[i] = ((class_1707)this.field_2797).method_7629().method_5438(i).method_7972();
        }
        ClientChestHelper.setPage(PAGE, items, this.dynamicItems);
    }

    @Override
    protected class_2561 getRenderedTitle() {
        EditableText title = TextInst.copy(this.field_22785).append(" (" + (PAGE + 1) + ")");
        return NBTEditorClient.CLIENT_CHEST.isProcessingPage(PAGE) ? title.append("*") : title;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    @Override
    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }

    private void prevPage() {
        if (!this.prevPage.field_22763) {
            return;
        }
        --PAGE;
        ClientChestScreen.show();
    }

    private void nextPage() {
        if (!this.nextPage.field_22763) {
            return;
        }
        ++PAGE;
        ClientChestScreen.show();
    }

    private void prevPageJump() {
        if (!this.prevPageJump.field_22763) {
            return;
        }
        PAGE = prevPageJumpTarget;
        ClientChestScreen.show();
    }

    private void nextPageJump() {
        if (!this.nextPageJump.field_22763) {
            return;
        }
        PAGE = nextPageJumpTarget;
        ClientChestScreen.show();
    }

    private /* synthetic */ void lambda$init$8(class_4185 btn) {
        this.navigationClicked = true;
        if (ConfigScreen.isLockSlotsRequired()) {
            btn.field_22763 = false;
            ConfigScreen.setLockSlots(true);
        } else {
            ConfigScreen.setLockSlots(!ConfigScreen.isLockSlots());
        }
        btn.method_25355((class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable("nbteditor.client_chest.slots.unlock", new Object[0]) : TextInst.translatable("nbteditor.client_chest.slots.lock", new Object[0])));
    }
}

