/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueListener;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_4587;

public class ConfigValueSlider<T extends Number>
extends class_357
implements ConfigValue<T, ConfigValueSlider<T>> {
    private T actualValue;
    private final T defaultValue;
    private final T min;
    private final T max;
    private final T step;
    private final Function<T, class_2561> msg;
    private final Function<Double, T> caster;
    private final List<ConfigValueListener<ConfigValueSlider<T>>> onChanged;
    private boolean clicked = false;
    private double mouseClickX = -1.0;
    private double mouseClickY = -1.0;

    public static ConfigValueSlider<Integer> forInt(int width, int value, int defaultValue, int min, int max, int step, Function<Integer, class_2561> msg) {
        return new ConfigValueSlider<Integer>(width, value, defaultValue, min, max, step, msg, Double::intValue, null);
    }

    public static ConfigValueSlider<Double> forDouble(int width, double value, double defaultValue, double min, double max, double step, Function<Double, class_2561> msg) {
        return new ConfigValueSlider<Double>(width, value, defaultValue, min, max, step, msg, Double::doubleValue, null);
    }

    private ConfigValueSlider(int width, T value, T defaultValue, T min, T max, T step, Function<T, class_2561> msg, Function<Double, T> caster, List<ConfigValueListener<ConfigValueSlider<T>>> onChanged) {
        super(0, 0, width, 20, msg.apply(value), (((Number)value).doubleValue() - ((Number)min).doubleValue()) / (((Number)max).doubleValue() - ((Number)min).doubleValue()));
        this.actualValue = value;
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.step = step;
        this.msg = msg;
        this.caster = caster;
        this.onChanged = new ArrayList<ConfigValueListener<ConfigValueSlider<T>>>();
        if (onChanged != null) {
            this.onChanged.addAll(onChanged);
        }
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean output = super.method_25402(mouseX, mouseY, button);
        if (output) {
            this.mouseClickX = mouseX;
            this.mouseClickY = mouseY;
        }
        this.clicked = output;
        return this.clicked;
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.clicked && MainUtil.equals(mouseX, this.mouseClickX + deltaX) && MainUtil.equals(mouseY, this.mouseClickY + deltaY)) {
            this.mouseClickX += deltaX;
            this.mouseClickY += deltaY;
            super.method_25349(mouseX, mouseY, deltaX, deltaY);
        }
    }

    protected void method_25346() {
        this.method_25355(this.msg.apply(this.actualValue));
    }

    protected void method_25344() {
        this.actualValue = (Number)this.caster.apply((double)((int)(this.field_22753 * (((Number)this.max).doubleValue() - ((Number)this.min).doubleValue()) / ((Number)this.step).doubleValue())) * ((Number)this.step).doubleValue() + ((Number)this.min).doubleValue());
        this.onChanged.forEach(listener -> listener.onValueChanged(this));
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(T value) {
        this.field_22753 = (((Number)value).doubleValue() - ((Number)this.min).doubleValue()) / (((Number)this.max).doubleValue() - ((Number)this.min).doubleValue());
        this.actualValue = value;
        this.onChanged.forEach(listener -> listener.onValueChanged(this));
        this.method_25346();
    }

    @Override
    public T getValue() {
        return this.actualValue;
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public ConfigValueSlider<T> addValueListener(ConfigValueListener<ConfigValueSlider<T>> listener) {
        this.onChanged.add(listener);
        return this;
    }

    @Override
    public int getSpacingWidth() {
        return this.field_22758;
    }

    @Override
    public int getSpacingHeight() {
        return this.field_22759;
    }

    @Override
    public ConfigValueSlider<T> clone(boolean defaults) {
        return new ConfigValueSlider<T>(this.field_22758, defaults ? this.defaultValue : this.actualValue, this.defaultValue, this.min, this.max, this.step, this.msg, this.caster, this.onChanged);
    }
}

