/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigGroupingVertical;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPathNamed;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueListener;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InputOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.StringInput;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ConfigList
extends ConfigGroupingVertical<Integer, ConfigList> {
    private final boolean indexed;

    public ConfigList(class_2561 name, boolean indexed, ConfigPath defaultEntry) {
        super(name, (class_2561 name2) -> new ConfigList(name2, indexed, defaultEntry));
        this.indexed = indexed;
        super.setSorter((a, b) -> a - b);
        super.setConfigurable(-1, new ConfigButton(20, TextInst.of("+"), btn -> {
            this.addConfigurable((ConfigPath)defaultEntry.clone(true));
            this.onChanged.forEach(listener -> listener.onValueChanged(null));
        }));
    }

    public ConfigList(boolean indexed, ConfigPath defaultEntry) {
        this(null, indexed, defaultEntry);
    }

    public ConfigList(ConfigPath defaultEntry) {
        this(null, false, defaultEntry);
    }

    @Override
    public ConfigList setConfigurable(Integer key, ConfigPath path) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (key < 0 || key >= this.paths.size()) {
            throw new ArrayIndexOutOfBoundsException(key);
        }
        super.setConfigurable(key, new ConfigListEntry(this, path, this.paths.size() - 1, this.indexed));
        path.setParent(this);
        return this;
    }

    @Override
    public ConfigPath getConfigurable(Integer key) {
        ConfigPath output = super.getConfigurable(key);
        if (output == null) {
            return null;
        }
        return ((ConfigListEntry)output).value;
    }

    @Override
    public Map<Integer, ConfigPath> getConfigurables() {
        return this.paths.entrySet().stream().filter(entry -> (Integer)entry.getKey() >= 0).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConfigListEntry)entry.getValue()).value, (a, b) -> a, LinkedHashMap::new));
    }

    @Override
    public ConfigList sort(Comparator<Integer> sorter) {
        int i;
        TreeMap<Integer, ConfigPath> indexes = new TreeMap<Integer, ConfigPath>(sorter);
        for (i = 0; i < this.paths.size() - 1; ++i) {
            indexes.put(i, (ConfigPath)this.paths.get(i));
        }
        i = 0;
        for (ConfigPath path : indexes.values()) {
            ((ConfigListEntry)path).setIndex(i);
            this.paths.put(i, path);
            ++i;
        }
        return this;
    }

    @Override
    public ConfigList setSorter(Comparator<Integer> sorter) {
        throw new UnsupportedOperationException("Lists are always sorted by their index! Use sort instead.");
    }

    public ConfigList addConfigurable(ConfigPath path) {
        return this.setConfigurable(this.paths.size() - 1, path);
    }

    private void setListEntry(int key, ConfigListEntry entry) {
        this.paths.put(key, entry);
    }

    private ConfigListEntry getListEntry(int key) {
        return (ConfigListEntry)this.paths.get(key);
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int yOffset;
        super.render(matrices, mouseX, mouseY, delta);
        if (this.isValueValid()) {
            yOffset = this.getNameHeight();
            for (ConfigPath path : this.paths.values()) {
                int height = path.getSpacingHeight();
                if (path instanceof ConfigListEntry) {
                    MVDrawableHelper.fill(matrices, 0, yOffset, 8, yOffset + height, -16777216);
                    MVDrawableHelper.fill(matrices, 0, yOffset + 8, 8, yOffset + height - 8, -14321783);
                    matrices.method_22903();
                    matrices.method_22904(-4.0, (double)(-(yOffset + height / 2)), 0.0);
                    matrices.method_22905(2.0f, 2.0f, 1.0f);
                    matrices.method_22904(3.5, (double)(yOffset + height / 2), 0.0);
                    class_327 class_3272 = MainUtil.client.field_1772;
                    class_2561 class_25612 = TextInst.of("\u22ee");
                    Objects.requireNonNull(MainUtil.client.field_1772);
                    MVDrawableHelper.drawTextWithShadow(matrices, class_3272, class_25612, 0, -9 / 2, -1);
                    matrices.method_22909();
                }
                yOffset += height + 8;
            }
        }
        yOffset = this.getNameHeight();
        for (ConfigPath path : this.paths.values()) {
            if (path instanceof ConfigListEntry) {
                ConfigListEntry entry = (ConfigListEntry)path;
                matrices.method_22903();
                matrices.method_22904(16.0, (double)yOffset, 0.0);
                entry.renderContextMenu(matrices, mouseX - 16, mouseY - yOffset, delta);
                matrices.method_22909();
            }
            yOffset += path.getSpacingHeight() + 8;
        }
    }

    private static class ConfigListEntry
    implements ConfigPath {
        private static final int LIST_CONTEXT_MENU_HEIGHT;
        private final ConfigList parent;
        private final ConfigPath value;
        private final boolean named;
        private final boolean indexed;
        private int index;
        private class_2561 indexText;
        private int indexTextOffset;
        private boolean contextMenuOpen;
        private int contextMenuX;
        private int contextMenuY;

        public ConfigListEntry(ConfigList parent, ConfigPath value, int index, boolean indexed) {
            this.parent = parent;
            this.value = value;
            this.indexed = indexed;
            this.named = value instanceof ConfigPathNamed;
            this.setIndex(index);
            if (this.named) {
                ((ConfigPathNamed)value).setNamePrefix(this.indexText);
            }
        }

        public void setIndex(int index) {
            this.index = index;
            if (this.indexed) {
                this.indexText = TextInst.literal("(#" + (index + 1) + ") ");
                int n = this.indexTextOffset = this.named ? 0 : MainUtil.client.field_1772.method_27525((class_5348)this.indexText);
                if (this.named) {
                    ((ConfigPathNamed)this.value).setNamePrefix(this.indexText);
                }
            } else {
                this.indexText = TextInst.of("");
                this.indexTextOffset = 0;
            }
        }

        public void duplicate(int numCopies) {
            for (int dupe = 0; dupe < numCopies; ++dupe) {
                for (int i = this.parent.paths.size() - 2; i > this.index; --i) {
                    ConfigListEntry entry = this.parent.getListEntry(i);
                    entry.setIndex(i + 1);
                    this.parent.setListEntry(i + 1, entry);
                }
                ConfigListEntry clone = this.clone(false);
                clone.setIndex(this.index + 1);
                this.parent.setListEntry(this.index + 1, clone);
            }
            this.parent.onChanged.forEach(listener -> listener.onValueChanged(null));
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.named) {
                this.value.render(matrices, mouseX, mouseY, delta);
            } else {
                class_327 class_3272 = MainUtil.client.field_1772;
                int n = this.getSpacingHeight();
                Objects.requireNonNull(MainUtil.client.field_1772);
                MVDrawableHelper.drawTextWithShadow(matrices, class_3272, this.indexText, 0, (n - 9) / 2, -1);
                matrices.method_22903();
                matrices.method_22904((double)this.indexTextOffset, 0.0, 0.0);
                this.value.render(matrices, mouseX - this.indexTextOffset, mouseY, delta);
                matrices.method_22909();
            }
        }

        public void renderContextMenu(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (!this.contextMenuOpen) {
                return;
            }
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 1.0);
            MVDrawableHelper.fill(matrices, this.contextMenuX - 1, this.contextMenuY - 1, this.contextMenuX + 51, this.contextMenuY + LIST_CONTEXT_MENU_HEIGHT + 1, -1);
            MVDrawableHelper.fill(matrices, this.contextMenuX, this.contextMenuY, this.contextMenuX + 50, this.contextMenuY + LIST_CONTEXT_MENU_HEIGHT, -16777216);
            boolean xHover = mouseX > this.contextMenuX && mouseX < this.contextMenuX + 50;
            int y = this.contextMenuY;
            for (ListContextMenuAction action : ListContextMenuAction.values()) {
                int color = -1;
                if (xHover && mouseY >= y) {
                    Objects.requireNonNull(MainUtil.client.field_1772);
                    if (mouseY <= y + 9) {
                        color = -14321783;
                        if (action.tooltip != null && !ConfigScreen.isKeybindsHidden()) {
                            new MVTooltip(action.tooltip).render(matrices, mouseX, mouseY);
                        }
                    }
                }
                class_2561 msg = action.msg;
                if (action == ListContextMenuAction.REMOVE) {
                    msg = TextInst.copy(msg).formatted(color == -1 ? class_124.field_1061 : class_124.field_1065);
                }
                MVDrawableHelper.drawCenteredTextWithShadow(matrices, MainUtil.client.field_1772, msg, this.contextMenuX + 25, y + 2, color);
                Objects.requireNonNull(MainUtil.client.field_1772);
                y += 9 + 2;
            }
            matrices.method_22909();
        }

        @Override
        public boolean isValueValid() {
            return this.value.isValueValid();
        }

        @Override
        public ConfigListEntry addValueListener(ConfigValueListener<ConfigValue<?, ?>> listener) {
            this.value.addValueListener(listener);
            return this;
        }

        @Override
        public int getSpacingWidth() {
            return this.indexTextOffset + this.value.getSpacingWidth();
        }

        @Override
        public int getSpacingHeight() {
            return Math.max(20, this.value.getSpacingHeight());
        }

        @Override
        public int getRenderWidth() {
            return this.indexTextOffset + this.value.getRenderWidth();
        }

        @Override
        public int getRenderHeight() {
            return Math.max(this.getSpacingHeight(), this.value.getRenderHeight());
        }

        @Override
        public ConfigListEntry clone(boolean defaults) {
            return new ConfigListEntry(this.parent, (ConfigPath)this.value.clone(defaults), this.index, this.indexed);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.contextMenuOpen) {
                if (mouseX >= (double)this.contextMenuX && mouseX <= (double)(this.contextMenuX + 50) && mouseY >= (double)this.contextMenuY && mouseY <= (double)(this.contextMenuY + LIST_CONTEXT_MENU_HEIGHT)) {
                    if (mouseX > (double)this.contextMenuX && mouseX < (double)(this.contextMenuX + 50)) {
                        int y = this.contextMenuY;
                        for (ListContextMenuAction action : ListContextMenuAction.values()) {
                            if (mouseY >= (double)y) {
                                Objects.requireNonNull(MainUtil.client.field_1772);
                                if (mouseY <= (double)(y + 9)) {
                                    switch (action.ordinal()) {
                                        case 0: {
                                            InputOverlay.show(TextInst.translatable("nbteditor.configurable.list.move", new Object[0]), StringInput.builder().withDefault("" + (this.index + 1)).withPlaceholder(TextInst.translatable("nbteditor.configurable.list.move.index", new Object[0])).withValidator(MainUtil.intPredicate(() -> 1, () -> this.parent.paths.size() - 1, false)).build(), str -> {
                                                int target = Integer.parseInt(str) - 1;
                                                if (target == this.index) {
                                                    return;
                                                }
                                                int dir = this.index < target ? 1 : -1;
                                                int i = this.index;
                                                while (dir == 1 ? i < target : i > target) {
                                                    ConfigListEntry entry = this.parent.getListEntry(i + dir);
                                                    entry.setIndex(i);
                                                    this.parent.setListEntry(i, entry);
                                                    i += dir;
                                                }
                                                this.setIndex(target);
                                                this.parent.setListEntry(target, this);
                                                this.parent.onChanged.forEach(listener -> listener.onValueChanged(null));
                                            });
                                            break;
                                        }
                                        case 1: {
                                            if (class_437.method_25442()) {
                                                InputOverlay.show(TextInst.translatable("nbteditor.configurable.list.duplicate", new Object[0]), StringInput.builder().withPlaceholder(TextInst.translatable("nbteditor.configurable.list.duplicate.amount", new Object[0])).withValidator(MainUtil.intPredicate(1, Integer.MAX_VALUE, false)).build(), numCopies -> this.duplicate(Integer.parseInt(numCopies)));
                                                break;
                                            }
                                            this.duplicate(1);
                                            break;
                                        }
                                        case 2: {
                                            for (int i = this.index; i < this.parent.paths.size() - 2; ++i) {
                                                ConfigListEntry entry = this.parent.getListEntry(i + 1);
                                                entry.setIndex(i);
                                                this.parent.setListEntry(i, entry);
                                            }
                                            this.parent.paths.remove(this.parent.paths.size() - 2);
                                            this.parent.onChanged.forEach(listener -> listener.onValueChanged(null));
                                        }
                                    }
                                    this.contextMenuOpen = false;
                                    break;
                                }
                            }
                            Objects.requireNonNull(MainUtil.client.field_1772);
                            y += 9 + 2;
                        }
                    }
                    return true;
                }
                this.contextMenuOpen = false;
            }
            int height = this.getSpacingHeight();
            if (mouseX >= -16.0 && mouseX <= -8.0 && mouseY >= 0.0 && mouseY <= (double)height) {
                if (button == 0) {
                    if (mouseY <= 8.0) {
                        if (this.index > 0) {
                            ConfigListEntry above = this.parent.getListEntry(this.index - 1);
                            above.setIndex(this.index);
                            this.parent.setListEntry(this.index, above);
                            this.setIndex(this.index - 1);
                            this.parent.setListEntry(this.index, this);
                            this.parent.onChanged.forEach(listener -> listener.onValueChanged(null));
                        }
                        return true;
                    }
                    if (mouseY >= (double)(height - 8)) {
                        if (this.index < this.parent.paths.size() - 2) {
                            ConfigListEntry below = this.parent.getListEntry(this.index + 1);
                            below.setIndex(this.index);
                            this.parent.setListEntry(this.index, below);
                            this.setIndex(this.index + 1);
                            this.parent.setListEntry(this.index, this);
                            this.parent.onChanged.forEach(listener -> listener.onValueChanged(null));
                        }
                        return true;
                    }
                    this.contextMenuOpen = true;
                    this.contextMenuX = (int)mouseX;
                    this.contextMenuY = (int)mouseY;
                    return true;
                }
                if (button == 1) {
                    this.contextMenuOpen = true;
                    this.contextMenuX = (int)mouseX;
                    this.contextMenuY = (int)mouseY;
                    return true;
                }
            }
            return this.value.method_25402(mouseX - (double)this.indexTextOffset, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return this.value.method_25406(mouseX - (double)this.indexTextOffset, mouseY, button);
        }

        public void method_16014(double mouseX, double mouseY) {
            this.value.method_16014(mouseX - (double)this.indexTextOffset, mouseY);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.value.method_25403(mouseX - (double)this.indexTextOffset, mouseY, button, deltaX, deltaY);
        }

        @Override
        public boolean method_25401(double mouseX, double mouseY, double xAmount, double yAmount) {
            return this.value.method_25401(mouseX - (double)this.indexTextOffset, mouseY, xAmount, yAmount);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            return this.value.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_16803(int keyCode, int scanCode, int modifiers) {
            return this.value.method_16803(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            return this.value.method_25400(chr, modifiers);
        }

        @Override
        public void tick() {
            this.value.tick();
        }

        static {
            Objects.requireNonNull(MainUtil.client.field_1772);
            LIST_CONTEXT_MENU_HEIGHT = (9 + 2) * 3 + 2;
        }

        public static enum ListContextMenuAction {
            MOVE("nbteditor.configurable.list.move"),
            DUPLICATE("nbteditor.configurable.list.duplicate", "nbteditor.configurable.list.duplicate.any_amount"),
            REMOVE("nbteditor.configurable.list.remove");

            private final class_2561 msg;
            private final class_2561 tooltip;

            private ListContextMenuAction(String msg, String tooltip) {
                this.msg = TextInst.translatable(msg, new Object[0]);
                this.tooltip = tooltip == null ? null : TextInst.translatable(tooltip, new Object[0]);
            }

            private ListContextMenuAction(String msg) {
                this(msg, null);
            }
        }
    }
}

