/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.screens.Tickable;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueListener;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ConfigItem<V extends ConfigValue<?, V>>
implements ConfigPath {
    private final class_2561 name;
    private final V value;
    private final int valueOffsetX;
    private final int valueOffsetY;
    private final List<ConfigValueListener<ConfigValue<?, ?>>> onChanged;
    private MVTooltip tooltip;

    public ConfigItem(class_2561 name, V value) {
        this.name = name;
        this.value = value;
        this.valueOffsetX = MainUtil.client.field_1772.method_27525((class_5348)name) + 8;
        this.valueOffsetY = (this.getSpacingHeight() - value.getSpacingHeight()) / 2;
        this.onChanged = new ArrayList();
        value.addValueListener((V source) -> this.onChanged.forEach(listener -> listener.onValueChanged(source)));
        value.setParent(this);
    }

    private ConfigItem(class_2561 name, V value, List<ConfigValueListener<ConfigValue<?, ?>>> onChanged) {
        this(name, value);
        this.onChanged.addAll(onChanged);
    }

    public V getValue() {
        return this.value;
    }

    public ConfigItem<V> setTooltip(MVTooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ConfigItem<V> setTooltip(String ... keys) {
        this.setTooltip(new MVTooltip(keys));
        return this;
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_327 class_3272 = MainUtil.client.field_1772;
        int n = this.getSpacingHeight();
        Objects.requireNonNull(MainUtil.client.field_1772);
        MVDrawableHelper.drawTextWithShadow(matrices, class_3272, this.name, 0, (n - 9) / 2, -1);
        matrices.method_22903();
        matrices.method_22904((double)this.valueOffsetX, (double)this.valueOffsetY, 0.0);
        this.value.render(matrices, mouseX - this.valueOffsetX, mouseY - this.valueOffsetY, delta);
        matrices.method_22909();
        if (this.tooltip != null && mouseX >= 0 && mouseX <= this.valueOffsetX && this.method_25405(mouseX, mouseY)) {
            this.tooltip.render(matrices, mouseX, mouseY);
        }
    }

    @Override
    public boolean isValueValid() {
        return this.value.isValueValid();
    }

    @Override
    public ConfigItem<V> addValueListener(ConfigValueListener<ConfigValue<?, ?>> listener) {
        this.onChanged.add(listener);
        return this;
    }

    @Override
    public int getSpacingWidth() {
        return this.valueOffsetX + this.value.getSpacingWidth();
    }

    @Override
    public int getSpacingHeight() {
        return Math.max(20, this.value.getSpacingHeight());
    }

    @Override
    public int getRenderWidth() {
        return this.valueOffsetX + this.value.getRenderWidth();
    }

    @Override
    public int getRenderHeight() {
        return Math.max(this.getSpacingHeight(), this.value.getRenderHeight());
    }

    @Override
    public ConfigItem<V> clone(boolean defaults) {
        ConfigItem<ConfigValue> output = new ConfigItem<ConfigValue>(this.name, (ConfigValue)this.value.clone(defaults), this.onChanged);
        output.tooltip = this.tooltip;
        return output;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.value.method_25402(mouseX - (double)this.valueOffsetX, mouseY - (double)this.valueOffsetY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.value.method_25406(mouseX - (double)this.valueOffsetX, mouseY - (double)this.valueOffsetY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.value.method_16014(mouseX - (double)this.valueOffsetX, mouseY - (double)this.valueOffsetY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.value.method_25403(mouseX - (double)this.valueOffsetX, mouseY - (double)this.valueOffsetY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double xAmount, double yAmount) {
        return this.value.method_25401(mouseX - (double)this.valueOffsetX, mouseY - (double)this.valueOffsetY, xAmount, yAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.value.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.value.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.value.method_25400(chr, modifiers);
    }

    @Override
    public void tick() {
        V v = this.value;
        if (v instanceof Tickable) {
            Tickable tickable = (Tickable)v;
            tickable.tick();
        }
    }
}

