/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigGrouping;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.Configurable;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public abstract class ConfigGroupingHorizontal<K, T extends ConfigGroupingHorizontal<K, T>>
extends ConfigGrouping<K, T> {
    protected ConfigGroupingHorizontal(class_2561 name, ConfigGrouping.Constructor<K, T> cloneImpl) {
        super(name, cloneImpl);
    }

    protected int getNameWidth() {
        return this.name == null ? 0 : MainUtil.client.field_1772.method_27525((class_5348)this.name) + 8;
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int xOffset = 0;
        class_2561 fullName = this.getFullName();
        if (fullName != null) {
            MVDrawableHelper.drawTextWithShadow(matrices, MainUtil.client.field_1772, fullName, 16, 0, -1);
            xOffset += this.getNameWidth();
        }
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            matrices.method_22903();
            matrices.method_22904((double)xOffset, 0.0, 0.0);
            path.render(matrices, mouseX - xOffset, mouseY, delta);
            matrices.method_22909();
            xOffset += path.getSpacingWidth() + 8;
        }
    }

    @Override
    public int getSpacingWidth() {
        return this.getNameWidth() + this.paths.values().stream().mapToInt(Configurable::getSpacingWidth).reduce((a, b) -> a + 8 + b).orElse(0);
    }

    @Override
    public int getSpacingHeight() {
        int output = 0;
        for (ConfigPath path : this.paths.values()) {
            int height = path.getSpacingHeight();
            if (height <= output) continue;
            output = height;
        }
        return output;
    }

    @Override
    public int getRenderWidth() {
        int output;
        int xOffset = output = this.getNameWidth();
        for (ConfigPath path : this.paths.values()) {
            int rightX = xOffset + path.getRenderWidth();
            if (rightX > output) {
                output = rightX;
            }
            xOffset += path.getSpacingWidth() + 8;
        }
        return output;
    }

    @Override
    public int getRenderHeight() {
        int output = 0;
        for (ConfigPath path : this.paths.values()) {
            int height = path.getRenderHeight();
            if (height <= output) continue;
            output = height;
        }
        return output;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        int xOffset = this.getNameWidth();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25402(mouseX - (double)xOffset, mouseY, button)) {
                return true;
            }
            xOffset += path.getSpacingWidth() + 8;
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        int xOffset = this.getNameWidth();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25406(mouseX - (double)xOffset, mouseY, button)) {
                return true;
            }
            xOffset += path.getSpacingWidth() + 8;
        }
        return false;
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        int xOffset = this.getNameWidth();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            path.method_16014(mouseX - (double)xOffset, mouseY);
            xOffset += path.getSpacingWidth() + 8;
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int xOffset = this.getNameWidth();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25403(mouseX - (double)xOffset, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            xOffset += path.getSpacingWidth() + 8;
        }
        return false;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double xAmount, double yAmount) {
        int xOffset = this.getNameWidth();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25401(mouseX - (double)xOffset, mouseY, xAmount, yAmount)) {
                return true;
            }
            xOffset += path.getSpacingWidth() + 8;
        }
        return false;
    }
}

