/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.integrations.NBTAutocompleteIntegration;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LocalEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.NBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtfolder.StringNBTFolder;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.TextAreaScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.InputOverlay;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.List2D;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.StringInput;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.SuggestingTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.NbtFormatter;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_151;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class NBTEditorScreen<L extends LocalNBT>
extends LocalEditorScreen<L> {
    private static String copiedKey;
    private static class_2520 copiedValue;
    private final NBTFolder<class_2487> baseFolder;
    private NamedTextFieldWidget type;
    private NamedTextFieldWidget count;
    private NamedTextFieldWidget path;
    private SuggestingTextFieldWidget value;
    private List2D editor;
    private Map<String, Integer> scrollPerFolder = new HashMap<String, Integer>();
    private List<String> realPath = new ArrayList<String>(){

        @Override
        public String toString() {
            return String.join((CharSequence)"/", this);
        }
    };
    private NBTFolder<?> currentFolder;
    private NBTValue upValue;
    private NBTValue selectedValue;
    private boolean json;

    public NBTEditorScreen(NBTReference<L> ref) {
        super(TextInst.of("NBT Editor"), ItemReference.toItemPartsRef(ref));
        this.baseFolder = NBTFolder.get(class_2487.class, this.localNBT::getOrCreateNBT, this.localNBT::setNBT);
    }

    @Override
    protected void initEditor() {
        if (this.realPath.isEmpty() && this.baseFolder.hasEmptyKey()) {
            this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                if (value) {
                    this.baseFolder.removeKey("");
                    this.save();
                    this.field_22787.method_1507((class_437)this);
                } else {
                    this.method_25419();
                }
            }, TextInst.translatable("nbteditor.nbt.empty_key.title", new Object[0]), TextInst.translatable("nbteditor.nbt.empty_key.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.empty_key.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.empty_key.no", new Object[0])).setParent(null));
            return;
        }
        MVMisc.setKeyboardRepeatEvents(true);
        this.name.method_1863(str -> {
            if (str.equals(this.localNBT.getDefaultName())) {
                this.localNBT.setName(null);
            } else {
                this.localNBT.setName(TextInst.of(str));
            }
            this.genEditor();
        });
        this.method_37063((class_364)MVMisc.newButton(16, this.field_22790 - 32, 20, 20, TextInst.translatable("nbteditor.nbt.add", new Object[0]), btn -> this.add()));
        this.method_37063((class_364)MVMisc.newButton(40, this.field_22790 - 32, 20, 20, TextInst.translatable("nbteditor.nbt.remove", new Object[0]), btn -> this.remove()));
        this.method_37063((class_364)MVMisc.newButton(64, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.copy", new Object[0]), btn -> this.copy()));
        this.method_37063((class_364)MVMisc.newButton(116, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.cut", new Object[0]), btn -> this.cut()));
        this.method_37063((class_364)MVMisc.newButton(168, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.paste", new Object[0]), btn -> this.paste()));
        this.method_37063((class_364)MVMisc.newButton(220, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.rename", new Object[0]), btn -> this.rename()));
        Set<class_2960> allTypes = this.localNBT.getIdOptions();
        this.type = new NamedTextFieldWidget(96, 56, 208, 16).name(TextInst.translatable("nbteditor.nbt.identifier", new Object[0]));
        this.type.method_1880(Integer.MAX_VALUE);
        this.type.method_1852(this.localNBT.getId().toString());
        if (allTypes == null) {
            this.type.method_1888(false);
        } else {
            this.type.method_1863(str -> {
                LocalItem item;
                class_2960 id;
                try {
                    id = IdentifierInst.of(str);
                }
                catch (class_151 e) {
                    return;
                }
                if (!allTypes.contains(id)) {
                    return;
                }
                if (!ConfigScreen.isAirEditable() && this.localNBT.isEmpty(id)) {
                    return;
                }
                this.localNBT.setId(id);
                LocalNBT patt0$temp = this.localNBT;
                if (patt0$temp instanceof LocalItem && (item = (LocalItem)patt0$temp).getCount() == 0) {
                    item.setCount(this.count.method_1882().isEmpty() || this.count.method_1882().equals("+") ? 1 : Integer.parseInt(this.count.method_1882()));
                }
                this.genEditor();
            });
        }
        this.method_37063(this.type);
        this.count = new NamedTextFieldWidget(16, 56, 72, 16).name(TextInst.translatable("nbteditor.nbt.count", new Object[0]));
        this.count.method_1880(Integer.MAX_VALUE);
        LocalNBT localNBT = this.localNBT;
        if (localNBT instanceof LocalItem) {
            LocalItem item = (LocalItem)localNBT;
            this.count.method_1852("" + (ConfigScreen.isAirEditable() ? Math.max(1, item.getCount()) : item.getCount()));
            this.count.method_1863(str -> {
                if (str.isEmpty() || str.equals("+")) {
                    return;
                }
                item.setCount(Integer.parseInt(str));
                this.checkSave();
            });
            this.count.method_1890(MainUtil.intPredicate(1, Integer.MAX_VALUE, true));
        } else {
            this.count.method_1852("1");
            this.count.method_1888(false);
        }
        this.method_37063(this.count);
        this.path = new NamedTextFieldWidget(16, 80, 288, 16).name(TextInst.translatable("nbteditor.nbt.path", new Object[0]));
        this.path.method_1880(Integer.MAX_VALUE);
        this.path.method_1852(this.realPath.toString());
        this.path.method_1863(str -> {
            String[] parts = str.split("/");
            NBTFolder<Object> folder = this.baseFolder;
            for (String part : parts) {
                if ((folder = folder.getSubFolder(part)) != null) continue;
                return;
            }
            this.realPath.clear();
            this.realPath.addAll(Arrays.asList(parts));
            this.genEditor();
        });
        this.method_37063(this.path);
        this.value = new SuggestingTextFieldWidget(this, 16, 104, 288, 16).name(TextInst.translatable("nbteditor.nbt.value", new Object[0]));
        this.value.method_1854((str, index) -> TextUtil.substring(NbtFormatter.FORMATTER.formatSafely(this.value.method_1882()).text(), index, index + str.length()).method_30937());
        this.value.method_1880(Integer.MAX_VALUE);
        this.value.method_1852("");
        this.value.method_1888(false);
        this.value.method_1863(str -> {
            if (this.selectedValue != null) {
                this.selectedValue.setUnsafe(!NbtFormatter.FORMATTER.formatSafely(this.value.method_1882()).isSuccess());
                if (this.selectedValue.isUnsafe()) {
                    return;
                }
                this.selectedValue.valueChanged((String)str, nbt -> {
                    this.currentFolder.setValue(this.selectedValue.getKey(), (class_2520)nbt);
                    this.updateName();
                });
                if (this.realPath.isEmpty()) {
                    for (List2D.List2DValue element : this.editor.getElements()) {
                        if (!(element instanceof NBTValue)) continue;
                        NBTValue value = (NBTValue)element;
                        value.updateInvalidComponent(this.localNBT, null);
                    }
                } else {
                    this.upValue.updateInvalidComponent(this.localNBT, this.realPath.get(0));
                }
                this.checkSave();
            }
        });
        this.value.suggest((str, cursor) -> NBTAutocompleteIntegration.INSTANCE.filter(ac -> this.selectedValue != null).map(ac -> ac.getSuggestions(this.localNBT, this.realPath, this.selectedValue.getKey(), (String)str, (int)cursor)).orElseGet(() -> new SuggestionsBuilder("", 0).buildFuture()));
        this.method_37063(this.value);
        this.method_37063((class_364)MVMisc.newButton(314, 102, 75, 20, TextInst.translatable("nbteditor.nbt.value_expand", new Object[0]), btn -> {
            if (this.selectedValue == null) {
                this.field_22787.method_1507((class_437)new TextAreaScreen(this, this.currentFolder.getNBT().toString(), NbtFormatter.FORMATTER, false, str -> {
                    try {
                        class_2520 nbt = MixinLink.parseSpecialElement(new StringReader(str));
                        if (this.realPath.isEmpty()) {
                            if (!(nbt instanceof class_2487)) {
                                class_2487 temp = new class_2487();
                                temp.method_10566("value", nbt);
                                nbt = temp;
                            }
                            this.baseFolder.setNBT((class_2487)nbt);
                        } else {
                            String lastPathPart = this.realPath.remove(this.realPath.size() - 1);
                            this.genEditor();
                            this.currentFolder.setValue(lastPathPart, nbt);
                            this.realPath.add(lastPathPart);
                        }
                    }
                    catch (CommandSyntaxException e) {
                        NBTEditor.LOGGER.error("Error parsing nbt from Expand", (Throwable)e);
                    }
                }).suggest((str, cursor) -> NBTAutocompleteIntegration.INSTANCE.map(ac -> ac.getSuggestions(this.localNBT, this.realPath, null, (String)str, (int)cursor)).orElseGet(() -> new SuggestionsBuilder("", 0).buildFuture())));
            } else {
                this.field_22787.method_1507((class_437)new TextAreaScreen(this, this.selectedValue.getValueText(this.json), NbtFormatter.FORMATTER, false, str -> this.value.method_1852((String)str)).suggest((str, cursor) -> NBTAutocompleteIntegration.INSTANCE.map(ac -> ac.getSuggestions(this.localNBT, this.realPath, this.selectedValue.getKey(), (String)str, (int)cursor)).orElseGet(() -> new SuggestionsBuilder("", 0).buildFuture())));
            }
        }));
        int editorY = 128;
        this.editor = new List2D(16, 128, this.field_22789 - 32, this.field_22790 - 128 - 32 - 8, 4, 32, 32, 8).setFinalEventHandler(new MVElement(){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                NBTEditorScreen.this.selectedValue = null;
                NBTEditorScreen.this.value.method_1852("");
                NBTEditorScreen.this.value.method_1888(false);
                return true;
            }
        });
        this.genEditor();
        this.method_25429(this.editor);
    }

    private void genEditor() {
        this.checkSave();
        this.selectedValue = null;
        this.value.method_1852("");
        this.value.method_1888(false);
        this.updateName();
        this.editor.clearElements();
        this.json = false;
        this.currentFolder = this.baseFolder;
        Iterator<String> keys = this.realPath.iterator();
        boolean removing = false;
        while (keys.hasNext()) {
            String key2 = keys.next();
            if (removing) {
                keys.remove();
                continue;
            }
            NBTFolder<?> folder = this.currentFolder.getSubFolder(key2);
            if (folder != null) {
                this.currentFolder = folder;
                if (!(this.currentFolder instanceof StringNBTFolder)) continue;
                this.json = true;
                continue;
            }
            keys.remove();
            removing = true;
        }
        if (removing) {
            MainUtil.setTextFieldValueSilently(this.path, this.realPath.toString(), true);
        }
        if (this.realPath.isEmpty()) {
            this.upValue = null;
        } else {
            this.upValue = new NBTValue(this, null, null);
            this.upValue.updateInvalidComponent(this.localNBT, this.realPath.get(0));
            this.editor.addElement(this.upValue);
        }
        List<NBTValue> elements = this.currentFolder.getEntries(this);
        if (elements == null) {
            this.selectNbt(null, true);
            return;
        }
        if (this.realPath.isEmpty()) {
            elements.forEach(element -> element.updateInvalidComponent(this.localNBT, null));
        }
        elements.sort((a, b) -> a.getKey().compareToIgnoreCase(b.getKey()));
        elements.forEach(this.editor::addElement);
        this.editor.setScroll(Math.max(this.editor.getMaxScroll(), this.scrollPerFolder.computeIfAbsent(this.realPath.toString(), key -> 0)));
    }

    private void updateName() {
        String newName = this.localNBT.getName().getString();
        if (!this.name.field_2092.equals(newName)) {
            MainUtil.setTextFieldValueSilently(this.name, newName, false);
        }
    }

    @Override
    protected boolean isNameEditable() {
        return true;
    }

    void selectNbt(NBTValue key, boolean isFolder) {
        if (isFolder) {
            if (key == null) {
                this.realPath.remove(this.realPath.size() - 1);
            } else {
                this.realPath.add(key.getKey());
            }
            this.selectedValue = null;
            this.value.method_1852("");
            this.value.method_1888(false);
            MainUtil.setTextFieldValueSilently(this.path, this.realPath.toString(), true);
            this.genEditor();
        } else {
            this.selectedValue = key;
            this.value.method_1852(key.getValueText(this.json));
            this.value.method_1888(true);
        }
    }

    @Override
    protected void preRenderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        MVTooltip.setOneTooltip(true, false);
        this.editor.render(matrices, mouseX, mouseY, delta);
        MVTooltip.renderOneTooltip(matrices, mouseX, mouseY);
    }

    @Override
    protected void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (NBTAutocompleteIntegration.INSTANCE.isEmpty()) {
            this.renderTip(matrices, "nbteditor.nbt_ac.tip");
        }
    }

    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }

    @Override
    protected boolean save() {
        if (this.localNBT.isEmpty() && this.localNBT.getNBT() != null && !this.localNBT.getNBT().method_33133()) {
            MainUtil.client.method_1507((class_437)new FancyConfirmScreen(value -> {
                if (value) {
                    super.save();
                }
                MainUtil.client.method_1507((class_437)this);
            }, TextInst.translatable("nbteditor.nbt.saving_air.title", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_air.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_air.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_air.no", new Object[0])).setParent(this));
            return false;
        }
        if (this.localNBT instanceof LocalItem && this.localNBT.getNBT() != null) {
            List<NBTValue> elements = this.baseFolder.getEntries(this);
            elements.forEach(element -> element.updateInvalidComponent(this.localNBT, null));
            if (elements.stream().anyMatch(NBTValue::isInvalidComponent)) {
                MainUtil.client.method_1507((class_437)new FancyConfirmScreen(value -> {
                    if (value) {
                        super.save();
                    }
                    MainUtil.client.method_1507((class_437)this);
                }, TextInst.translatable("nbteditor.nbt.saving_invalid_components.title", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_invalid_components.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_invalid_components.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_invalid_components.no", new Object[0])).setParent(this));
                return false;
            }
        }
        return super.save();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.getOverlay() != null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return !this.type.method_25404(keyCode, scanCode, modifiers) && !this.type.method_20315() && !this.count.method_25404(keyCode, scanCode, modifiers) && !this.count.method_20315() && !this.path.method_25404(keyCode, scanCode, modifiers) && !this.path.method_20315() && !this.value.method_25404(keyCode, scanCode, modifiers) && !this.value.method_20315() ? this.keyPressed2(keyCode, scanCode, modifiers) : true;
    }

    private boolean keyPressed2(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 261 || keyCode == 259) {
            this.remove();
        } else if (keyCode == 257 && !this.realPath.isEmpty()) {
            this.selectNbt(null, true);
        }
        if ((modifiers & 2) != 0) {
            if (keyCode == 67) {
                this.copy();
            } else if (keyCode == 88) {
                this.cut();
            } else if (keyCode == 86) {
                this.paste();
            } else if (keyCode == 82) {
                this.rename();
            } else if (keyCode == 78) {
                this.add();
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double xAmount, double yAmount) {
        boolean output = super.method_25401(mouseX, mouseY, xAmount, yAmount);
        this.scrollPerFolder.put(this.realPath.toString(), this.editor.getScroll());
        return output;
    }

    public void method_29638(List<Path> paths) {
        if (!(this.currentFolder.getNBT() instanceof class_2487)) {
            return;
        }
        for (Path path : paths) {
            File file = path.toFile();
            if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
            try (FileInputStream in = new FileInputStream(file);){
                class_2487 nbt = MainUtil.readNBT(in);
                for (String key : nbt.method_10541()) {
                    this.currentFolder.setValue(key, nbt.method_10580(key));
                }
                this.genEditor();
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Error while importing a .nbt file", (Throwable)e);
            }
        }
    }

    public boolean method_25421() {
        return true;
    }

    private void add() {
        this.getNextKey(Optional.empty(), key -> {
            this.currentFolder.addKey((String)key);
            this.genEditor();
        }, false);
    }

    private void remove() {
        if (this.selectedValue != null) {
            this.currentFolder.removeKey(this.selectedValue.getKey());
            this.genEditor();
        }
    }

    private void copy() {
        if (this.selectedValue != null) {
            copiedKey = this.selectedValue.getKey();
            copiedValue = this.currentFolder.getValue(this.selectedValue.getKey()).method_10707();
        }
    }

    private void cut() {
        if (this.selectedValue != null) {
            copiedKey = this.selectedValue.getKey();
            copiedValue = this.currentFolder.getValue(this.selectedValue.getKey()).method_10707();
            this.currentFolder.removeKey(this.selectedValue.getKey());
            this.genEditor();
        }
    }

    private void paste() {
        if (copiedKey != null) {
            this.getNextKey(Optional.of(copiedKey), key -> {
                this.currentFolder.addKey((String)key);
                this.currentFolder.setValue((String)key, copiedValue.method_10707());
                this.genEditor();
            }, false);
        }
    }

    private void rename() {
        if (this.selectedValue != null) {
            String selectedKey = this.selectedValue.getKey();
            class_2520 selectedValue = this.currentFolder.getValue(selectedKey);
            this.getKey(selectedKey, key -> this.promptForDuplicateKey((String)key, key2 -> {
                this.currentFolder.removeKey(selectedKey);
                this.currentFolder.addKey((String)key2);
                this.currentFolder.setValue((String)key2, selectedValue);
                this.genEditor();
            }), true);
        }
    }

    private void getKey(String defaultValue, Consumer<String> keyConsumer, boolean renaming) {
        InputOverlay.show(TextInst.translatable("nbteditor.nbt.key", new Object[0]), StringInput.builder().withDefault(defaultValue).withValidator(str -> !str.isEmpty() && this.currentFolder.getKeyValidator(renaming).test((String)str)).withSuggestions((str, cursor) -> NBTAutocompleteIntegration.INSTANCE.map(ac -> ac.getSuggestions(this.localNBT, this.realPath, (String)str, null, (int)cursor, (Collection<String>)this.currentFolder.getEntries(this).stream().map(NBTValue::getKey).toList())).orElseGet(() -> new SuggestionsBuilder("", 0).buildFuture())).build(), keyConsumer);
    }

    private void getKey(Consumer<String> keyConsumer, boolean renaming) {
        this.getKey(null, keyConsumer, renaming);
    }

    private void promptForDuplicateKey(String key, Consumer<String> keyConsumer) {
        if (this.currentFolder.handlesDuplicateKeys() || this.currentFolder.getValue(key) == null) {
            keyConsumer.accept(key);
            return;
        }
        this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
            if (value) {
                keyConsumer.accept(key);
            }
            this.field_22787.method_1507((class_437)this);
        }, TextInst.translatable("nbteditor.nbt.overwrite.title", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.no", new Object[0])));
    }

    private void getNextKey(Optional<String> pastingKey, Consumer<String> keyConsumer, boolean renaming) {
        this.currentFolder.getNextKey(pastingKey).ifPresentOrElse(key -> this.promptForDuplicateKey((String)key, keyConsumer), () -> this.getKey(key -> this.promptForDuplicateKey((String)key, keyConsumer), renaming));
    }
}

