/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetLostItemCommand;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Reflection;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.LocalFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.AlertWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.MethodType;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class LocalEditorScreen<L extends LocalNBT>
extends OverlaySupportingScreen {
    protected final NBTReference<L> ref;
    protected L localNBT;
    protected L savedLocalNBT;
    private boolean saved;
    protected NamedTextFieldWidget name;
    private class_4185 saveBtn;
    private static final Supplier<Reflection.MethodInvoker> RenderSystem_getModelViewStack = Reflection.getOptionalMethod(RenderSystem.class, "getModelViewStack", MethodType.methodType(class_4587.class));

    protected LocalEditorScreen(class_2561 title, NBTReference<L> ref) {
        super(title);
        this.ref = ref;
        this.savedLocalNBT = LocalNBT.copy(ref.getLocalNBT());
        this.localNBT = LocalNBT.copy(this.savedLocalNBT);
        this.saved = true;
    }

    protected boolean isNameEditable() {
        return false;
    }

    protected boolean isSaveRequried() {
        return true;
    }

    protected FactoryLink<L> getFactoryLink() {
        return new FactoryLink("nbteditor.factory", LocalFactoryScreen::new);
    }

    @Override
    protected final void method_25426() {
        FactoryLink<L> link;
        super.method_25426();
        this.name = new NamedTextFieldWidget(96, 24, 100, 16){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (LocalEditorScreen.this.isNameEditable()) {
                    return super.method_25402(mouseX, mouseY, button);
                }
                return false;
            }
        }.name(TextInst.translatable("nbteditor.editor.name", new Object[0]));
        this.name.method_1880(Integer.MAX_VALUE);
        this.name.method_1852(this.localNBT.getName().getString());
        this.name.method_1888(this.isNameEditable());
        this.method_37063(this.name);
        if (this.isSaveRequried()) {
            this.saveBtn = (class_4185)this.method_37063((class_364)MVMisc.newButton(204, 22, 100, 20, TextInst.translatable("nbteditor.editor.save", new Object[0]), btn -> this.save()));
            boolean bl = this.saveBtn.field_22763 = !this.saved;
        }
        if ((link = this.getFactoryLink()) != null) {
            this.method_37063((class_364)MVMisc.newTexturedButton(this.field_22789 - 36, 22, 20, 20, 20, LocalFactoryScreen.FACTORY_ICON, btn -> this.closeSafely(() -> this.field_22787.method_1507(link.factory().apply(ItemReference.toItemStackRef(this.ref)))), new MVTooltip(link.langName())));
        }
        this.initEditor();
    }

    protected void initEditor() {
    }

    @Override
    public final void renderMain(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.renderBackground(matrices);
        this.preRenderEditor(matrices, mouseX, mouseY, delta);
        super.renderMain(matrices, mouseX, mouseY, delta);
        this.renderEditor(matrices, mouseX, mouseY, delta);
        MainUtil.renderLogo(matrices);
        this.renderPreview(matrices, delta);
    }

    private void renderPreview(class_4587 matrices, float tickDelta) {
        int x = 56;
        int y = 16;
        int scaleX = 2;
        int scaleY = 2;
        x /= scaleX;
        y /= scaleY;
        boolean oldMatrix = Version.newSwitch().range("1.19.4", null, false).range(null, "1.19.3", true).get();
        if (oldMatrix) {
            matrices = (class_4587)RenderSystem_getModelViewStack.get().invoke(null, new Object[0]);
        }
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 32.0);
        matrices.method_22905((float)scaleX, (float)scaleY, 1.0f);
        if (oldMatrix) {
            MVDrawableHelper.applyModelViewMatrix();
        }
        this.localNBT.renderIcon(matrices, x, y, tickDelta);
        matrices.method_22909();
        if (oldMatrix) {
            MVDrawableHelper.applyModelViewMatrix();
        }
    }

    protected void preRenderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void renderTip(class_4587 matrices, String langHint) {
        if (!ConfigScreen.isKeybindsHidden()) {
            int x = 312;
            MainUtil.drawWrappingString(matrices, this.field_22793, TextInst.translatable(langHint, new Object[0]).getString(), 312, 32, this.field_22789 - x - 8 - 20 - 8, -1, false, true);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.getOverlay() != null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (LocalEditorScreen.method_25441() && !LocalEditorScreen.method_25442() && !LocalEditorScreen.method_25443() && keyCode == 83) {
            this.save();
            return true;
        }
        return this.name.method_25404(keyCode, scanCode, modifiers);
    }

    protected void setSaved(boolean saved) {
        this.saved = saved;
        if (this.saveBtn != null) {
            this.saveBtn.field_22763 = !saved;
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected boolean save() {
        if (this.ref.exists()) {
            this.savedLocalNBT = LocalNBT.copy(this.localNBT);
            this.saveBtn.method_25355((class_2561)TextInst.translatable("nbteditor.editor.saving", new Object[0]));
            this.setSaved(true);
            this.ref.saveLocalNBT(this.savedLocalNBT, () -> this.saveBtn.method_25355((class_2561)TextInst.translatable("nbteditor.editor.save", new Object[0])));
        } else {
            this.localNBT.toItem().ifPresentOrElse(item -> {
                this.savedLocalNBT = LocalNBT.copy(this.localNBT);
                GetLostItemCommand.loseItem(item);
                this.setSaved(true);
                this.saveBtn.method_25355((class_2561)TextInst.translatable("nbteditor.editor.save", new Object[0]));
            }, () -> this.setOverlay(new AlertWidget(() -> this.setOverlay(null), TextInst.translatable("nbteditor.editor.ref_broken", new Object[0])), 500.0));
        }
        return true;
    }

    protected void checkSave() {
        this.localNBT.getOrCreateNBT();
        this.savedLocalNBT.getOrCreateNBT();
        this.setSaved(this.localNBT.equals(this.savedLocalNBT));
    }

    public void method_25419() {
        this.closeSafely(this.ref::showParent);
    }

    protected void closeSafely(Runnable onClose) {
        if (this.saved) {
            onClose.run();
        } else {
            this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                if (!value || this.save()) {
                    onClose.run();
                }
            }, TextInst.translatable("nbteditor.editor.unsaved.title", new Object[0]), TextInst.translatable("nbteditor.editor.unsaved.desc", new Object[0]), TextInst.translatable("nbteditor.editor.unsaved.yes", new Object[0]), TextInst.translatable("nbteditor.editor.unsaved.no", new Object[0])));
        }
    }

    protected record FactoryLink<L extends LocalNBT>(String langName, Function<NBTReference<L>, class_437> factory) {
    }
}

