/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVScreen;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class LoadingScreen
extends MVScreen {
    private static final int MAX_FREEZE_TIME = 200;
    private static final int MIN_LOADING_TIME = 200;
    private final CompletableFuture<?> future;
    private final Consumer<Object> onFinish;
    private final Consumer<Throwable> onException;
    private final long startTime;

    public static <T> void show(CompletableFuture<T> future, Runnable onLoading, BiConsumer<Boolean, T> onFinish, BiConsumer<Boolean, Throwable> onException) {
        try {
            onFinish.accept(false, (Boolean)future.get(200L, TimeUnit.MILLISECONDS));
            return;
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            onException.accept(false, e3.getCause());
            return;
        }
        catch (CancellationException e4) {
            onException.accept(false, e4);
            return;
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        onLoading.run();
        MainUtil.client.method_1507((class_437)new LoadingScreen(future, value -> onFinish.accept(true, (Boolean)value), e -> onException.accept(true, (Throwable)e)));
    }

    public static <T> void show(CompletableFuture<T> future, Runnable onLoading, BiConsumer<Boolean, T> onFinish) {
        LoadingScreen.show(future, onLoading, onFinish, (loaded, e) -> NBTEditor.LOGGER.error("Error processing something", e));
    }

    public static <T> void show(CompletableFuture<T> future, Consumer<T> onFinish) {
        LoadingScreen.show(future, () -> {}, (loaded, value) -> onFinish.accept(value));
    }

    private <T> LoadingScreen(CompletableFuture<T> future, Consumer<T> onFinish, Consumer<Throwable> onException) {
        super(TextInst.of("Loading"));
        this.future = future;
        this.onFinish = result -> onFinish.accept(result);
        this.onException = onException;
        this.startTime = System.currentTimeMillis();
    }

    protected void method_25426() {
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 / 2 - 75, this.field_22790 / 2, 150, 20, TextInst.translatable("nbteditor.hide", new Object[0]), btn -> this.method_25419()));
    }

    public void method_25393() {
        super.method_25393();
        if (this.future.isDone() && System.currentTimeMillis() - this.startTime >= 200L) {
            try {
                this.onFinish.accept(this.future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.onException.accept(e.getCause());
            }
            catch (CancellationException e) {
                this.onException.accept(e);
            }
        }
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        MainUtil.renderLogo(matrices);
        EditableText editableText = TextInst.translatable("nbteditor.loading", new Object[0]);
        int n = this.field_22789 / 2;
        int n2 = this.field_22790 / 2;
        Objects.requireNonNull(this.field_22793);
        MVDrawableHelper.drawCenteredTextWithShadow(matrices, this.field_22793, editableText, n, n2 - 9 / 2 - 10, -1);
    }
}

