/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ImageToLoreWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ImportPosWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.tagreferences.ItemTagReferences;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

public class ImportScreen
extends OverlaySupportingScreen {
    private final List<class_2561> msg = TextUtil.getLongTranslatableTextLines("nbteditor.nbt.import.desc");
    private NamedTextFieldWidget dataVersion;

    public static void importFiles(List<Path> paths, Optional<Integer> defaultDataVersion) {
        ArrayList posConsumers = new ArrayList();
        for (Path path : paths) {
            File file2 = path.toFile();
            if (!file2.isFile() || !file2.getName().endsWith(".nbt")) continue;
            try (FileInputStream in = new FileInputStream(file2);){
                class_2487 nbt = MainUtil.readNBT(in);
                if (defaultDataVersion.isEmpty() && !nbt.method_10573("DataVersion", 99)) {
                    MainUtil.client.field_1724.method_7353(TextUtil.parseTranslatableFormatted("nbteditor.nbt.import.data_version.unknown", file2.getName()), false);
                }
                if (nbt.method_10550("DataVersion") > Version.getDataVersion()) {
                    MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.nbt.import.data_version.new", file2.getName()), false);
                }
                LocalNBT.deserialize(nbt, defaultDataVersion.orElse(Version.getDataVersion())).ifPresent(localNBT -> {
                    if (localNBT instanceof LocalItem) {
                        LocalItem item = (LocalItem)localNBT;
                        item.receive();
                    } else if (localNBT instanceof LocalBlock) {
                        LocalBlock block = (LocalBlock)localNBT;
                        posConsumers.add(pos -> block.place((class_2338)pos));
                    } else if (localNBT instanceof LocalEntity) {
                        LocalEntity entity = (LocalEntity)localNBT;
                        posConsumers.add(pos -> entity.summon((class_5321<class_1937>)MainUtil.client.field_1687.method_27983(), class_243.method_24953((class_2382)pos)));
                    }
                });
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Error while importing a .nbt file", (Throwable)e);
                MainUtil.client.field_1724.method_7353((class_2561)TextInst.literal(e.getClass().getName() + ": " + e.getMessage()).formatted(class_124.field_1061), false);
            }
        }
        if (!posConsumers.isEmpty()) {
            ImportPosWidget.openImportPos(MainUtil.client.field_1724.method_24515(), pos -> posConsumers.forEach(consumer -> consumer.accept(pos)));
            return;
        }
        ImageToLoreWidget.openImportFiles(paths, (file, imgLore) -> {
            String name = file.getName();
            int nameDot = name.lastIndexOf(46);
            if (nameDot != -1) {
                name = name.substring(0, nameDot);
            }
            class_1799 painting = new class_1799((class_1935)class_1802.field_8892);
            painting.manager$setCustomName((class_2561)TextInst.literal(name).styled(style -> style.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1065)));
            ItemTagReferences.LORE.set(painting, (List<class_2561>)imgLore);
            MainUtil.getWithMessage(painting);
        }, () -> {});
    }

    public ImportScreen() {
        super(TextInst.of("Import"));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this.field_22793);
        this.dataVersion = (NamedTextFieldWidget)this.method_37063(new NamedTextFieldWidget(16, 64 + 9 * this.msg.size() + 16, 100, 16, this.dataVersion).name(TextInst.translatable("nbteditor.nbt.import.data_version", new Object[0])).tooltip(new MVTooltip("nbteditor.nbt.import.data_version.desc")));
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 - 116, this.field_22790 - 36, 100, 20, ScreenTexts.DONE, btn -> this.method_25419()));
    }

    @Override
    protected void renderMain(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.dataVersion.setValid(this.dataVersion.method_1882().isEmpty() || Version.getDataVersion(this.dataVersion.method_1882()).filter(value -> value <= Version.getDataVersion()).isPresent());
        super.renderBackground(matrices);
        super.renderMain(matrices, mouseX, mouseY, delta);
        for (int i = 0; i < this.msg.size(); ++i) {
            Objects.requireNonNull(this.field_22793);
            MVDrawableHelper.drawText(matrices, this.field_22793, this.msg.get(i), 16, 64 + 9 * i, -1, true);
        }
        MainUtil.renderLogo(matrices);
    }

    public void method_29638(List<Path> paths) {
        ImportScreen.importFiles(paths, Version.getDataVersion(this.dataVersion.method_1882()).filter(value -> value <= Version.getDataVersion()));
    }
}

