/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.DataVersionStatus;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.LoadingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.TickableSupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ClientChestDataVersionScreen
extends TickableSupportingScreen {
    private final DataVersionStatus dataVersionStatus;
    private final class_2561 msg;
    private NamedTextFieldWidget dataVersion;
    private class_4185 updatePageBtn;

    public ClientChestDataVersionScreen(Optional<Integer> dataVersion) {
        super(TextInst.of("Client Chest DataVersion"));
        DataVersionStatus dataVersionStatus;
        this.dataVersionStatus = dataVersionStatus = DataVersionStatus.of(dataVersion);
        this.msg = TextInst.translatable("nbteditor.client_chest.data_version." + (switch (dataVersionStatus) {
            case DataVersionStatus.UNKNOWN -> "unknown";
            case DataVersionStatus.OUTDATED -> "old";
            case DataVersionStatus.TOO_UPDATED -> "new";
            default -> throw new IllegalArgumentException("Unexpected DataVersionStatus: " + String.valueOf((Object)dataVersionStatus));
        }), ClientChestScreen.PAGE + 1, dataVersion.flatMap(Version::getMCVersion).or(() -> dataVersion.map(value -> value.toString())).orElse(""));
    }

    protected void method_25426() {
        EditableText prevKeybind = TextInst.translatable("nbteditor.keybind.page.down", new Object[0]);
        EditableText nextKeybind = TextInst.translatable("nbteditor.keybind.page.up", new Object[0]);
        if (ConfigScreen.isInvertedPageKeybinds()) {
            EditableText temp = prevKeybind;
            prevKeybind = nextKeybind;
            nextKeybind = temp;
        }
        int dontUpdatePageX = this.field_22789 / 2 + (this.dataVersionStatus == DataVersionStatus.TOO_UPDATED ? -50 : 58);
        this.method_37063((class_364)MVMisc.newButton(dontUpdatePageX, this.field_22790 / 2 - 34, 52, 20, TextInst.translatable("nbteditor.client_chest.data_version.dont_update_page", new Object[0]), btn -> this.method_25419()));
        ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)(dontUpdatePageX + 56), (int)(this.field_22790 / 2 - 34), (int)20, (int)20, (class_2561)TextInst.of((String)"<"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$3(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ClientChestDataVersionScreen)this), (MVTooltip)(ConfigScreen.isKeybindsHidden() ? null : new MVTooltip((class_2561[])new class_2561[]{TextInst.literal((String)"").append((class_2561)prevKeybind).append((class_2561)TextInst.translatable((String)"nbteditor.keybind.page.prev", (Object[])new Object[0]))}))))).field_22763 = ClientChestScreen.PAGE > 0;
        ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)(dontUpdatePageX + 80), (int)(this.field_22790 / 2 - 34), (int)20, (int)20, (class_2561)TextInst.of((String)">"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$4(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ClientChestDataVersionScreen)this), (MVTooltip)(ConfigScreen.isKeybindsHidden() ? null : new MVTooltip((class_2561[])new class_2561[]{TextInst.literal((String)"").append((class_2561)nextKeybind).append((class_2561)TextInst.translatable((String)"nbteditor.keybind.page.next", (Object[])new Object[0]))}))))).field_22763 = ClientChestScreen.PAGE < NBTEditorClient.CLIENT_CHEST.getPageCount() - 1;
        this.method_37063((class_364)MVMisc.newButton(dontUpdatePageX, this.field_22790 / 2 - 10, 100, 20, TextInst.translatable("nbteditor.client_chest.reload_page", new Object[0]), btn -> LoadingScreen.show(ClientChestHelper.reloadPage(ClientChestScreen.PAGE), pageData -> ClientChestScreen.show())));
        this.method_37063((class_364)MVMisc.newButton(dontUpdatePageX, this.field_22790 / 2 + 14, 100, 20, TextInst.translatable("nbteditor.client_chest.clear_page", new Object[0]), btn -> this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
            if (value) {
                LoadingScreen.show(ClientChestHelper.discardPage(ClientChestScreen.PAGE), success -> ClientChestScreen.show());
                return;
            }
            this.field_22787.method_1507((class_437)this);
        }, TextInst.translatable("nbteditor.client_chest.clear_page.title", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.desc", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.yes", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.no", new Object[0])))));
        if (this.dataVersionStatus == DataVersionStatus.TOO_UPDATED) {
            return;
        }
        ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)(this.field_22789 / 2 - 158), (int)(this.field_22790 / 2 - 10), (int)100, (int)20, (class_2561)TextInst.translatable((String)"nbteditor.client_chest.data_version.import_page", (Object[])new Object[0]), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$11(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ClientChestDataVersionScreen)this), (MVTooltip)new MVTooltip((String[])new String[]{"nbteditor.client_chest.data_version.import_page.desc"})))).field_22763 = this.dataVersionStatus == DataVersionStatus.UNKNOWN;
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 / 2 - 158, this.field_22790 / 2 + 14, 100, 20, TextInst.translatable("nbteditor.client_chest.data_version.import_all_pages", new Object[0]), btn -> LoadingScreen.show(this.addSuccessMessage(ClientChestHelper.importAllPages(), true), success -> ClientChestScreen.show()), new MVTooltip("nbteditor.client_chest.data_version.import_all_pages.desc")));
        this.dataVersion = (NamedTextFieldWidget)this.method_37063(new NamedTextFieldWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 - 32, 100, 16, this.dataVersion).name(TextInst.translatable("nbteditor.nbt.import.data_version", new Object[0])).tooltip(new MVTooltip("nbteditor.nbt.import.data_version.desc")));
        this.updatePageBtn = (class_4185)this.method_37063((class_364)MVMisc.newButton(this.field_22789 / 2 - 50, this.field_22790 / 2 - 10, 100, 20, TextInst.translatable("nbteditor.client_chest.data_version.update_page", new Object[0]), btn -> {
            Optional<Integer> dataVersionValue = Version.getDataVersion(this.dataVersion.method_1882()).filter(value -> value < Version.getDataVersion());
            if (this.dataVersionStatus == DataVersionStatus.UNKNOWN && dataVersionValue.isEmpty()) {
                return;
            }
            this.updateWithWarning(() -> LoadingScreen.show(this.addSuccessMessage(ClientChestHelper.updatePage(ClientChestScreen.PAGE, dataVersionValue), false), success -> ClientChestScreen.show()));
        }, new MVTooltip("nbteditor.client_chest.data_version.update_page.desc." + (this.dataVersionStatus == DataVersionStatus.UNKNOWN ? "unknown" : "old"))));
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 / 2 - 50, this.field_22790 / 2 + 14, 100, 20, TextInst.translatable("nbteditor.client_chest.data_version.update_all_pages", new Object[0]), btn -> {
            Optional<Integer> dataVersionValue = Version.getDataVersion(this.dataVersion.method_1882()).filter(value -> value < Version.getDataVersion());
            this.updateWithWarning(() -> LoadingScreen.show(this.addSuccessMessage(ClientChestHelper.updateAllPages(dataVersionValue), true), success -> ClientChestScreen.show()));
        }, new MVTooltip("nbteditor.client_chest.data_version.update_all_pages.desc")));
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        boolean fullButtons;
        boolean bl = fullButtons = this.dataVersionStatus != DataVersionStatus.TOO_UPDATED;
        if (fullButtons) {
            this.dataVersion.setValid(this.dataVersionStatus == DataVersionStatus.OUTDATED && this.dataVersion.method_1882().isEmpty() || Version.getDataVersion(this.dataVersion.method_1882()).filter(value -> value < Version.getDataVersion()).isPresent());
            this.updatePageBtn.field_22763 = this.dataVersionStatus == DataVersionStatus.UNKNOWN ? this.dataVersion.isValid() : this.dataVersion.method_1882().isEmpty();
        }
        MVTooltip.setOneTooltip(true, false);
        super.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        int n = this.field_22789 / 2;
        int n2 = this.field_22790 / 2 - 44;
        Objects.requireNonNull(this.field_22793);
        MVDrawableHelper.drawCenteredTextWithShadow(matrices, this.field_22793, this.msg, n, n2 - 9 / 2, -1);
        if (fullButtons) {
            MVDrawableHelper.fill(matrices, this.field_22789 / 2 - 55, this.field_22790 / 2 - 34, this.field_22789 / 2 - 53, this.field_22790 / 2 + 34, -5592406);
            MVDrawableHelper.fill(matrices, this.field_22789 / 2 + 53, this.field_22790 / 2 - 34, this.field_22789 / 2 + 55, this.field_22790 / 2 + 34, -5592406);
            EditableText editableText = TextInst.translatable("nbteditor.client_chest.data_version.import", Version.getReleaseTarget());
            int n3 = this.field_22789 / 2 - 108;
            int n4 = this.field_22790 / 2 - 24;
            Objects.requireNonNull(this.field_22793);
            MVDrawableHelper.drawCenteredTextWithShadow(matrices, this.field_22793, editableText, n3, n4 - 9 / 2, -1);
        }
        MainUtil.renderLogo(matrices);
        MVTooltip.renderOneTooltip(matrices, mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 266 || keyCode == 267) {
            boolean prev;
            boolean bl = prev = keyCode == 267;
            if (ConfigScreen.isInvertedPageKeybinds()) {
                boolean bl2 = prev = !prev;
            }
            if (prev) {
                this.prevPage();
            } else {
                this.nextPage();
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void prevPage() {
        if (ClientChestScreen.PAGE > 0) {
            --ClientChestScreen.PAGE;
            ClientChestScreen.show();
        }
    }

    private void nextPage() {
        if (ClientChestScreen.PAGE < NBTEditorClient.CLIENT_CHEST.getPageCount() - 1) {
            ++ClientChestScreen.PAGE;
            ClientChestScreen.show();
        }
    }

    private CompletableFuture<Boolean> addSuccessMessage(CompletableFuture<Boolean> future, boolean all) {
        future.thenAccept(success -> {
            if (success.booleanValue()) {
                EditableText msg = all ? TextInst.translatable("nbteditor.client_chest.data_version.update_all_pages_success", new Object[0]) : TextInst.translatable("nbteditor.client_chest.data_version.update_page_success", TextInst.literal("" + (ClientChestScreen.PAGE + 1)).formatted(class_124.field_1060));
                MainUtil.client.field_1724.method_7353(ClientChest.attachShowFolder(msg), false);
            }
        });
        return future;
    }

    private void updateWithWarning(Runnable callback) {
        if (Version.newSwitch().range("1.21", null, true).range("1.20.5", "1.20.6", false).range(null, "1.20.4", true).get().booleanValue()) {
            callback.run();
            return;
        }
        this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
            if (value) {
                callback.run();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, TextInst.translatable("nbteditor.client_chest.data_version.update_page_confirm_1.20.5_1.20.6.title", new Object[0]), TextInst.translatable("nbteditor.client_chest.data_version.update_page_confirm_1.20.5_1.20.6.desc", new Object[0])));
    }

    private /* synthetic */ void lambda$init$11(class_4185 btn) {
        LoadingScreen.show(this.addSuccessMessage(ClientChestHelper.importPage(ClientChestScreen.PAGE), false), success -> ClientChestScreen.show());
    }

    private /* synthetic */ void lambda$init$4(class_4185 btn) {
        this.nextPage();
    }

    private /* synthetic */ void lambda$init$3(class_4185 btn) {
        this.prevPage();
    }
}

