/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommandGroup;
import com.luneruniverse.minecraft.mod.nbteditor.commands.CommandHandler;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.TickableSupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigBar;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigList;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueText;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class AliasesScreen
extends TickableSupportingScreen {
    private static final ConfigBar ALIAS_ENTRY = new ConfigBar();
    private final class_437 parent;
    private final ConfigList config;
    private ConfigPanel panel;
    private boolean cancel;

    private static ConfigValueText getConfigOriginal(ConfigBar enchant) {
        return (ConfigValueText)((ConfigItem)enchant.getConfigurable("original")).getValue();
    }

    private static ConfigValueText getConfigAlias(ConfigBar enchant) {
        return (ConfigValueText)((ConfigItem)enchant.getConfigurable("alias")).getValue();
    }

    public AliasesScreen(class_437 parent) {
        super(TextInst.translatable("nbteditor.config.aliases", new Object[0]));
        this.parent = parent;
        this.config = new ConfigList(TextInst.translatable("nbteditor.config.aliases", new Object[0]).append(" - ").append(TextInst.translatable("nbteditor.config.aliases.example", new Object[0])), false, ALIAS_ENTRY);
        for (ConfigScreen.Alias alias : ConfigScreen.getAliases()) {
            ConfigBar entry = (ConfigBar)ALIAS_ENTRY.clone(true);
            AliasesScreen.getConfigOriginal(entry).setValue(alias.original());
            AliasesScreen.getConfigAlias(entry).setValue(alias.alias());
            this.config.addConfigurable(entry);
        }
    }

    private void addExtremeAliases(Collection<ClientCommand> commands, String path) {
        for (ClientCommand command : commands) {
            if (command.getExtremeAlias() != null) {
                ConfigBar entry = (ConfigBar)ALIAS_ENTRY.clone(true);
                AliasesScreen.getConfigOriginal(entry).setValue(path + command.getName());
                AliasesScreen.getConfigAlias(entry).setValue(command.getExtremeAlias());
                this.config.addConfigurable(entry);
            }
            if (!(command instanceof ClientCommandGroup)) continue;
            ClientCommandGroup group = (ClientCommandGroup)command;
            this.addExtremeAliases(group.getChildren(), path + command.getName() + " ");
        }
    }

    protected void method_25426() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 16, this.field_22789 - 32, this.field_22790 - 32, this.config));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 - 134, this.field_22790 - 36, 100, 20, ScreenTexts.DONE, btn -> this.method_25419()));
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 - 134, this.field_22790 - 36 - 24, 100, 20, ScreenTexts.CANCEL, btn -> {
            this.cancel = true;
            this.method_25419();
        }));
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 - 134, this.field_22790 - 36 - 48, 100, 20, TextInst.translatable("nbteditor.config.aliases.extreme", new Object[0]), btn -> this.addExtremeAliases(CommandHandler.COMMANDS.values(), ""), new MVTooltip("nbteditor.config.aliases.extreme.desc")));
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        if (this.cancel) {
            return;
        }
        LinkedHashMap<CallSite, ConfigScreen.Alias> newAliases = new LinkedHashMap<CallSite, ConfigScreen.Alias>();
        for (ConfigPath path : this.config.getConfigurables().values()) {
            ConfigBar entry = (ConfigBar)path;
            String original = (String)AliasesScreen.getConfigOriginal(entry).getValidValue();
            String alias = (String)AliasesScreen.getConfigAlias(entry).getValidValue();
            newAliases.put((CallSite)((Object)(original.substring(0, original.lastIndexOf(32) + 1) + alias)), new ConfigScreen.Alias(original, alias));
        }
        if (new HashSet<ConfigScreen.Alias>(ConfigScreen.getAliases()).equals(new HashSet(newAliases.values()))) {
            return;
        }
        ConfigScreen.getAliases().clear();
        ConfigScreen.getAliases().addAll(newAliases.values());
        ClientCommandManager.reregisterClientCommands();
    }

    static {
        ALIAS_ENTRY.setConfigurable("original", new ConfigItem<ConfigValueText>(TextInst.of(""), new ConfigValueText(200, "", "")));
        ALIAS_ENTRY.setConfigurable("alias", new ConfigItem<ConfigValueText>(TextInst.of(""), new ConfigValueText(100, "", "")));
    }
}

