/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.packets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistryKeys;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ResponsePacket;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ViewEntityS2CPacket
implements ResponsePacket {
    public static final class_2960 ID = IdentifierInst.of("nbteditor", "view_entity");
    private final int requestId;
    private final class_5321<class_1937> world;
    private final UUID uuid;
    private final class_2960 id;
    private final class_2487 nbt;

    public ViewEntityS2CPacket(int requestId, class_5321<class_1937> world, UUID uuid, class_2960 id, class_2487 nbt) {
        if (world == null != (uuid == null)) {
            throw new IllegalArgumentException("world and uuid have to be null together!");
        }
        if (id == null != (nbt == null)) {
            throw new IllegalArgumentException("id and nbt have to be null together!");
        }
        this.requestId = requestId;
        this.world = world;
        this.uuid = uuid;
        this.id = id;
        this.nbt = nbt;
    }

    public ViewEntityS2CPacket(class_2540 payload) {
        this.requestId = payload.method_10816();
        if (payload.readBoolean()) {
            this.world = payload.method_44112(MVRegistryKeys.WORLD);
            this.uuid = payload.method_10790();
        } else {
            this.world = null;
            this.uuid = null;
        }
        if (payload.readBoolean()) {
            this.id = payload.method_10810();
            this.nbt = payload.method_10798();
        } else {
            this.id = null;
            this.nbt = null;
        }
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean foundEntity() {
        return this.id != null;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public void write(class_2540 payload) {
        payload.method_10804(this.requestId);
        if (this.world == null) {
            payload.method_52964(false);
        } else {
            payload.method_52964(true);
            payload.method_44116(this.world);
            payload.method_10797(this.uuid);
        }
        if (this.id == null) {
            payload.method_52964(false);
        } else {
            payload.method_52964(true);
            payload.method_10812(this.id);
            payload.writeNbtCompound(this.nbt);
        }
    }

    @Override
    public class_2960 getPacketId() {
        return ID;
    }
}

