/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.packets;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistryKeys;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ResponsePacket;
import com.luneruniverse.minecraft.mod.nbteditor.util.BlockStateProperties;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ViewBlockS2CPacket
implements ResponsePacket {
    public static final class_2960 ID = IdentifierInst.of("nbteditor", "view_block");
    private final int requestId;
    private final class_5321<class_1937> world;
    private final class_2338 pos;
    private final class_2960 id;
    private final BlockStateProperties state;
    private final class_2487 nbt;

    public ViewBlockS2CPacket(int requestId, class_5321<class_1937> world, class_2338 pos, class_2960 id, BlockStateProperties state, class_2487 nbt) {
        if (world == null != (pos == null)) {
            throw new IllegalArgumentException("world and pos have to be null together!");
        }
        if (id == null != (state == null) || id == null != (nbt == null)) {
            throw new IllegalArgumentException("id, state, and nbt have to be null together!");
        }
        this.requestId = requestId;
        this.world = world;
        this.pos = pos;
        this.id = id;
        this.state = state;
        this.nbt = nbt;
    }

    public ViewBlockS2CPacket(class_2540 payload) {
        this.requestId = payload.method_10816();
        if (payload.readBoolean()) {
            this.world = payload.method_44112(MVRegistryKeys.WORLD);
            this.pos = payload.method_10811();
        } else {
            this.world = null;
            this.pos = null;
        }
        if (payload.readBoolean()) {
            this.id = payload.method_10810();
            this.state = new BlockStateProperties(payload);
            this.nbt = payload.method_10798();
        } else {
            this.id = null;
            this.state = null;
            this.nbt = null;
        }
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public boolean foundBlock() {
        return this.id != null;
    }

    public class_2960 getId() {
        return this.id;
    }

    public BlockStateProperties getState() {
        return this.state;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public void write(class_2540 payload) {
        payload.method_10804(this.requestId);
        if (this.world == null) {
            payload.method_52964(false);
        } else {
            payload.method_52964(true);
            payload.method_44116(this.world);
            payload.method_10807(this.pos);
        }
        if (this.id == null) {
            payload.method_52964(false);
        } else {
            payload.method_52964(true);
            payload.method_10812(this.id);
            this.state.writeToPayload(payload);
            payload.writeNbtCompound(this.nbt);
        }
    }

    @Override
    public class_2960 getPacketId() {
        return ID;
    }
}

