/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItem;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalItemStack;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.HandItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.InventoryItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ServerItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.reflect.Proxy;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_465;

public interface ItemReference
extends NBTReference<LocalItem> {
    public static ItemReference getHeldItem(Predicate<class_1799> isAllowed, class_2561 failText) throws CommandSyntaxException {
        class_1799 item = MainUtil.client.field_1724.method_6047();
        class_1268 hand = class_1268.field_5808;
        if (item == null || item.method_7960() || !isAllowed.test(item)) {
            item = MainUtil.client.field_1724.method_6079();
            hand = class_1268.field_5810;
        }
        if (item == null || item.method_7960() || !isAllowed.test(item)) {
            throw new SimpleCommandExceptionType((Message)failText).create();
        }
        return new HandItemReference(hand);
    }

    public static ItemReference getHeldItem() throws CommandSyntaxException {
        return ItemReference.getHeldItem(item -> true, TextInst.translatable("nbteditor.no_hand.no_item.to_edit", new Object[0]));
    }

    public static ItemReference getHeldItemAirable() {
        try {
            return ItemReference.getHeldItem();
        }
        catch (CommandSyntaxException e) {
            return new HandItemReference(class_1268.field_5808);
        }
    }

    public static ItemReference getHeldAir() throws CommandSyntaxException {
        if (MainUtil.client.field_1724.method_6047().method_7960()) {
            return new HandItemReference(class_1268.field_5808);
        }
        if (MainUtil.client.field_1724.method_6079().method_7960()) {
            return new HandItemReference(class_1268.field_5810);
        }
        throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.no_hand.all_item", new Object[0])).create();
    }

    public static ItemReference getContainerItem(class_465<?> screen, class_1735 slot) {
        if (slot.field_7871 == MainUtil.client.field_1724.method_31548()) {
            return new InventoryItemReference(slot.method_34266()).setParent(() -> NBTEditorClient.CURSOR_MANAGER.showBranch(screen));
        }
        return new ServerItemReference(screen, slot.field_7874);
    }

    public static <T extends LocalNBT> NBTReference<T> toItemStackRef(NBTReference<T> ref) {
        if (ref instanceof ItemReference) {
            ItemReference itemRef = (ItemReference)ref;
            return itemRef.toStackRef();
        }
        return ref;
    }

    @Deprecated
    public static <T extends LocalNBT> NBTReference<T> toItemPartsRef(NBTReference<T> ref) {
        if (ref instanceof ItemReference) {
            ItemReference itemRef = (ItemReference)ref;
            return itemRef.toPartsRef();
        }
        return ref;
    }

    default public ItemReference toStackRef() {
        return this;
    }

    @Deprecated
    default public ItemReference toPartsRef() {
        ItemReference stackRef = this;
        return (ItemReference)Proxy.newProxyInstance(ItemReference.class.getClassLoader(), new Class[]{ItemReference.class}, (obj, method, args) -> {
            if (method.getName().equals("toStackRef")) {
                return stackRef;
            }
            if (method.getName().equals("toPartsRef")) {
                return obj;
            }
            Object output = method.invoke((Object)stackRef, args);
            if (output instanceof LocalItem) {
                LocalItem localItem = (LocalItem)output;
                return localItem.toParts();
            }
            return output;
        });
    }

    @Override
    default public LocalItem getLocalNBT() {
        return new LocalItemStack(this.getItem());
    }

    @Override
    default public void saveLocalNBT(LocalItem nbt, Runnable onFinished) {
        this.saveItem(nbt.getReadableItem(), onFinished);
    }

    public class_1799 getItem();

    public void saveItem(class_1799 var1, Runnable var2);

    default public void saveItem(class_1799 toSave, class_2561 msg) {
        this.saveItem(toSave, () -> MainUtil.client.field_1724.method_7353(msg, false));
    }

    default public void saveItem(class_1799 toSave) {
        this.saveItem(toSave, () -> {});
    }

    public boolean isLocked();

    public boolean isLockable();

    public int getBlockedSlot();

    @Override
    default public class_2960 getId() {
        return MVRegistry.ITEM.getId(this.getItem().method_7909());
    }

    @Override
    default public class_2487 getNBT() {
        class_2487 nbt = this.getItem().manager$getNbt();
        if (nbt != null) {
            return nbt;
        }
        return new class_2487();
    }

    @Override
    default public void saveNBT(class_2960 id, class_2487 toSave, Runnable onFinished) {
        class_1799 item = this.getItem();
        if (!MVRegistry.ITEM.getId(item.method_7909()).equals((Object)id)) {
            item = MainUtil.setType(MVRegistry.ITEM.get(id), item);
        }
        item.manager$setNbt(toSave);
        this.saveItem(item, onFinished);
    }

    @Override
    public void showParent();
}

