/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.SaveQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1799;
import net.minecraft.class_437;

public class ContainerItemReference<L extends LocalNBT>
implements ItemReference {
    private final NBTReference<L> container;
    private final int slot;
    private final SaveQueue<class_1799> save;

    public ContainerItemReference(NBTReference<L> container, int slot) {
        this.container = container;
        this.slot = slot;
        this.save = new SaveQueue<class_1799>("Container", toSave -> {
            ContainerScreen screen;
            Object containerValue = LocalNBT.copy(container.getLocalNBT());
            class_1799[] contents = ContainerIO.read(containerValue);
            contents[slot] = toSave;
            ContainerIO.write(containerValue, contents);
            class_437 patt0$temp = MainUtil.client.field_1755;
            if (patt0$temp instanceof ContainerScreen && (screen = (ContainerScreen)patt0$temp).getReference() == container) {
                screen.method_17577().method_7611(slot).method_7673(toSave);
            }
            AtomicBoolean done = new AtomicBoolean();
            Object lock = new Object();
            container.saveLocalNBT(containerValue, () -> {
                done.set(true);
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            });
            Object object = lock;
            synchronized (object) {
                while (!done.get()) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }, true);
    }

    public NBTReference<L> getContainer() {
        return this.container;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public boolean exists() {
        if (!this.container.exists()) {
            return false;
        }
        L containerValue = this.container.getLocalNBT();
        return ContainerIO.isContainer(containerValue) && this.slot < ContainerIO.getMaxSize(containerValue);
    }

    @Override
    public class_1799 getItem() {
        L containerValue = this.container.getLocalNBT();
        class_1799[] contents = ContainerIO.read(containerValue);
        if (this.slot >= contents.length && this.slot < ContainerIO.getMaxSize(containerValue)) {
            return class_1799.field_8037;
        }
        return contents[this.slot];
    }

    @Override
    public void saveItem(class_1799 toSave, Runnable onFinished) {
        this.save.save(onFinished, toSave.method_7972());
    }

    @Override
    public boolean isLocked() {
        ItemReference item;
        NBTReference<L> nBTReference = this.container;
        return nBTReference instanceof ItemReference && (item = (ItemReference)nBTReference).isLocked();
    }

    @Override
    public boolean isLockable() {
        ItemReference item;
        NBTReference<L> nBTReference = this.container;
        return nBTReference instanceof ItemReference && (item = (ItemReference)nBTReference).isLockable();
    }

    @Override
    public int getBlockedSlot() {
        int n;
        NBTReference<L> nBTReference = this.container;
        if (nBTReference instanceof ItemReference) {
            ItemReference item = (ItemReference)nBTReference;
            n = item.getBlockedSlot();
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public void showParent() {
        ContainerScreen.show(this.container);
    }

    @Override
    public void escapeParent() {
        this.container.escapeParent();
    }
}

