/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChestHelper;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.PageLoadLevel;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.SaveQueue;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_437;

public class ClientChestItemReference
implements ItemReference {
    private final int page;
    private final int slot;
    private final SaveQueue<class_1799> save;

    public ClientChestItemReference(int page, int slot) {
        this.page = page;
        this.slot = slot;
        this.save = new SaveQueue<class_1799>("ClientChest/" + (page + 1) + "/" + slot, toSave -> ClientChestHelper.getPage(page, PageLoadLevel.DYNAMIC_ITEMS).join().ifPresent(pageData -> {
            class_437 patt0$temp = MainUtil.client.field_1755;
            if (patt0$temp instanceof ClientChestScreen) {
                ClientChestScreen screen = (ClientChestScreen)patt0$temp;
                if (ClientChestScreen.PAGE == page) {
                    ((class_1707)screen.method_17577()).method_7611(slot).method_7673(toSave);
                }
            }
            pageData.getItemsOrThrow()[slot] = toSave;
            pageData.dynamicItems().remove(slot);
            ClientChestHelper.setPage(page, pageData.items(), pageData.dynamicItems()).join();
        }), true);
    }

    public int getPage() {
        return this.page;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public boolean exists() {
        return this.page < NBTEditorClient.CLIENT_CHEST.getPageCount();
    }

    @Override
    public class_1799 getItem() {
        return ClientChestHelper.getPage(this.page, PageLoadLevel.DYNAMIC_ITEMS).join().orElseThrow().getItemsOrThrow()[this.slot];
    }

    @Override
    public void saveItem(class_1799 toSave, Runnable onFinished) {
        if (MainUtil.client.field_1755 instanceof ClientChestScreen && ClientChestScreen.PAGE == this.page) {
            ((class_1707)((ClientChestScreen)MainUtil.client.field_1755).method_17577()).method_7611(this.slot).method_7673(toSave);
        }
        this.save.save(onFinished, toSave.method_7972());
    }

    @Override
    public boolean isLocked() {
        return ConfigScreen.isLockSlots();
    }

    @Override
    public boolean isLockable() {
        return true;
    }

    @Override
    public int getBlockedSlot() {
        return -1;
    }

    @Override
    public void showParent() {
        ClientChestScreen.show();
    }
}

