/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.BlockReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.EntityReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;

public interface NBTReferenceFilter
extends Predicate<NBTReference<?>> {
    public static final NBTReferenceFilter ANY = NBTReferenceFilter.create(ref -> true, ref -> true, ref -> true, TextInst.translatable("nbteditor.no_ref.to_edit", new Object[0]), TextInst.translatable("nbteditor.no_hand.no_item.to_edit", new Object[0]));
    public static final NBTReferenceFilter ANY_NBT = NBTReferenceFilter.create(ref -> true, ref -> ref.getLocalNBT().isBlockEntity(), ref -> true, TextInst.translatable("nbteditor.no_ref.to_edit_nbt", new Object[0]), TextInst.translatable("nbteditor.no_hand.no_item.to_edit", new Object[0]));

    public static NBTReferenceFilter create(final Predicate<ItemReference> itemFilter, final Predicate<BlockReference> blockFilter, final Predicate<EntityReference> entityFilter, final Supplier<class_2561> failMsg) {
        return new NBTReferenceFilter(){

            @Override
            public boolean test(NBTReference<?> ref) {
                if (ref instanceof ItemReference) {
                    ItemReference item = (ItemReference)ref;
                    return itemFilter != null && itemFilter.test(item);
                }
                if (ref instanceof BlockReference) {
                    BlockReference block = (BlockReference)ref;
                    return blockFilter != null && blockFilter.test(block);
                }
                if (ref instanceof EntityReference) {
                    EntityReference entity = (EntityReference)ref;
                    return entityFilter != null && entityFilter.test(entity);
                }
                return false;
            }

            @Override
            public class_2561 getFailMessage() {
                return (class_2561)failMsg.get();
            }

            @Override
            public boolean isItemAllowed() {
                return itemFilter != null;
            }

            @Override
            public boolean isBlockAllowed() {
                return blockFilter != null;
            }

            @Override
            public boolean isEntityAllowed() {
                return entityFilter != null;
            }
        };
    }

    public static NBTReferenceFilter create(Predicate<ItemReference> itemFilter, Predicate<BlockReference> blockFilter, Predicate<EntityReference> entityFilter, class_2561 expandedFailMsg, class_2561 nonExpandedFailMsg) {
        return NBTReferenceFilter.create(itemFilter, blockFilter, entityFilter, () -> NBTEditorClient.SERVER_CONN.isEditingExpanded() ? expandedFailMsg : nonExpandedFailMsg);
    }

    public static NBTReferenceFilter create(Predicate<NBTReference<?>> filter, Supplier<class_2561> failMsg) {
        return NBTReferenceFilter.create(filter::test, filter::test, filter::test, failMsg);
    }

    public static NBTReferenceFilter create(Predicate<NBTReference<?>> filter, class_2561 expandedFailMsg, class_2561 nonExpandedFailMsg) {
        return NBTReferenceFilter.create(filter::test, filter::test, filter::test, expandedFailMsg, nonExpandedFailMsg);
    }

    public class_2561 getFailMessage();

    default public boolean isItemAllowed() {
        return true;
    }

    default public boolean isBlockAllowed() {
        return true;
    }

    default public boolean isEntityAllowed() {
        return true;
    }
}

