/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalNBT;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.BlockReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.EntityReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReferenceFilter;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.HandItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_1268;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;

public interface NBTReference<T extends LocalNBT> {
    public static CompletableFuture<? extends Optional<? extends NBTReference<?>>> getReference(NBTReferenceFilter filter, boolean airable) {
        class_239 target = MainUtil.client.field_1765;
        if (target instanceof class_3966) {
            class_3966 entity = (class_3966)target;
            if (filter.isEntityAllowed()) {
                return EntityReference.getEntity((class_5321<class_1937>)entity.method_17782().method_5770().method_27983(), entity.method_17782().method_5667()).thenApply(ref -> ref.map(UnaryOperator.identity()).filter(filter).or(() -> NBTReference.getClientReference(target, filter, airable)));
            }
        }
        if (target instanceof class_3965) {
            class_3965 block = (class_3965)target;
            if (filter.isBlockAllowed()) {
                return BlockReference.getBlock((class_5321<class_1937>)MainUtil.client.field_1687.method_27983(), block.method_17777()).thenApply(ref -> ref.map(UnaryOperator.identity()).filter(filter).or(() -> NBTReference.getClientReference(target, filter, airable)));
            }
        }
        return CompletableFuture.completedFuture(NBTReference.getClientReference(target, filter, airable));
    }

    private static Optional<? extends NBTReference<?>> getClientReference(class_239 target, NBTReferenceFilter filter, boolean airable) {
        BlockReference ref;
        class_3965 block;
        boolean heldItemDisallowed = false;
        if (filter.isItemAllowed()) {
            try {
                ItemReference ref2 = ItemReference.getHeldItem();
                if (filter.test(ref2)) {
                    return Optional.of(ref2);
                }
                heldItemDisallowed = true;
            }
            catch (CommandSyntaxException ref2) {
                // empty catch block
            }
        }
        if (filter.isBlockAllowed() && NBTEditorClient.SERVER_CONN.isEditingExpanded() && target instanceof class_3965 && (block = (class_3965)target).method_17783() != class_239.class_240.field_1333 && filter.test(ref = BlockReference.getBlockWithoutNBT(block.method_17777()))) {
            return Optional.of(ref);
        }
        if (airable && !heldItemDisallowed && filter.isItemAllowed()) {
            return Optional.of(new HandItemReference(class_1268.field_5808));
        }
        return Optional.empty();
    }

    public static void getReference(NBTReferenceFilter filter, boolean airable, Consumer<NBTReference<?>> consumer) {
        NBTReference.getReference(filter, airable).thenAccept(ref -> MainUtil.client.execute(() -> ref.ifPresentOrElse(consumer, () -> {
            if (MainUtil.client.field_1724 != null) {
                MainUtil.client.field_1724.method_7353(filter.getFailMessage(), false);
            }
        })));
    }

    public boolean exists();

    public T getLocalNBT();

    default public void saveLocalNBT(T nbt, Runnable onFinished) {
        this.saveNBT(nbt.getId(), nbt.getNBT(), onFinished);
    }

    default public void saveLocalNBT(T nbt, class_2561 msg) {
        this.saveLocalNBT(nbt, () -> MainUtil.client.field_1724.method_7353(msg, false));
    }

    default public void saveLocalNBT(T nbt) {
        this.saveLocalNBT(nbt, () -> {});
    }

    default public void modifyLocalNBT(Consumer<T> nbtConsumer, Runnable onFinished) {
        T nbt = this.getLocalNBT();
        nbtConsumer.accept(nbt);
        this.saveLocalNBT(nbt, onFinished);
    }

    default public void modifyLocalNBT(Consumer<T> nbtConsumer, class_2561 msg) {
        this.modifyLocalNBT(nbtConsumer, () -> MainUtil.client.field_1724.method_7353(msg, false));
    }

    default public void modifyLocalNBT(Consumer<T> nbtConsumer) {
        this.modifyLocalNBT(nbtConsumer, () -> {});
    }

    public class_2960 getId();

    public class_2487 getNBT();

    public void saveNBT(class_2960 var1, class_2487 var2, Runnable var3);

    default public void saveNBT(class_2960 id, class_2487 toSave, class_2561 msg) {
        this.saveNBT(id, toSave, () -> MainUtil.client.field_1724.method_7353(msg, false));
    }

    default public void saveNBT(class_2960 id, class_2487 toSave) {
        this.saveNBT(id, toSave, () -> {});
    }

    default public void showParent() {
        this.escapeParent();
    }

    default public void escapeParent() {
        NBTEditorClient.CURSOR_MANAGER.closeRoot();
    }
}

