/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalEntity;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVClientNetworking;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.packets.GetEntityC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SetEntityC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewEntityS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class EntityReference
implements NBTReference<LocalEntity> {
    private final class_5321<class_1937> world;
    private final UUID uuid;
    private class_1299<?> entityType;
    private class_2487 nbt;

    public static CompletableFuture<Optional<EntityReference>> getEntity(class_5321<class_1937> world, UUID uuid) {
        return NBTEditorClient.SERVER_CONN.sendRequest(requestId -> new GetEntityC2SPacket((int)requestId, world, uuid), ViewEntityS2CPacket.class).thenApply(optional -> optional.filter(ViewEntityS2CPacket::foundEntity).map(packet -> new EntityReference(packet.getWorld(), packet.getUUID(), MVRegistry.ENTITY_TYPE.get(packet.getId()), packet.getNbt())));
    }

    public EntityReference(class_5321<class_1937> world, UUID uuid, class_1299<?> entityType, class_2487 nbt) {
        this.world = world;
        this.uuid = uuid;
        this.entityType = entityType;
        this.nbt = nbt;
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public LocalEntity getLocalNBT() {
        return new LocalEntity(this.entityType, this.nbt);
    }

    @Override
    public class_2960 getId() {
        return class_1299.method_5890(this.entityType);
    }

    @Override
    public class_2487 getNBT() {
        return this.nbt;
    }

    @Override
    public void saveNBT(class_2960 id, class_2487 toSave, Runnable onFinished) {
        this.entityType = MVRegistry.ENTITY_TYPE.get(id);
        this.nbt = toSave;
        MVClientNetworking.send(new SetEntityC2SPacket(this.world, this.uuid, id, toSave, ConfigScreen.isRecreateBlocksAndEntities()));
        onFinished.run();
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }
}

