/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.nbtreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.localnbt.LocalBlock;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVClientNetworking;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVPacket;
import com.luneruniverse.minecraft.mod.nbteditor.nbtreferences.NBTReference;
import com.luneruniverse.minecraft.mod.nbteditor.packets.GetBlockC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.GetLecternBlockC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.SetBlockC2SPacket;
import com.luneruniverse.minecraft.mod.nbteditor.packets.ViewBlockS2CPacket;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.BlockStateProperties;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class BlockReference
implements NBTReference<LocalBlock> {
    private final class_5321<class_1937> world;
    private final class_2338 pos;
    private class_2248 block;
    private BlockStateProperties state;
    private class_2487 nbt;

    private static CompletableFuture<Optional<BlockReference>> getBlock(Function<Integer, MVPacket> packetFactory) {
        return NBTEditorClient.SERVER_CONN.sendRequest(packetFactory, ViewBlockS2CPacket.class).thenApply(optional -> optional.filter(ViewBlockS2CPacket::foundBlock).map(packet -> new BlockReference(packet.getWorld(), packet.getPos(), MVRegistry.BLOCK.get(packet.getId()), packet.getState(), packet.getNbt())));
    }

    public static CompletableFuture<Optional<BlockReference>> getBlock(class_5321<class_1937> world, class_2338 pos) {
        return BlockReference.getBlock(requestId -> new GetBlockC2SPacket((int)requestId, world, pos));
    }

    public static CompletableFuture<Optional<BlockReference>> getLecternBlock() {
        return BlockReference.getBlock(GetLecternBlockC2SPacket::new);
    }

    public static BlockReference getBlockWithoutNBT(class_2338 pos) {
        class_2680 state = MainUtil.client.field_1687.method_8320(pos);
        return new BlockReference((class_5321<class_1937>)MainUtil.client.field_1687.method_27983(), pos, state.method_26204(), new BlockStateProperties(state), new class_2487());
    }

    public BlockReference(class_5321<class_1937> world, class_2338 pos, class_2248 block, BlockStateProperties state, class_2487 nbt) {
        this.world = world;
        this.pos = pos;
        this.block = block;
        this.state = state;
        this.nbt = nbt;
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public LocalBlock getLocalNBT() {
        return new LocalBlock(this.block, this.state, this.nbt);
    }

    @Override
    public void saveLocalNBT(LocalBlock block, Runnable onFinished) {
        this.block = block.getBlock();
        this.state = block.getState();
        this.nbt = block.getNBT();
        MVClientNetworking.send(new SetBlockC2SPacket(this.world, this.pos, block.getId(), this.state, this.nbt, ConfigScreen.isRecreateBlocksAndEntities(), ConfigScreen.isTriggerBlockUpdates()));
        onFinished.run();
    }

    @Override
    public class_2960 getId() {
        return MVRegistry.BLOCK.getId(this.block);
    }

    @Override
    public class_2487 getNBT() {
        return this.nbt;
    }

    @Override
    public void saveNBT(class_2960 id, class_2487 toSave, Runnable onFinished) {
        this.block = MVRegistry.BLOCK.get(id);
        this.nbt = toSave;
        MVClientNetworking.send(new SetBlockC2SPacket(this.world, this.pos, id, this.state, toSave, ConfigScreen.isRecreateBlocksAndEntities(), ConfigScreen.isTriggerBlockUpdates()));
        onFinished.run();
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public BlockStateProperties getState() {
        return this.state;
    }

    public void saveState(BlockStateProperties state, Runnable onFinished) {
        this.state = state;
        MVClientNetworking.send(new SetBlockC2SPacket(this.world, this.pos, MVRegistry.BLOCK.getId(this.block), state, this.nbt, ConfigScreen.isRecreateBlocksAndEntities(), ConfigScreen.isTriggerBlockUpdates()));
        onFinished.run();
    }

    public void saveState(BlockStateProperties state, class_2561 msg) {
        this.saveState(state, () -> MainUtil.client.field_1724.method_7353(msg, false));
    }

    public void saveState(BlockStateProperties state) {
        this.saveState(state, () -> {});
    }
}

