/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVPacket;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVPacketCustomPayload;
import com.luneruniverse.minecraft.mod.nbteditor.server.ServerMVMisc;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class MVServerNetworking {
    private static final Map<class_2960, List<BiConsumer<MVPacket, class_3222>>> listeners = new HashMap<class_2960, List<BiConsumer<MVPacket, class_3222>>>();

    public static void onPlayStart(class_3222 player) {
        ((PlayNetworkStateEvents.Start)PlayNetworkStateEvents.Start.EVENT.invoker()).onPlayStart(player);
    }

    public static void onPlayStop(class_3222 player) {
        ((PlayNetworkStateEvents.Stop)PlayNetworkStateEvents.Stop.EVENT.invoker()).onPlayStop(player);
    }

    public static void send(class_3222 player, MVPacket packet) {
        ServerMVMisc.sendS2CPacket(player, (class_2596)Version.newSwitch().range("1.20.2", (String)null, () -> MVPacketCustomPayload.wrapS2C(packet)).range((String)null, "1.20.1", () -> {
            class_2540 payload = new class_2540(Unpooled.buffer());
            packet.write(payload);
            try {
                return (class_2658)class_2658.class.getConstructor(class_2960.class, class_2540.class).newInstance(packet.getPacketId(), payload);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create CustomPayloadS2CPacket", e);
            }
        }).get());
    }

    public static <T extends MVPacket> void registerListener(class_2960 id, BiConsumer<T, class_3222> listener) {
        listeners.computeIfAbsent(id, key -> new ArrayList()).add((packet, player) -> listener.accept((Object)packet, (class_3222)player));
    }

    public static void callListeners(MVPacket packet, class_3222 player) {
        if (!player.field_13995.method_18854()) {
            player.field_13995.execute(() -> MVServerNetworking.callListeners(packet, player));
            return;
        }
        List<BiConsumer<MVPacket, class_3222>> specificListeners = listeners.get(packet.getPacketId());
        if (specificListeners == null) {
            return;
        }
        specificListeners.forEach(listener -> listener.accept(packet, player));
    }

    public static class PlayNetworkStateEvents {

        public static interface Stop {
            public static final Event<Stop> EVENT = EventFactory.createArrayBacked(Stop.class, listeners -> player -> {
                for (Stop listener : listeners) {
                    listener.onPlayStop(player);
                }
            });

            public void onPlayStop(class_3222 var1);
        }

        public static interface Start {
            public static final Event<Start> EVENT = EventFactory.createArrayBacked(Start.class, listeners -> player -> {
                for (Start listener : listeners) {
                    listener.onPlayStart(player);
                }
            });

            public void onPlayStart(class_3222 var1);
        }
    }
}

