/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.DynamicRegistryManagerHolder;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVPacket;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.networking.MVPacketCustomPayload;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_634;

public class MVClientNetworking {
    private static final Map<class_2960, List<Consumer<MVPacket>>> listeners = new HashMap<class_2960, List<Consumer<MVPacket>>>();

    public static void onPlayStart(class_634 networkHandler) {
        Version.newSwitch().range("1.20.5", (String)null, () -> DynamicRegistryManagerHolder.setClientManager((class_2547)networkHandler)).range((String)null, "1.20.4", () -> {}).run();
        ((PlayNetworkStateEvents.Start)PlayNetworkStateEvents.Start.EVENT.invoker()).onPlayStart(networkHandler);
    }

    public static void onPlayJoin() {
        ((PlayNetworkStateEvents.Join)PlayNetworkStateEvents.Join.EVENT.invoker()).onPlayJoin();
    }

    public static void onPlayStop() {
        ((PlayNetworkStateEvents.Stop)PlayNetworkStateEvents.Stop.EVENT.invoker()).onPlayStop();
        Version.newSwitch().range("1.20.5", (String)null, () -> DynamicRegistryManagerHolder.setClientManager(null)).range((String)null, "1.20.4", () -> {}).run();
    }

    public static void send(MVPacket packet) {
        MVMisc.sendC2SPacket((class_2596)Version.newSwitch().range("1.20.2", (String)null, () -> MVPacketCustomPayload.wrapC2S(packet)).range((String)null, "1.20.1", () -> {
            class_2540 payload = new class_2540(Unpooled.buffer());
            packet.write(payload);
            try {
                return (class_2817)class_2817.class.getConstructor(class_2960.class, class_2540.class).newInstance(packet.getPacketId(), payload);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create CustomPayloadC2SPacket", e);
            }
        }).get());
    }

    public static <T extends MVPacket> void registerListener(class_2960 id, Consumer<T> listener) {
        listeners.computeIfAbsent(id, key -> new ArrayList()).add(packet -> listener.accept(packet));
    }

    public static void callListeners(MVPacket packet) {
        if (!MainUtil.client.method_18854()) {
            MainUtil.client.execute(() -> MVClientNetworking.callListeners(packet));
            return;
        }
        List<Consumer<MVPacket>> specificListeners = listeners.get(packet.getPacketId());
        if (specificListeners == null) {
            return;
        }
        specificListeners.forEach(listener -> listener.accept(packet));
    }

    public static class PlayNetworkStateEvents {

        public static interface Stop {
            public static final Event<Stop> EVENT = EventFactory.createArrayBacked(Stop.class, listeners -> () -> {
                for (Stop listener : listeners) {
                    listener.onPlayStop();
                }
            });

            public void onPlayStop();
        }

        public static interface Join {
            public static final Event<Join> EVENT = EventFactory.createArrayBacked(Join.class, listeners -> () -> {
                for (Join listener : listeners) {
                    listener.onPlayJoin();
                }
            });

            public void onPlayJoin();
        }

        public static interface Start {
            public static final Event<Start> EVENT = EventFactory.createArrayBacked(Start.class, listeners -> networkHandler -> {
                for (Start listener : listeners) {
                    listener.onPlayStart(networkHandler);
                }
            });

            public void onPlayStart(class_634 var1);
        }
    }
}

