/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion.nbt;

import java.util.Optional;

public record Attempt<T>(Optional<T> value, String error) {
    public Attempt {
        if (value.isEmpty() && error == null) {
            throw new IllegalArgumentException("Missing either a value or an error!");
        }
    }

    public Attempt(T value, String error) {
        this(Optional.of(value), error);
    }

    public Attempt(T value) {
        this(value, null);
    }

    public T getSuccessOrThrow() {
        if (this.error != null) {
            throw new IllegalStateException(this.error);
        }
        return this.value.get();
    }

    public T getAttemptOrThrow() {
        return this.value.orElseThrow(() -> new IllegalStateException(this.error));
    }

    public boolean isSuccessful() {
        return this.error == null;
    }
}

