/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.IdentifierInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Version {
    private static volatile int[] CURRENT;
    private static String releaseTarget;
    private static Integer dataVersion;
    private static Map<String, Integer> dataVersions;
    private static Map<Integer, String> mcVersions;

    public static <T> VersionSwitch<T> newSwitch(int[] version) {
        return new VersionSwitch(version);
    }

    public static <T> VersionSwitch<T> newSwitch() {
        return new VersionSwitch(Version.get());
    }

    public static int[] get() {
        if (CURRENT == null) {
            CURRENT = Version.parseVersion(Version.getReleaseTarget());
        }
        return CURRENT;
    }

    public static String getReleaseTarget() {
        if (releaseTarget == null) {
            Version.readVersionJson();
        }
        return releaseTarget;
    }

    public static int getDataVersion() {
        if (dataVersion == null) {
            Version.readVersionJson();
        }
        return dataVersion;
    }

    private static void readVersionJson() {
        try (InputStream in = Version.class.getResourceAsStream("/version.json");
             InputStreamReader reader = new InputStreamReader(in);){
            JsonObject data = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            if (data.has("release_target")) {
                releaseTarget = data.get("release_target").getAsString();
            } else {
                String id = data.get("id").getAsString();
                releaseTarget = id.split("\\+|-")[0];
            }
            dataVersion = data.get("world_version").getAsInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error trying to parse version.json", e);
        }
    }

    public static Optional<Integer> getDataVersion(String version) {
        try {
            return Optional.of(Integer.parseInt(version));
        }
        catch (NumberFormatException numberFormatException) {
            if (dataVersions == null) {
                Version.readDataVersionsJson();
            }
            return Optional.ofNullable(dataVersions.get(version));
        }
    }

    public static Optional<String> getMCVersion(int dataVersion) {
        if (mcVersions == null) {
            Version.readDataVersionsJson();
        }
        return Optional.ofNullable(mcVersions.get(dataVersion));
    }

    private static void readDataVersionsJson() {
        try (InputStream in = MVMisc.getResource(IdentifierInst.of("nbteditor", "data_versions.json")).orElseThrow();){
            dataVersions = (Map)new Gson().fromJson((Reader)new InputStreamReader(in), new TypeToken<Map<String, Integer>>(){}.getType());
            mcVersions = dataVersions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse data_versions.json", e);
        }
    }

    private static int[] parseVersion(String version) {
        int[] parts = Stream.of(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        if (parts[0] != 1 || parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Unsupported Minecraft version: " + version);
        }
        if (parts.length == 3) {
            return parts;
        }
        return new int[]{parts[0], parts[1], 0};
    }

    public static class VersionSwitch<T> {
        private final int[] version;
        private Supplier<T> match;

        private VersionSwitch(int[] version) {
            this.version = version;
        }

        public VersionSwitch<T> range(String min, String max, Supplier<T> value) {
            int[] minParts = min == null ? null : Version.parseVersion(min);
            int[] maxParts = max == null ? null : Version.parseVersion(max);
            boolean minMatch = min != null;
            boolean maxMatch = max != null;
            for (int i = 0; i < 3; ++i) {
                if (minMatch) {
                    if (minParts[i] < this.version[i]) {
                        minMatch = false;
                    } else if (minParts[i] > this.version[i]) {
                        return this;
                    }
                }
                if (!maxMatch) continue;
                if (this.version[i] < maxParts[i]) {
                    maxMatch = false;
                    continue;
                }
                if (this.version[i] <= maxParts[i]) continue;
                return this;
            }
            if (this.match != null) {
                throw new IllegalArgumentException("Overlapping versions!");
            }
            this.match = value;
            return this;
        }

        public VersionSwitch<T> range(String min, String max, T value) {
            return this.range(min, max, (T)((Supplier<Object>)() -> value));
        }

        public VersionSwitch<T> range(String min, String max, Runnable run) {
            return this.range(min, max, (T)((Supplier<Object>)() -> {
                run.run();
                return null;
            }));
        }

        public T get() {
            if (this.match == null) {
                throw new IllegalStateException("Missing version!");
            }
            return this.match.get();
        }

        public void run() {
            this.get();
        }

        public Optional<T> getOptionally() {
            if (this.match == null) {
                return Optional.empty();
            }
            return Optional.of(this.match.get());
        }

        public Optional<Runnable> runOptionally() {
            if (this.match == null) {
                return Optional.empty();
            }
            return Optional.of(() -> this.match.get());
        }
    }
}

