/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.DynamicRegistryManagerHolder;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Reflection;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class RegistryCache {
    private static final Map<class_5455, RegistryCache> caches = Collections.synchronizedMap(new WeakHashMap());
    private static final Supplier<Reflection.MethodInvoker> Registry_getEntry = Reflection.getOptionalMethod(class_2378.class, "method_55841", MethodType.methodType(Optional.class, class_2960.class));
    private static final Supplier<Reflection.MethodInvoker> Registry_getKey = Reflection.getOptionalMethod(class_2378.class, "method_30517", MethodType.methodType(class_5321.class));
    private static final LoadingCache<class_2378<?>, Boolean> staticRegistries = CacheBuilder.newBuilder().build(CacheLoader.from(registry -> (Boolean)((Object)Version.newSwitch().range("1.21.2", (String)null, () -> class_7923.field_41167.method_63535(registry.method_46765().method_29177()) != null).range((String)null, "1.21.1", () -> MVRegistry.REGISTRIES.get(((class_5321)Registry_getKey.get().invoke(registry, new Object[0])).method_29177()) != null).get())));
    private final WeakReference<class_5455> registryManagerRef;
    private final class_5455 registryManager;
    private final Map<class_2960, Optional<? extends class_2378<?>>> cache;
    private static final Supplier<Reflection.MethodInvoker> DynamicRegistryManager_getOptional = Reflection.getOptionalMethod(class_5455.class, "method_33310", MethodType.methodType(Optional.class, class_5321.class));

    public static RegistryCache get(class_5455 registryManager) {
        return caches.computeIfAbsent(registryManager, key -> new RegistryCache(registryManager, false));
    }

    public static <T> class_6880.class_6883<T> convertManagerWithCache(class_6880.class_6883<T> ref) {
        RegistryCache cache = RegistryCache.get(DynamicRegistryManagerHolder.getManager());
        class_2378 registry = cache.getRegistry(ref.method_40237().method_41185()).orElse(null);
        if (registry == null) {
            return null;
        }
        return ((Optional)((Object)Version.newSwitch().range("1.21.2", (String)null, () -> registry.method_10223(ref.method_40237().method_29177())).range((String)null, "1.21.1", () -> (Optional)Registry_getEntry.get().invoke(registry, ref.method_40237().method_29177())).get())).orElse(null);
    }

    public static boolean isRegistryStatic(class_2378<?> registry) {
        return (Boolean)staticRegistries.getUnchecked(registry);
    }

    public RegistryCache(class_5455 registryManager, boolean stronglyRef) {
        this.registryManagerRef = new WeakReference<class_5455>(registryManager);
        this.registryManager = stronglyRef ? registryManager : null;
        this.cache = new ConcurrentHashMap();
    }

    public RegistryCache(class_5455 registryManager) {
        this(registryManager, true);
    }

    public Optional<? extends class_2378<?>> getRegistry(class_2960 registryKey) {
        return this.cache.computeIfAbsent(registryKey, id -> {
            class_5455 registryManager = (class_5455)this.registryManagerRef.get();
            if (registryManager == null) {
                return Optional.empty();
            }
            return (Optional)((Object)Version.newSwitch().range("1.21.2", (String)null, () -> registryManager.method_46759(class_5321.method_29180((class_2960)id))).range((String)null, "1.21.1", () -> (Optional)DynamicRegistryManager_getOptional.get().invoke(registryManager, class_5321.method_29180((class_2960)id))).get());
        });
    }

    public <T> Optional<? extends class_2378<T>> getRegistry(class_5321<class_2378<T>> registryKey) {
        return this.getRegistry(registryKey.method_29177());
    }
}

