/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion;

import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Reflection;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.RegistryCache;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.server.NBTEditorServer;
import com.luneruniverse.minecraft.mod.nbteditor.util.CompletableFutureCache;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2547;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_4011;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_6861;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7876;
import net.minecraft.server.MinecraftServer;

public class DynamicRegistryManagerHolder {
    private static final CompletableFutureCache<class_5455> defaultManagerCache = new CompletableFutureCache(DynamicRegistryManagerHolder::loadDefaultManagerImpl);
    private static final Set<Thread> defaultManagerForced = ConcurrentHashMap.newKeySet();
    private static volatile RegistryCache defaultManagerRegistryCache;
    private static volatile class_5455 clientManager;
    private static volatile class_5455 serverManager;
    private static final Supplier<Reflection.MethodInvoker> RegistryLoader_loadFromResource;
    private static final boolean getReadOnlyWrapperExists;
    private static final Supplier<Reflection.MethodInvoker> Registry_getReadOnlyWrapper;

    private static CompletableFuture<class_5455> loadDefaultManagerImpl() {
        CompletableFuture<class_5455> future = new CompletableFuture<class_5455>();
        MixinLink.executeCrashableTask(() -> {
            if (MainUtil.client.method_1520().method_14444().isEmpty()) {
                MainUtil.client.method_1520().method_14445();
            }
            class_7780 combinedRegistries = class_7659.method_45139();
            class_6861 resourceManager = new class_6861(class_3264.field_14190, MainUtil.client.method_1520().method_29211());
            ArrayList entries = new ArrayList();
            entries.addAll(class_7655.field_39968);
            entries.addAll(class_7655.field_39969);
            class_5455.class_6890 dynamicRegistries = (class_5455.class_6890)Version.newSwitch().range("1.21.2", (String)null, () -> DynamicRegistryManagerHolder.lambda$loadDefaultManagerImpl$0((class_3300)resourceManager, combinedRegistries, entries)).range("1.20.5", "1.21.1", () -> DynamicRegistryManagerHolder.lambda$loadDefaultManagerImpl$1((class_3300)resourceManager, combinedRegistries, entries)).get();
            future.complete((class_5455)combinedRegistries.method_45930((Object)class_7659.field_39974, new class_5455.class_6890[]{dynamicRegistries}).method_45926());
        });
        return future;
    }

    public static class_4011 loadDefaultManager() {
        final CompletableFuture<class_5455> future = defaultManagerCache.get();
        return new class_4011(){

            public CompletableFuture<?> method_18364() {
                return future;
            }

            public float method_18229() {
                return future.isDone() ? 1.0f : 0.0f;
            }
        };
    }

    public static void onDefaultManagerLoad(Runnable callback) {
        defaultManagerCache.get().whenComplete((manager, e) -> MixinLink.executeCrashableTask(callback));
    }

    public static class_5455 getManager() {
        if (NBTEditorServer.isOnServerThread()) {
            if (serverManager == null) {
                throw new IllegalStateException("The server manager hasn't been set yet!");
            }
            return serverManager;
        }
        if (DynamicRegistryManagerHolder.hasClientManager()) {
            return clientManager;
        }
        if (MixinLink.isOnMainThread() && defaultManagerCache.getStatus() != CompletableFutureCache.Status.LOADED) {
            throw new RuntimeException("Cannot synchronously load the default manager on the main thread");
        }
        return defaultManagerCache.get().join();
    }

    public static class_7225.class_7874 get() {
        return DynamicRegistryManagerHolder.getManager();
    }

    public static void setClientManager(class_2547 listener) {
        clientManager = listener == null ? null : ((class_634)listener).method_29091();
    }

    public static void setServerManager(MinecraftServer server) {
        serverManager = server.method_30611();
    }

    public static boolean hasClientManager() {
        return !defaultManagerForced.contains(Thread.currentThread()) && clientManager != null;
    }

    public static <T> T withDefaultManager(Supplier<T> callback) {
        if (NBTEditorServer.isOnServerThread()) {
            throw new IllegalStateException("Cannot use withDefaultManager on the server!");
        }
        defaultManagerForced.add(Thread.currentThread());
        try {
            T t = callback.get();
            return t;
        }
        finally {
            defaultManagerForced.remove(Thread.currentThread());
        }
    }

    public static void withDefaultManager(Runnable callback) {
        DynamicRegistryManagerHolder.withDefaultManager(() -> {
            callback.run();
            return null;
        });
    }

    public static <T> boolean isOwnedByDefaultManager(class_6880.class_6883<T> entry) {
        class_2378 registry;
        if (NBTEditorServer.isOnServerThread() || defaultManagerCache.getStatus() != CompletableFutureCache.Status.LOADED) {
            return false;
        }
        if (defaultManagerRegistryCache == null) {
            defaultManagerRegistryCache = new RegistryCache(defaultManagerCache.get().join());
        }
        if ((registry = (class_2378)defaultManagerRegistryCache.getRegistry(entry.method_40237().method_41185()).orElse(null)) == null) {
            return false;
        }
        if (RegistryCache.isRegistryStatic(registry)) {
            return false;
        }
        return entry.field_40930.method_46767((class_7876)(getReadOnlyWrapperExists ? (class_7876)Registry_getReadOnlyWrapper.get().invoke(registry, new Object[0]) : registry));
    }

    private static /* synthetic */ class_5455.class_6890 lambda$loadDefaultManagerImpl$1(class_3300 resourceManager, class_7780 combinedRegistries, List entries) {
        return (class_5455.class_6890)RegistryLoader_loadFromResource.get().invoke(null, resourceManager, combinedRegistries.method_45926(), entries);
    }

    private static /* synthetic */ class_5455.class_6890 lambda$loadDefaultManagerImpl$0(class_3300 resourceManager, class_7780 combinedRegistries, List entries) {
        List tags = class_3503.method_61307((class_3300)resourceManager, (class_5455)combinedRegistries.method_45928((Object)class_7659.field_39971));
        class_5455.class_6890 preceding = combinedRegistries.method_45935((Object)class_7659.field_39974);
        List loadedRegistries = class_3503.method_61313((class_5455.class_6890)preceding, (List)tags);
        return class_7655.method_56515((class_3300)resourceManager, (List)loadedRegistries, (List)entries);
    }

    static {
        RegistryLoader_loadFromResource = Reflection.getOptionalMethod(class_7655.class, "method_56515", MethodType.methodType(class_5455.class_6890.class, class_3300.class, class_5455.class, List.class));
        getReadOnlyWrapperExists = Version.newSwitch().range("1.21.2", null, false).range(null, "1.21.1", true).get();
        Registry_getReadOnlyWrapper = Reflection.getOptionalMethod(class_2378.class, "method_46771", MethodType.methodType(class_7225.class_7226.class));
    }
}

